/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl.temporal;

import java.time.Clock;
import java.time.ZoneId;
import java.time.temporal.TemporalUnit;
import java.util.function.Supplier;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.impl.temporal.TemporalFunction;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.MapValue;

@Description(value="Creates a `LOCAL DATETIME` instant.")
class LocalDateTimeFunction
extends TemporalFunction<LocalDateTimeValue> {
    LocalDateTimeFunction(Supplier<ZoneId> defaultZone) {
        super((Neo4jTypes.AnyType)Neo4jTypes.NTLocalDateTime, defaultZone);
    }

    @Override
    protected LocalDateTimeValue now(Clock clock, String timezone, Supplier<ZoneId> defaultZone) {
        return timezone == null ? LocalDateTimeValue.now((Clock)clock, defaultZone) : LocalDateTimeValue.now((Clock)clock, (String)timezone);
    }

    @Override
    protected LocalDateTimeValue parse(TextValue value, Supplier<ZoneId> defaultZone) {
        return LocalDateTimeValue.parse((TextValue)value);
    }

    @Override
    protected LocalDateTimeValue build(MapValue map, Supplier<ZoneId> defaultZone) {
        return LocalDateTimeValue.build((MapValue)map, defaultZone);
    }

    @Override
    protected LocalDateTimeValue select(AnyValue from, Supplier<ZoneId> defaultZone) {
        return LocalDateTimeValue.select((AnyValue)from, defaultZone);
    }

    @Override
    protected LocalDateTimeValue truncate(TemporalUnit unit, TemporalValue input, MapValue fields, Supplier<ZoneId> defaultZone) {
        return LocalDateTimeValue.truncate((TemporalUnit)unit, (TemporalValue)input, (MapValue)fields, defaultZone);
    }

    @Override
    protected String getTemporalCypherTypeName() {
        return "LOCAL DATETIME";
    }
}

