/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.codegen.ClassGenerator;
import org.neo4j.codegen.ClassHandle;
import org.neo4j.codegen.CodeBlock;
import org.neo4j.codegen.CodeGenerationNotSupportedException;
import org.neo4j.codegen.CodeGenerationStrategy;
import org.neo4j.codegen.CodeGenerator;
import org.neo4j.codegen.CodeGeneratorOption;
import org.neo4j.codegen.CompilationFailureException;
import org.neo4j.codegen.Expression;
import org.neo4j.codegen.FieldReference;
import org.neo4j.codegen.MethodDeclaration;
import org.neo4j.codegen.MethodReference;
import org.neo4j.codegen.Parameter;
import org.neo4j.codegen.TryCatchCodeBlock;
import org.neo4j.codegen.TypeReference;
import org.neo4j.codegen.bytecode.ByteCode;
import org.neo4j.collection.ResourceRawIterator;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.UserAggregator;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.api.ResourceMonitor;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.CallableUserAggregationFunction;
import org.neo4j.kernel.api.procedure.CallableUserFunction;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.util.DefaultValueMapper;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.procedure.impl.BaseStreamIterator;
import org.neo4j.procedure.impl.FieldSetter;
import org.neo4j.procedure.impl.ProcedureOutputSignatureCompiler;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.ByteArray;
import org.neo4j.values.storable.ByteValue;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualPathValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;

public final class ProcedureCompilation {
    public static final ResourceRawIterator<AnyValue[], ProcedureException> VOID_ITERATOR = new ResourceRawIterator<AnyValue[], ProcedureException>(){

        public boolean hasNext() {
            return false;
        }

        public AnyValue[] next() {
            return EMPTY_ARRAY;
        }

        public void close() {
        }
    };
    private static final boolean DEBUG = false;
    private static final String LONG = Long.TYPE.getCanonicalName();
    private static final String BOXED_LONG = Long.class.getCanonicalName();
    private static final String DOUBLE = Double.TYPE.getCanonicalName();
    private static final String BOXED_DOUBLE = Double.class.getCanonicalName();
    private static final String BOOLEAN = Boolean.TYPE.getCanonicalName();
    private static final String BOXED_BOOLEAN = Boolean.class.getCanonicalName();
    private static final String NUMBER = Number.class.getCanonicalName();
    private static final String STRING = String.class.getCanonicalName();
    private static final String NODE = Node.class.getCanonicalName();
    private static final String RELATIONSHIP = Relationship.class.getCanonicalName();
    private static final String PATH = Path.class.getCanonicalName();
    private static final String POINT = Point.class.getCanonicalName();
    private static final String LIST = List.class.getCanonicalName();
    private static final String MAP = Map.class.getCanonicalName();
    private static final String BYTE_ARRAY = byte[].class.getCanonicalName();
    private static final String ZONED_DATE_TIME = ZonedDateTime.class.getCanonicalName();
    private static final String LOCAL_DATE_TIME = LocalDateTime.class.getCanonicalName();
    private static final String LOCAL_DATE = LocalDate.class.getCanonicalName();
    private static final String OFFSET_TIME = OffsetTime.class.getCanonicalName();
    private static final String LOCAL_TIME = LocalTime.class.getCanonicalName();
    private static final String TEMPORAL_AMOUNT = TemporalAmount.class.getCanonicalName();
    private static final String PACKAGE = "org.neo4j.kernel.impl.proc";
    private static final String SIGNATURE_NAME = "SIGNATURE";
    private static final String USER_CLASS = "userClass";
    private static final String VALUE_MAPPER_NAME = "MAPPER";
    private static final AnyValue[] EMPTY_ARRAY = new AnyValue[0];
    private static final MethodDeclaration.Builder USER_FUNCTION = MethodDeclaration.method(AnyValue.class, (String)"apply", (Parameter[])new Parameter[]{Parameter.param(Context.class, (String)"ctx"), Parameter.param(AnyValue[].class, (String)"input")}).throwsException(TypeReference.typeReference(ProcedureException.class));
    private static final MethodDeclaration.Builder USER_PROCEDURE = MethodDeclaration.method((TypeReference)TypeReference.parameterizedType(ResourceRawIterator.class, (TypeReference[])new TypeReference[]{TypeReference.typeReference(AnyValue[].class), TypeReference.typeReference(ProcedureException.class)}), (String)"apply", (Parameter[])new Parameter[]{Parameter.param(Context.class, (String)"ctx"), Parameter.param(AnyValue[].class, (String)"input"), Parameter.param(ResourceMonitor.class, (String)"monitor")}).throwsException(TypeReference.typeReference(ProcedureException.class));
    private static final MethodDeclaration.Builder AGGREGATION_CREATE = MethodDeclaration.method(UserAggregator.class, (String)"create", (Parameter[])new Parameter[]{Parameter.param(Context.class, (String)"ctx")}).throwsException(TypeReference.typeReference(ProcedureException.class));
    private static final MethodDeclaration.Builder AGGREGATION_UPDATE = MethodDeclaration.method(Void.TYPE, (String)"update", (Parameter[])new Parameter[]{Parameter.param(AnyValue[].class, (String)"input")}).throwsException(TypeReference.typeReference(ProcedureException.class));
    private static final MethodDeclaration.Builder AGGREGATION_RESULT = MethodDeclaration.method(AnyValue.class, (String)"result", (Parameter[])new Parameter[0]).throwsException(TypeReference.typeReference(ProcedureException.class));

    private ProcedureCompilation() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    static CallableUserFunction compileFunction(UserFunctionSignature signature, List<FieldSetter> fieldSetters, Method methodToCall, ClassLoader parentClassLoader) throws ProcedureException {
        try {
            ClassHandle handle;
            CodeGenerator codeGenerator = ProcedureCompilation.codeGenerator(parentClassLoader);
            try (ClassGenerator generator = codeGenerator.generateClass(PACKAGE, ProcedureCompilation.className(signature), CallableUserFunction.class, new Class[0]);){
                FieldReference signatureField = generator.publicStaticField(TypeReference.typeReference(UserFunctionSignature.class), SIGNATURE_NAME);
                List<FieldReference> fieldsToSet = ProcedureCompilation.createContextSetters(fieldSetters, generator);
                try (CodeBlock method = generator.generate(USER_FUNCTION);
                     TryCatchCodeBlock body = method.tryCatch(onError -> ProcedureCompilation.onError(onError, String.format("function `%s`", signature.name())), Parameter.param(Throwable.class, (String)"T"));){
                    ProcedureCompilation.functionBody((CodeBlock)body, fieldSetters, fieldsToSet, methodToCall);
                }
                method = generator.generateMethod(UserFunctionSignature.class, "signature", new Parameter[0]);
                try {
                    method.returns(Expression.getStatic((FieldReference)signatureField));
                }
                finally {
                    if (method != null) {
                        method.close();
                    }
                }
                handle = generator.handle();
            }
            Class clazz = handle.loadClass();
            ProcedureCompilation.setAllStaticFields(signature, fieldSetters, clazz);
            return (CallableUserFunction)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, e, "Failed to compile function defined in `%s`: %s", new Object[]{methodToCall.getDeclaringClass().getSimpleName(), e.getMessage()});
        }
    }

    static CallableProcedure compileProcedure(ProcedureSignature signature, List<FieldSetter> fieldSetters, Method methodToCall, ClassLoader parentClassLoader) throws ProcedureException {
        try {
            ClassHandle handle;
            CodeGenerator codeGenerator = ProcedureCompilation.codeGenerator(parentClassLoader);
            Class<?> iterator = ProcedureCompilation.generateIterator(codeGenerator, ProcedureCompilation.procedureType(methodToCall));
            try (ClassGenerator generator = codeGenerator.generateClass(PACKAGE, ProcedureCompilation.className(signature), CallableProcedure.class, new Class[0]);){
                FieldReference signatureField = generator.publicStaticField(TypeReference.typeReference(ProcedureSignature.class), SIGNATURE_NAME);
                List<FieldReference> fieldsToSet = ProcedureCompilation.createContextSetters(fieldSetters, generator);
                try (CodeBlock method = generator.generate(USER_PROCEDURE);
                     TryCatchCodeBlock body = method.tryCatch(onError -> ProcedureCompilation.onError(onError, String.format("procedure `%s`", signature.name())), Parameter.param(Throwable.class, (String)"T"));){
                    ProcedureCompilation.procedureBody((CodeBlock)body, fieldSetters, fieldsToSet, signatureField, methodToCall, iterator);
                }
                method = generator.generateMethod(ProcedureSignature.class, "signature", new Parameter[0]);
                try {
                    method.returns(Expression.getStatic((FieldReference)signatureField));
                }
                finally {
                    if (method != null) {
                        method.close();
                    }
                }
                handle = generator.handle();
            }
            Class clazz = handle.loadClass();
            ProcedureCompilation.setAllStaticFields(signature, fieldSetters, clazz);
            return (CallableProcedure)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, e, "Failed to compile procedure defined in `%s`: %s", new Object[]{methodToCall.getDeclaringClass().getSimpleName(), e.getMessage()});
        }
    }

    static CallableUserAggregationFunction compileAggregation(UserFunctionSignature signature, List<FieldSetter> fieldSetters, Method create, Method update, Method result, ClassLoader parentClassLoader) throws ProcedureException {
        try {
            ClassHandle handle;
            CodeGenerator codeGenerator = ProcedureCompilation.codeGenerator(parentClassLoader);
            Class<?> aggregator = ProcedureCompilation.generateAggregator(codeGenerator, update, result, signature);
            try (ClassGenerator generator = codeGenerator.generateClass(CallableUserAggregationFunction.BasicUserAggregationFunction.class, PACKAGE, ProcedureCompilation.className(signature), new Class[]{CallableUserAggregationFunction.class});){
                List<FieldReference> fieldsToSet = ProcedureCompilation.createContextSetters(fieldSetters, generator);
                try (CodeBlock constructor = generator.generateConstructor(new Parameter[]{Parameter.param(UserFunctionSignature.class, (String)"signature")});){
                    constructor.expression(Expression.invokeSuper((TypeReference)TypeReference.typeReference(CallableUserAggregationFunction.BasicUserAggregationFunction.class), (Expression[])new Expression[]{constructor.load("signature")}));
                }
                try (CodeBlock method = generator.generate(AGGREGATION_CREATE);
                     TryCatchCodeBlock body = method.tryCatch(onError -> ProcedureCompilation.onError(onError, String.format("function `%s`", signature.name())), Parameter.param(Throwable.class, (String)"T"));){
                    ProcedureCompilation.createAggregationBody((CodeBlock)body, fieldSetters, fieldsToSet, create, aggregator);
                }
                handle = generator.handle();
            }
            Class clazz = handle.loadClass();
            ProcedureCompilation.setAllStaticFields(fieldSetters, clazz);
            return (CallableUserAggregationFunction)clazz.getConstructor(UserFunctionSignature.class).newInstance(signature);
        }
        catch (Throwable e) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, e, "Failed to compile function defined in `%s`: %s", new Object[]{create.getDeclaringClass().getSimpleName(), e.getMessage()});
        }
    }

    public static ProcedureException rethrowProcedureException(Throwable throwable, String typeAndName) {
        if (throwable instanceof ProcedureException) {
            return (ProcedureException)throwable;
        }
        if (throwable instanceof Status.HasStatus) {
            return new ProcedureException(((Status.HasStatus)throwable).status(), throwable, throwable.getMessage(), new Object[]{throwable});
        }
        Throwable cause = ExceptionUtils.getRootCause((Throwable)throwable);
        return new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, throwable, "Failed to invoke %s: %s", new Object[]{typeAndName, "Caused by: " + (cause != null ? cause : throwable)});
    }

    public static byte[] toByteArray(AnyValue input) {
        if (input instanceof ByteArray) {
            return ((ByteArray)input).asObjectCopy();
        }
        if (input instanceof SequenceValue) {
            SequenceValue list = (SequenceValue)input;
            if (list.iterationPreference() == SequenceValue.IterationPreference.RANDOM_ACCESS) {
                byte[] bytes = new byte[list.intSize()];
                for (int a = 0; a < bytes.length; ++a) {
                    bytes[a] = ProcedureCompilation.asByte(list.value((long)a));
                }
                return bytes;
            }
            byte[] bytes = new byte[list.intSize()];
            int i = 0;
            for (AnyValue anyValue : list) {
                bytes[i++] = ProcedureCompilation.asByte(anyValue);
            }
            return bytes;
        }
        throw new IllegalArgumentException("Cannot convert " + input.getClass().getSimpleName() + " to byte[] for input to procedure");
    }

    private static Class<?> generateIterator(CodeGenerator codeGenerator, Class<?> outputType) {
        ClassHandle handle;
        if (outputType.equals(Void.TYPE)) {
            return VOID_ITERATOR.getClass();
        }
        try (ClassGenerator generator = codeGenerator.generateClass(BaseStreamIterator.class, PACKAGE, ProcedureCompilation.iteratorName(outputType), new Class[0]);){
            FieldReference context = generator.field(Context.class, "ctx");
            try (CodeBlock constructor = generator.generateConstructor(new Parameter[]{Parameter.param(Stream.class, (String)"stream"), Parameter.param(ResourceMonitor.class, (String)"monitor"), Parameter.param(ProcedureSignature.class, (String)"signature"), Parameter.param(Context.class, (String)"ctx")});){
                constructor.expression(Expression.invokeSuper((TypeReference)TypeReference.typeReference(BaseStreamIterator.class), (Expression[])new Expression[]{constructor.load("stream"), constructor.load("monitor"), constructor.load("signature")}));
                constructor.put(constructor.self(), context, constructor.load("ctx"));
            }
            try (CodeBlock method = generator.generate(MethodDeclaration.method(AnyValue[].class, (String)"map", (Parameter[])new Parameter[]{Parameter.param(Object.class, (String)"in")}));){
                method.assign(outputType, "casted", Expression.cast(outputType, (Expression)method.load("in")));
                List<Field> fields = ProcedureOutputSignatureCompiler.instanceFields(outputType);
                Expression[] mapped = new Expression[fields.size()];
                for (int i = 0; i < fields.size(); ++i) {
                    Field f = fields.get(i);
                    mapped[i] = outputType.isRecord() ? ProcedureCompilation.toAnyValue(Expression.invoke((Expression)method.load("casted"), (MethodReference)MethodReference.methodReference(outputType, f.getType(), (String)f.getName(), (Class[])new Class[0]), (Expression[])new Expression[0]), f.getType(), Expression.get((Expression)method.self(), (FieldReference)context)) : ProcedureCompilation.toAnyValue(Expression.get((Expression)method.load("casted"), (FieldReference)FieldReference.field((Field)f)), f.getType(), Expression.get((Expression)method.self(), (FieldReference)context));
                }
                method.returns(Expression.newInitializedArray((TypeReference)TypeReference.typeReference(AnyValue.class), (Expression[])mapped));
            }
            handle = generator.handle();
        }
        try {
            return handle.loadClass();
        }
        catch (CompilationFailureException e) {
            throw new RuntimeException("Failed to generate iterator", e);
        }
    }

    private static Class<?> generateAggregator(CodeGenerator codeGenerator, Method update, Method result, UserFunctionSignature signature) {
        ClassHandle handle;
        assert (update.getDeclaringClass().equals(result.getDeclaringClass()));
        Class<?> userAggregatorClass = update.getDeclaringClass();
        try (ClassGenerator generator = codeGenerator.generateClass(PACKAGE, "Aggregator" + userAggregatorClass.getSimpleName() + System.nanoTime(), UserAggregator.class, new Class[0]);){
            TryCatchCodeBlock body;
            FieldReference aggregator = generator.field(userAggregatorClass, "aggregator");
            FieldReference context = generator.field(Context.class, "ctx");
            try (CodeBlock constructor = generator.generateConstructor(new Parameter[]{Parameter.param(userAggregatorClass, (String)"aggregator"), Parameter.param(Context.class, (String)"ctx")});){
                constructor.expression(Expression.invokeSuper((TypeReference)TypeReference.OBJECT, (Expression[])new Expression[0]));
                constructor.put(constructor.self(), aggregator, constructor.load("aggregator"));
                constructor.put(constructor.self(), context, constructor.load("ctx"));
            }
            try (CodeBlock block = generator.generate(AGGREGATION_UPDATE);){
                body = block.tryCatch(onError -> ProcedureCompilation.onError(onError, String.format("function `%s`", signature.name())), Parameter.param(Throwable.class, (String)"T"));
                try {
                    body.expression(Expression.invoke((Expression)Expression.get((Expression)body.self(), (FieldReference)aggregator), (MethodReference)MethodReference.methodReference((Method)update), (Expression[])ProcedureCompilation.parameters((CodeBlock)body, update, Expression.get((Expression)body.self(), (FieldReference)context))));
                }
                finally {
                    if (body != null) {
                        body.close();
                    }
                }
            }
            block = generator.generate(AGGREGATION_RESULT);
            try {
                body = block.tryCatch(onError -> ProcedureCompilation.onError(onError, String.format("function `%s`", signature.name())), Parameter.param(Throwable.class, (String)"T"));
                try {
                    body.returns(ProcedureCompilation.toAnyValue((CodeBlock)body, "result", Expression.invoke((Expression)Expression.get((Expression)body.self(), (FieldReference)aggregator), (MethodReference)MethodReference.methodReference((Method)result), (Expression[])new Expression[0]), result.getReturnType(), Expression.get((Expression)body.self(), (FieldReference)context)));
                }
                finally {
                    if (body != null) {
                        body.close();
                    }
                }
            }
            finally {
                if (block != null) {
                    block.close();
                }
            }
            handle = generator.handle();
        }
        try {
            return handle.loadClass();
        }
        catch (CompilationFailureException e) {
            throw new RuntimeException("Failed to generate iterator", e);
        }
    }

    private static String className(UserFunctionSignature signature) {
        return String.format("GeneratedFunction_%s%d", signature.name().name(), System.nanoTime());
    }

    private static String className(ProcedureSignature signature) {
        return String.format("GeneratedProcedure_%s%d", signature.name().name(), System.nanoTime());
    }

    private static String iteratorName(Class<?> out) {
        return String.format("Iterator_%s%d", out.getSimpleName(), System.nanoTime());
    }

    private static void functionBody(CodeBlock block, List<FieldSetter> fieldSetters, List<FieldReference> fieldsToSet, Method methodToCall) {
        block.assign(TypeReference.typeReference(methodToCall.getDeclaringClass()), USER_CLASS, Expression.invoke((Expression)Expression.newInstance(methodToCall.getDeclaringClass()), (MethodReference)MethodReference.constructorReference(methodToCall.getDeclaringClass(), (TypeReference[])new TypeReference[0]), (Expression[])new Expression[0]));
        ProcedureCompilation.injectFields(block, fieldSetters, fieldsToSet);
        Expression[] parameters = ProcedureCompilation.parameters(block, methodToCall, block.load("ctx"));
        block.assign(methodToCall.getReturnType(), "fromFunction", Expression.invoke((Expression)block.load(USER_CLASS), (MethodReference)MethodReference.methodReference((Method)methodToCall), (Expression[])parameters));
        block.returns(ProcedureCompilation.toAnyValue(block.load("fromFunction"), methodToCall.getReturnType(), block.load("ctx")));
    }

    private static void procedureBody(CodeBlock block, List<FieldSetter> fieldSetters, List<FieldReference> fieldsToSet, FieldReference signature, Method methodToCall, Class<?> iterator) {
        block.assign(TypeReference.typeReference(methodToCall.getDeclaringClass()), USER_CLASS, Expression.invoke((Expression)Expression.newInstance(methodToCall.getDeclaringClass()), (MethodReference)MethodReference.constructorReference(methodToCall.getDeclaringClass(), (TypeReference[])new TypeReference[0]), (Expression[])new Expression[0]));
        ProcedureCompilation.injectFields(block, fieldSetters, fieldsToSet);
        Expression[] parameters = ProcedureCompilation.parameters(block, methodToCall, block.load("ctx"));
        if (iterator.equals(VOID_ITERATOR.getClass())) {
            block.expression(Expression.invoke((Expression)block.load(USER_CLASS), (MethodReference)MethodReference.methodReference((Method)methodToCall), (Expression[])parameters));
            block.returns(Expression.getStatic((FieldReference)FieldReference.field((TypeReference)TypeReference.typeReference(ProcedureCompilation.class), (TypeReference)TypeReference.typeReference(ResourceRawIterator.class), (String)"VOID_ITERATOR")));
        } else {
            block.assign(TypeReference.parameterizedType(Stream.class, (Class[])new Class[]{ProcedureCompilation.procedureType(methodToCall)}), "fromProcedure", Expression.invoke((Expression)block.load(USER_CLASS), (MethodReference)MethodReference.methodReference((Method)methodToCall), (Expression[])parameters));
            block.returns(Expression.invoke((Expression)Expression.newInstance(iterator), (MethodReference)MethodReference.constructorReference(iterator, Stream.class, (Class[])new Class[]{ResourceMonitor.class, ProcedureSignature.class, Context.class}), (Expression[])new Expression[]{block.load("fromProcedure"), block.load("monitor"), Expression.getStatic((FieldReference)signature), block.load("ctx")}));
        }
    }

    private static Class<?> procedureType(Method method) {
        if (method.getReturnType().equals(Void.TYPE)) {
            return Void.TYPE;
        }
        ParameterizedType returnType = (ParameterizedType)method.getGenericReturnType();
        return (Class)returnType.getActualTypeArguments()[0];
    }

    private static void createAggregationBody(CodeBlock block, List<FieldSetter> fieldSetters, List<FieldReference> fieldsToSet, Method createMethod, Class<?> aggregator) {
        block.assign(TypeReference.typeReference(createMethod.getDeclaringClass()), USER_CLASS, Expression.invoke((Expression)Expression.newInstance(createMethod.getDeclaringClass()), (MethodReference)MethodReference.constructorReference(createMethod.getDeclaringClass(), (TypeReference[])new TypeReference[0]), (Expression[])new Expression[0]));
        ProcedureCompilation.injectFields(block, fieldSetters, fieldsToSet);
        block.assign(createMethod.getReturnType(), "fromUser", Expression.invoke((Expression)block.load(USER_CLASS), (MethodReference)MethodReference.methodReference((Method)createMethod), (Expression[])new Expression[0]));
        block.returns(Expression.invoke((Expression)Expression.newInstance(aggregator), (MethodReference)MethodReference.constructorReference(aggregator, createMethod.getReturnType(), (Class[])new Class[]{Context.class}), (Expression[])new Expression[]{block.load("fromUser"), block.load("ctx")}));
    }

    private static void onError(CodeBlock block, String typeAndName) {
        block.throwException(Expression.invoke((MethodReference)MethodReference.methodReference(ProcedureCompilation.class, ProcedureException.class, (String)"rethrowProcedureException", (Class[])new Class[]{Throwable.class, String.class}), (Expression[])new Expression[]{block.load("T"), Expression.constant((Object)typeAndName)}));
    }

    private static Expression unboxIfNecessary(Class<?> fieldType, Expression invoke) {
        if (fieldType.isPrimitive()) {
            return Expression.unbox((Expression)Expression.cast((TypeReference)TypeReference.toBoxedType((TypeReference)TypeReference.typeReference(fieldType)), (Expression)invoke));
        }
        return Expression.cast(fieldType, (Expression)invoke);
    }

    private static CodeGenerator codeGenerator(ClassLoader parentClassLoader) throws CodeGenerationNotSupportedException {
        return CodeGenerator.generateCode((ClassLoader)parentClassLoader, (CodeGenerationStrategy)ByteCode.BYTECODE, (CodeGeneratorOption[])new CodeGeneratorOption[0]);
    }

    private static byte asByte(AnyValue value) {
        if (value instanceof ByteValue) {
            return ((ByteValue)value).value();
        }
        throw new IllegalArgumentException("Cannot convert " + value.map((ValueMapper)new DefaultValueMapper(null)) + " to byte for input to procedure");
    }

    private static Expression toAnyValue(CodeBlock block, String expressionVariableName, Expression expression, Class<?> userType, Expression context) {
        block.assign(userType, expressionVariableName, expression);
        return ProcedureCompilation.toAnyValue(block.load(expressionVariableName), userType, context);
    }

    private static Expression toAnyValue(Expression expression, Class<?> userType, Expression context) {
        if (AnyValue.class.isAssignableFrom(userType)) {
            return ProcedureCompilation.nullCheck(expression, Expression.cast(userType, (Expression)expression));
        }
        String type = userType.getCanonicalName();
        if (type.equals(LONG)) {
            return Expression.invoke((MethodReference)MethodReference.methodReference(Values.class, LongValue.class, (String)"longValue", (Class[])new Class[]{Long.TYPE}), (Expression[])new Expression[]{expression});
        }
        if (type.equals(BOXED_LONG)) {
            return ProcedureCompilation.nullCheck(expression, Expression.invoke((MethodReference)MethodReference.methodReference(Values.class, LongValue.class, (String)"longValue", (Class[])new Class[]{Long.TYPE}), (Expression[])new Expression[]{Expression.unbox((Expression)expression)}));
        }
        if (type.equals(DOUBLE)) {
            return Expression.invoke((MethodReference)MethodReference.methodReference(Values.class, DoubleValue.class, (String)"doubleValue", (Class[])new Class[]{Double.TYPE}), (Expression[])new Expression[]{expression});
        }
        if (type.equals(BOXED_DOUBLE)) {
            return ProcedureCompilation.nullCheck(expression, Expression.invoke((MethodReference)MethodReference.methodReference(Values.class, DoubleValue.class, (String)"doubleValue", (Class[])new Class[]{Double.TYPE}), (Expression[])new Expression[]{Expression.unbox((Expression)expression)}));
        }
        if (type.equals(NUMBER)) {
            return ProcedureCompilation.nullCheck(expression, Expression.invoke((MethodReference)MethodReference.methodReference(Values.class, NumberValue.class, (String)"numberValue", (Class[])new Class[]{Number.class}), (Expression[])new Expression[]{expression}));
        }
        if (type.equals(BOOLEAN)) {
            return Expression.invoke((MethodReference)MethodReference.methodReference(Values.class, BooleanValue.class, (String)"booleanValue", (Class[])new Class[]{Boolean.TYPE}), (Expression[])new Expression[]{expression});
        }
        if (type.equals(BOXED_BOOLEAN)) {
            return ProcedureCompilation.nullCheck(expression, Expression.invoke((MethodReference)MethodReference.methodReference(Values.class, BooleanValue.class, (String)"booleanValue", (Class[])new Class[]{Boolean.TYPE}), (Expression[])new Expression[]{Expression.unbox((Expression)expression)}));
        }
        if (type.equals(STRING)) {
            return Expression.invoke((MethodReference)MethodReference.methodReference(Values.class, Value.class, (String)"stringOrNoValue", (Class[])new Class[]{String.class}), (Expression[])new Expression[]{expression});
        }
        if (type.equals(BYTE_ARRAY)) {
            return ProcedureCompilation.nullCheck(expression, Expression.invoke((MethodReference)MethodReference.methodReference(Values.class, ByteArray.class, (String)"byteArray", (Class[])new Class[]{byte[].class}), (Expression[])new Expression[]{expression}));
        }
        if (type.equals(LIST)) {
            return ProcedureCompilation.nullCheck(expression, Expression.invoke((MethodReference)MethodReference.methodReference(ValueUtils.class, ListValue.class, (String)"asListValue", (Class[])new Class[]{Iterable.class, Boolean.TYPE}), (Expression[])new Expression[]{expression, Expression.constant((Object)true)}));
        }
        if (type.equals(MAP)) {
            return ProcedureCompilation.nullCheck(expression, Expression.invoke((MethodReference)MethodReference.methodReference(ValueUtils.class, MapValue.class, (String)"asMapValue", (Class[])new Class[]{Map.class, Boolean.TYPE}), (Expression[])new Expression[]{expression, Expression.constant((Object)true)}));
        }
        if (type.equals(ZONED_DATE_TIME)) {
            return ProcedureCompilation.nullCheck(expression, Expression.invoke((MethodReference)MethodReference.methodReference(DateTimeValue.class, DateTimeValue.class, (String)"datetime", (Class[])new Class[]{ZonedDateTime.class}), (Expression[])new Expression[]{expression}));
        }
        if (type.equals(OFFSET_TIME)) {
            return ProcedureCompilation.nullCheck(expression, Expression.invoke((MethodReference)MethodReference.methodReference(TimeValue.class, TimeValue.class, (String)"time", (Class[])new Class[]{OffsetTime.class}), (Expression[])new Expression[]{expression}));
        }
        if (type.equals(LOCAL_DATE)) {
            return ProcedureCompilation.nullCheck(expression, Expression.invoke((MethodReference)MethodReference.methodReference(DateValue.class, DateValue.class, (String)"date", (Class[])new Class[]{LocalDate.class}), (Expression[])new Expression[]{expression}));
        }
        if (type.equals(LOCAL_TIME)) {
            return ProcedureCompilation.nullCheck(expression, Expression.invoke((MethodReference)MethodReference.methodReference(LocalTimeValue.class, LocalTimeValue.class, (String)"localTime", (Class[])new Class[]{LocalTime.class}), (Expression[])new Expression[]{expression}));
        }
        if (type.equals(LOCAL_DATE_TIME)) {
            return ProcedureCompilation.nullCheck(expression, Expression.invoke((MethodReference)MethodReference.methodReference(LocalDateTimeValue.class, LocalDateTimeValue.class, (String)"localDateTime", (Class[])new Class[]{LocalDateTime.class}), (Expression[])new Expression[]{expression}));
        }
        if (type.equals(TEMPORAL_AMOUNT)) {
            return ProcedureCompilation.nullCheck(expression, Expression.invoke((MethodReference)MethodReference.methodReference(Values.class, DurationValue.class, (String)"durationValue", (Class[])new Class[]{TemporalAmount.class}), (Expression[])new Expression[]{expression}));
        }
        if (type.equals(NODE)) {
            Expression internalTransaction = Expression.invoke((Expression)context, (MethodReference)MethodReference.methodReference(Context.class, InternalTransaction.class, (String)"internalTransactionOrNull", (Class[])new Class[0]), (Expression[])new Expression[0]);
            Expression dbValidation = Expression.invoke((Expression)internalTransaction, (MethodReference)MethodReference.methodReference(InternalTransaction.class, Entity.class, (String)"validateSameDB", (Class[])new Class[]{Entity.class}), (Expression[])new Expression[]{expression});
            Expression getNode = Expression.ternary((Expression)Expression.equal((Expression)internalTransaction, (Expression)Expression.constant(null)), (Expression)expression, (Expression)dbValidation);
            return ProcedureCompilation.nullCheck(expression, Expression.invoke((MethodReference)MethodReference.methodReference(ValueUtils.class, VirtualNodeValue.class, (String)"maybeWrapNodeEntity", (Class[])new Class[]{Node.class}), (Expression[])new Expression[]{getNode}));
        }
        if (type.equals(RELATIONSHIP)) {
            Expression internalTransaction = Expression.invoke((Expression)context, (MethodReference)MethodReference.methodReference(Context.class, InternalTransaction.class, (String)"internalTransactionOrNull", (Class[])new Class[0]), (Expression[])new Expression[0]);
            Expression dbValidation = Expression.invoke((Expression)internalTransaction, (MethodReference)MethodReference.methodReference(InternalTransaction.class, Entity.class, (String)"validateSameDB", (Class[])new Class[]{Entity.class}), (Expression[])new Expression[]{expression});
            Expression getRelationship = Expression.ternary((Expression)Expression.equal((Expression)internalTransaction, (Expression)Expression.constant(null)), (Expression)expression, (Expression)dbValidation);
            return ProcedureCompilation.nullCheck(expression, Expression.invoke((MethodReference)MethodReference.methodReference(ValueUtils.class, VirtualRelationshipValue.class, (String)"maybeWrapRelationshipEntity", (Class[])new Class[]{Relationship.class}), (Expression[])new Expression[]{getRelationship}));
        }
        if (type.equals(PATH)) {
            return ProcedureCompilation.nullCheck(expression, Expression.invoke((MethodReference)MethodReference.methodReference(ValueUtils.class, VirtualPathValue.class, (String)"maybeWrapPath", (Class[])new Class[]{Path.class}), (Expression[])new Expression[]{expression}));
        }
        if (type.equals(POINT)) {
            return ProcedureCompilation.nullCheck(expression, Expression.invoke((MethodReference)MethodReference.methodReference(ValueUtils.class, PointValue.class, (String)"asPointValue", (Class[])new Class[]{Point.class}), (Expression[])new Expression[]{expression}));
        }
        return Expression.invoke((MethodReference)MethodReference.methodReference(ValueUtils.class, AnyValue.class, (String)"of", (Class[])new Class[]{Object.class, Boolean.TYPE}), (Expression[])new Expression[]{expression, Expression.constant((Object)true)});
    }

    private static Expression fromAnyValue(Class<?> expectedType, Expression expression, CodeBlock block, Expression context) {
        if (AnyValue.class.isAssignableFrom(expectedType)) {
            return Expression.cast(expectedType, (Expression)expression);
        }
        String type = expectedType.getCanonicalName();
        if (type.equals(LONG)) {
            return Expression.invoke((Expression)Expression.cast(NumberValue.class, (Expression)expression), (MethodReference)MethodReference.methodReference(NumberValue.class, Long.TYPE, (String)"longValue", (Class[])new Class[0]), (Expression[])new Expression[0]);
        }
        if (type.equals(BOXED_LONG)) {
            return ProcedureCompilation.noValueCheck(expression, Expression.box((Expression)Expression.invoke((Expression)Expression.cast(NumberValue.class, (Expression)expression), (MethodReference)MethodReference.methodReference(NumberValue.class, Long.TYPE, (String)"longValue", (Class[])new Class[0]), (Expression[])new Expression[0])));
        }
        if (type.equals(DOUBLE)) {
            return Expression.invoke((Expression)Expression.cast(NumberValue.class, (Expression)expression), (MethodReference)MethodReference.methodReference(NumberValue.class, Double.TYPE, (String)"doubleValue", (Class[])new Class[0]), (Expression[])new Expression[0]);
        }
        if (type.equals(BOXED_DOUBLE)) {
            return ProcedureCompilation.noValueCheck(expression, Expression.box((Expression)Expression.invoke((Expression)Expression.cast(NumberValue.class, (Expression)expression), (MethodReference)MethodReference.methodReference(NumberValue.class, Double.TYPE, (String)"doubleValue", (Class[])new Class[0]), (Expression[])new Expression[0])));
        }
        if (type.equals(NUMBER)) {
            return ProcedureCompilation.noValueCheck(expression, Expression.invoke((Expression)Expression.cast(NumberValue.class, (Expression)expression), (MethodReference)MethodReference.methodReference(NumberValue.class, Number.class, (String)"asObjectCopy", (Class[])new Class[0]), (Expression[])new Expression[0]));
        }
        if (type.equals(BOOLEAN)) {
            return Expression.invoke((Expression)Expression.cast(BooleanValue.class, (Expression)expression), (MethodReference)MethodReference.methodReference(BooleanValue.class, Boolean.TYPE, (String)"booleanValue", (Class[])new Class[0]), (Expression[])new Expression[0]);
        }
        if (type.equals(BOXED_BOOLEAN)) {
            return ProcedureCompilation.noValueCheck(expression, Expression.box((Expression)Expression.invoke((Expression)Expression.cast(BooleanValue.class, (Expression)expression), (MethodReference)MethodReference.methodReference(BooleanValue.class, Boolean.TYPE, (String)"booleanValue", (Class[])new Class[0]), (Expression[])new Expression[0])));
        }
        if (type.equals(STRING)) {
            return ProcedureCompilation.noValueCheck(expression, Expression.invoke((Expression)Expression.cast(TextValue.class, (Expression)expression), (MethodReference)MethodReference.methodReference(TextValue.class, String.class, (String)"stringValue", (Class[])new Class[0]), (Expression[])new Expression[0]));
        }
        if (type.equals(BYTE_ARRAY)) {
            return ProcedureCompilation.noValueCheck(expression, Expression.invoke((MethodReference)MethodReference.methodReference(ProcedureCompilation.class, byte[].class, (String)"toByteArray", (Class[])new Class[]{AnyValue.class}), (Expression[])new Expression[]{expression}));
        }
        if (type.equals(ZONED_DATE_TIME)) {
            return ProcedureCompilation.noValueCheck(expression, Expression.cast(ZonedDateTime.class, (Expression)Expression.invoke((Expression)Expression.cast(DateTimeValue.class, (Expression)expression), (MethodReference)MethodReference.methodReference(DateTimeValue.class, Temporal.class, (String)"asObjectCopy", (Class[])new Class[0]), (Expression[])new Expression[0])));
        }
        if (type.equals(OFFSET_TIME)) {
            return ProcedureCompilation.noValueCheck(expression, Expression.cast(OffsetTime.class, (Expression)Expression.invoke((Expression)Expression.cast(TimeValue.class, (Expression)expression), (MethodReference)MethodReference.methodReference(TimeValue.class, Temporal.class, (String)"asObjectCopy", (Class[])new Class[0]), (Expression[])new Expression[0])));
        }
        if (type.equals(LOCAL_DATE)) {
            return ProcedureCompilation.noValueCheck(expression, Expression.cast(LocalDate.class, (Expression)Expression.invoke((Expression)Expression.cast(DateValue.class, (Expression)expression), (MethodReference)MethodReference.methodReference(DateValue.class, Temporal.class, (String)"asObjectCopy", (Class[])new Class[0]), (Expression[])new Expression[0])));
        }
        if (type.equals(LOCAL_TIME)) {
            return ProcedureCompilation.noValueCheck(expression, Expression.cast(LocalTime.class, (Expression)Expression.invoke((Expression)Expression.cast(LocalTimeValue.class, (Expression)expression), (MethodReference)MethodReference.methodReference(LocalTimeValue.class, Temporal.class, (String)"asObjectCopy", (Class[])new Class[0]), (Expression[])new Expression[0])));
        }
        if (type.equals(LOCAL_DATE_TIME)) {
            return ProcedureCompilation.noValueCheck(expression, Expression.cast(LocalDateTime.class, (Expression)Expression.invoke((Expression)Expression.cast(LocalDateTimeValue.class, (Expression)expression), (MethodReference)MethodReference.methodReference(LocalDateTimeValue.class, Temporal.class, (String)"asObjectCopy", (Class[])new Class[0]), (Expression[])new Expression[0])));
        }
        if (type.equals(TEMPORAL_AMOUNT)) {
            return ProcedureCompilation.noValueCheck(expression, Expression.cast(TemporalAmount.class, (Expression)expression));
        }
        if (type.equals(POINT)) {
            return ProcedureCompilation.noValueCheck(expression, Expression.invoke((Expression)Expression.cast(PointValue.class, (Expression)expression), (MethodReference)MethodReference.methodReference(PointValue.class, Point.class, (String)"asObjectCopy", (Class[])new Class[0]), (Expression[])new Expression[0]));
        }
        return Expression.cast(expectedType, (Expression)Expression.invoke((Expression)expression, (MethodReference)MethodReference.methodReference(AnyValue.class, Object.class, (String)"map", (Class[])new Class[]{ValueMapper.class}), (Expression[])new Expression[]{Expression.invoke((Expression)context, (MethodReference)MethodReference.methodReference(Context.class, ValueMapper.class, (String)"valueMapper", (Class[])new Class[0]), (Expression[])new Expression[0])}));
    }

    private static Expression nullCheck(Expression toCheck, Expression onNotNull) {
        return Expression.ternary((Expression)Expression.equal((Expression)toCheck, (Expression)Expression.constant(null)), (Expression)ProcedureCompilation.noValue(), (Expression)onNotNull);
    }

    private static Expression noValueCheck(Expression toCheck, Expression onNotNoValue) {
        return Expression.ternary((Expression)Expression.equal((Expression)toCheck, (Expression)ProcedureCompilation.noValue()), (Expression)Expression.constant(null), (Expression)onNotNoValue);
    }

    private static Expression noValue() {
        return Expression.getStatic((FieldReference)FieldReference.field((TypeReference)TypeReference.typeReference(Values.class), (TypeReference)TypeReference.typeReference(Value.class), (String)"NO_VALUE"));
    }

    private static Expression[] parameters(CodeBlock block, Method methodToCall, Expression context) {
        Class<?>[] parameterTypes = methodToCall.getParameterTypes();
        Expression[] parameters = new Expression[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameters[i] = ProcedureCompilation.fromAnyValue(parameterTypes[i], Expression.arrayLoad((Expression)block.load("input"), (Expression)Expression.constant((Object)i)), block, context);
        }
        return parameters;
    }

    private static void injectFields(CodeBlock block, List<FieldSetter> fieldSetters, List<FieldReference> fieldsToSet) {
        for (int i = 0; i < fieldSetters.size(); ++i) {
            FieldSetter setter = fieldSetters.get(i);
            Field field = setter.field();
            Class<?> fieldType = field.getType();
            block.put(block.load(USER_CLASS), FieldReference.field((Field)field), ProcedureCompilation.unboxIfNecessary(fieldType, Expression.invoke((Expression)Expression.getStatic((FieldReference)fieldsToSet.get(i)), (MethodReference)MethodReference.methodReference((TypeReference)TypeReference.typeReference(FieldSetter.class), (TypeReference)TypeReference.OBJECT, (String)"get", (TypeReference[])new TypeReference[]{TypeReference.typeReference(Context.class)}), (Expression[])new Expression[]{block.load("ctx")})));
        }
    }

    private static List<FieldReference> createContextSetters(List<FieldSetter> fieldSetters, ClassGenerator generator) {
        ArrayList<FieldReference> fieldsToSet = new ArrayList<FieldReference>(fieldSetters.size());
        for (int i = 0; i < fieldSetters.size(); ++i) {
            fieldsToSet.add(generator.publicStaticField(TypeReference.typeReference(FieldSetter.class), "SETTER_" + i));
        }
        return fieldsToSet;
    }

    private static void setAllStaticFields(Object signature, List<FieldSetter> fieldSetters, Class<?> clazz) throws IllegalAccessException, NoSuchFieldException {
        clazz.getDeclaredField(SIGNATURE_NAME).set(null, signature);
        ProcedureCompilation.setAllStaticFields(fieldSetters, clazz);
    }

    private static void setAllStaticFields(List<FieldSetter> fieldSetters, Class<?> clazz) throws IllegalAccessException, NoSuchFieldException {
        for (int i = 0; i < fieldSetters.size(); ++i) {
            clazz.getDeclaredField("SETTER_" + i).set(null, fieldSetters.get(i));
        }
    }
}

