/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.neo4j.collection.ResourceRawIterator;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.ProcedureHandle;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserAggregationReducer;
import org.neo4j.internal.kernel.api.procs.UserFunctionHandle;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.PermissionState;
import org.neo4j.kernel.api.CypherScope;
import org.neo4j.kernel.api.ResourceMonitor;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.CallableUserAggregationFunction;
import org.neo4j.kernel.api.procedure.CallableUserFunction;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.procedure.UnsupportedDatabaseTypes;
import org.neo4j.procedure.impl.ProcedureHolder;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.AnyValue;

public class ProcedureRegistry {
    private final ProcedureHolder<CallableProcedure> procedures;
    private final ProcedureHolder<CallableUserFunction> functions;
    private final ProcedureHolder<CallableUserAggregationFunction> aggregationFunctions;

    public ProcedureRegistry() {
        this(new ProcedureHolder<CallableProcedure>(), new ProcedureHolder<CallableUserFunction>(), new ProcedureHolder<CallableUserAggregationFunction>());
    }

    private ProcedureRegistry(ProcedureHolder<CallableProcedure> procedures, ProcedureHolder<CallableUserFunction> functions, ProcedureHolder<CallableUserAggregationFunction> aggregationFunctions) {
        this.procedures = procedures;
        this.functions = functions;
        this.aggregationFunctions = aggregationFunctions;
    }

    public void register(CallableProcedure proc) throws ProcedureException {
        ProcedureSignature signature = proc.signature();
        QualifiedName name = signature.name();
        String descriptiveName = signature.toString();
        this.validateSignature(descriptiveName, signature.inputSignature(), "input");
        this.validateSignature(descriptiveName, signature.outputSignature(), "output");
        if (!signature.isVoid() && signature.outputSignature().isEmpty()) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Procedures with zero output fields must be declared as VOID", new Object[0]);
        }
        Set supportedScopes = signature.supportedCypherScopes();
        for (CypherScope scope : supportedScopes) {
            if (!this.procedures.contains(name, scope)) continue;
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Unable to register procedure, because the name `%s` is already in use.", new Object[]{name});
        }
        this.procedures.put(name, supportedScopes, proc, signature.caseInsensitive());
    }

    public void register(CallableUserFunction function) throws ProcedureException {
        UserFunctionSignature signature = function.signature();
        QualifiedName name = signature.name();
        Set supportedScopes = signature.supportedCypherScopes();
        for (CypherScope scope : supportedScopes) {
            if (this.aggregationFunctions.contains(name, scope)) {
                throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Unable to register function, because the name `%s` is already in use as an aggregation function.", new Object[]{name});
            }
            if (!this.functions.contains(name, scope)) continue;
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Unable to register function, because the name `%s` is already in use.", new Object[]{name});
        }
        this.functions.put(name, supportedScopes, function, signature.caseInsensitive());
    }

    public void register(CallableUserAggregationFunction function) throws ProcedureException {
        UserFunctionSignature signature = function.signature();
        QualifiedName name = signature.name();
        Set supportedScopes = signature.supportedCypherScopes();
        for (CypherScope scope : supportedScopes) {
            if (this.functions.contains(name, scope)) {
                throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Unable to register aggregation function, because the name `%s` is already in use as a function.", new Object[]{name});
            }
            if (!this.aggregationFunctions.contains(name, scope)) continue;
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Unable to register aggregation function, because the name `%s` is already in use.", new Object[]{name});
        }
        this.aggregationFunctions.put(name, supportedScopes, function, signature.caseInsensitive());
    }

    private void validateSignature(String descriptiveName, List<FieldSignature> fields, String fieldType) throws ProcedureException {
        HashSet<String> names = new HashSet<String>();
        for (FieldSignature field : fields) {
            if (names.add(field.name())) continue;
            throw new ProcedureException((Status)Status.Procedure.ProcedureRegistrationFailed, "Procedure `%s` cannot be registered, because it contains a duplicated " + fieldType + " field, '%s'. You need to rename or remove one of the duplicate fields.", new Object[]{descriptiveName, field.name()});
        }
    }

    public ProcedureHandle procedure(QualifiedName name, CypherScope scope) throws ProcedureException {
        CallableProcedure proc = this.procedures.getByKey(name, scope);
        if (proc == null) {
            throw this.noSuchProcedure(name);
        }
        return new ProcedureHandle(proc.signature(), this.procedures.idOfKey(name, scope));
    }

    public UserFunctionHandle function(QualifiedName name, CypherScope scope) {
        CallableUserFunction func = this.functions.getByKey(name, scope);
        if (func == null) {
            return null;
        }
        return new UserFunctionHandle(func.signature(), this.functions.idOfKey(name, scope));
    }

    public UserFunctionHandle aggregationFunction(QualifiedName name, CypherScope scope) {
        CallableUserAggregationFunction func = this.aggregationFunctions.getByKey(name, scope);
        if (func == null) {
            return null;
        }
        return new UserFunctionHandle(func.signature(), this.aggregationFunctions.idOfKey(name, scope));
    }

    public ResourceRawIterator<AnyValue[], ProcedureException> callProcedure(Context ctx, int id, AnyValue[] input, ResourceMonitor resourceMonitor) throws ProcedureException {
        CallableProcedure proc;
        try {
            proc = this.procedures.getById(id);
            PermissionState permission = ctx.securityContext().allowExecuteAdminProcedure(id);
            if (proc.signature().admin() && !permission.allowsAccess()) {
                String errorDescriptor = permission == PermissionState.EXPLICIT_DENY ? "is not allowed" : "permission has not been granted";
                String message = String.format("Executing admin procedure '%s' %s for %s.", proc.signature().name(), errorDescriptor, ctx.securityContext().description());
                ((AbstractSecurityLog)ctx.dependencyResolver().resolveDependency(AbstractSecurityLog.class)).error(ctx.securityContext(), message);
                throw new AuthorizationViolationException(message);
            }
            this.verifyDBType(ctx, proc);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.noSuchProcedure(id);
        }
        return proc.apply(ctx, input, resourceMonitor);
    }

    private void verifyDBType(Context ctx, CallableProcedure proc) throws ProcedureException {
        if (Arrays.stream(proc.signature().unsupportedDbTypes()).anyMatch(t -> t.equals((Object)UnsupportedDatabaseTypes.DatabaseType.SPD)) && ctx.kernelTransaction().isSPDTransaction()) {
            throw new ProcedureException((Status)Status.Statement.SyntaxError, "Procedure '" + proc.signature().name() + "' is not supported in SPD.", new Object[0]);
        }
    }

    public AnyValue callFunction(Context ctx, int functionId, AnyValue[] input) throws ProcedureException {
        CallableUserFunction func;
        try {
            func = this.functions.getById(functionId);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.noSuchFunction(functionId);
        }
        return func.apply(ctx, input);
    }

    public UserAggregationReducer createAggregationFunction(Context ctx, int id) throws ProcedureException {
        try {
            CallableUserAggregationFunction func = this.aggregationFunctions.getById(id);
            return func.createReducer(ctx);
        }
        catch (IndexOutOfBoundsException e) {
            throw this.noSuchFunction(id);
        }
    }

    private ProcedureException noSuchProcedure(QualifiedName name) {
        return new ProcedureException((Status)Status.Procedure.ProcedureNotFound, "There is no procedure with the name `%s` registered for this database instance. Please ensure you've spelled the procedure name correctly and that the procedure is properly deployed.", new Object[]{name});
    }

    private ProcedureException noSuchProcedure(int id) {
        return new ProcedureException((Status)Status.Procedure.ProcedureNotFound, "There is no procedure with the internal id `%d` registered for this database instance.", new Object[]{id});
    }

    private ProcedureException noSuchFunction(int id) {
        return new ProcedureException((Status)Status.Procedure.ProcedureNotFound, "There is no function with the internal id `%d` registered for this database instance.", new Object[]{id});
    }

    public Stream<ProcedureSignature> getAllProcedures(CypherScope scope) {
        return ProcedureRegistry.stream(this.procedures, CallableProcedure::signature, signature -> signature.supportedCypherScopes().contains(scope));
    }

    int[] getIdsOfProceduresMatching(Predicate<CallableProcedure> predicate) {
        return ProcedureRegistry.getIdsOf(this.procedures, predicate);
    }

    public Stream<UserFunctionSignature> getAllNonAggregatingFunctions(CypherScope scope) {
        return ProcedureRegistry.stream(this.functions, CallableUserFunction::signature, signature -> signature.supportedCypherScopes().contains(scope));
    }

    int[] getIdsOfFunctionsMatching(Predicate<CallableUserFunction> predicate) {
        return ProcedureRegistry.getIdsOf(this.functions, predicate);
    }

    public Stream<UserFunctionSignature> getAllAggregatingFunctions(CypherScope scope) {
        return ProcedureRegistry.stream(this.aggregationFunctions, CallableUserAggregationFunction::signature, signature -> signature.supportedCypherScopes().contains(scope));
    }

    int[] getIdsOfAggregatingFunctionsMatching(Predicate<CallableUserAggregationFunction> predicate) {
        return ProcedureRegistry.getIdsOf(this.aggregationFunctions, predicate);
    }

    @VisibleForTesting
    public void unregister(QualifiedName name) {
        this.procedures.unregister(name);
        this.functions.unregister(name);
        this.aggregationFunctions.unregister(name);
    }

    public static ProcedureRegistry copyOf(ProcedureRegistry ref) {
        return new ProcedureRegistry(ProcedureHolder.copyOf(ref.procedures), ProcedureHolder.copyOf(ref.functions), ProcedureHolder.copyOf(ref.aggregationFunctions));
    }

    public static ProcedureRegistry tombstone(ProcedureRegistry ref, Predicate<QualifiedName> which) {
        return new ProcedureRegistry(ProcedureHolder.tombstone(ref.procedures, which), ProcedureHolder.tombstone(ref.functions, which), ProcedureHolder.tombstone(ref.aggregationFunctions, which));
    }

    private static <T> int[] getIdsOf(ProcedureHolder<T> holder, Predicate<T> predicate) {
        IntArrayList lst = new IntArrayList();
        holder.forEach((i, v) -> {
            if (predicate.test(v)) {
                lst.add(i.intValue());
            }
        });
        return lst.toArray();
    }

    private static <T, F> Stream<F> stream(ProcedureHolder<T> holder, Function<T, F> transform, Predicate<F> condition) {
        Stream.Builder builder = Stream.builder();
        holder.forEach((id, callable) -> {
            Object value = transform.apply(callable);
            if (condition.test(value)) {
                builder.add(value);
            }
        });
        return builder.build();
    }
}

