/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.util.function.Predicate;
import java.util.stream.Stream;
import org.neo4j.collection.ResourceRawIterator;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.internal.helpers.collection.LfuCache;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureHandle;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.internal.kernel.api.procs.UserAggregationReducer;
import org.neo4j.internal.kernel.api.procs.UserFunctionHandle;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.api.CypherScope;
import org.neo4j.kernel.api.ResourceMonitor;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.api.procedure.ProcedureView;
import org.neo4j.procedure.impl.ComponentRegistry;
import org.neo4j.procedure.impl.ProcedureRegistry;
import org.neo4j.string.Globbing;
import org.neo4j.values.AnyValue;

public class ProcedureViewImpl
implements ProcedureView {
    private static final int LOOKUP_CACHE_SIZE = 100;
    private final long signatureVersion;
    private final ProcedureRegistry registry;
    private final ComponentRegistry safeComponents;
    private final ComponentRegistry allComponents;
    private final LfuCache<String, int[]> proceduresLookupCache = new LfuCache("procedures", 100);
    private final LfuCache<String, int[]> functionsLookupCache = new LfuCache("functions", 100);
    private final LfuCache<String, int[]> aggregationFunctionsLookupCache = new LfuCache("aggregationFunctions", 100);

    private ProcedureViewImpl(long signatureVersion, ProcedureRegistry registryView, ComponentRegistry safeComponents, ComponentRegistry allComponents) {
        this.signatureVersion = signatureVersion;
        this.registry = registryView;
        this.safeComponents = safeComponents;
        this.allComponents = allComponents;
    }

    public static ProcedureView snapshot(long signatureVersion, ProcedureRegistry registry, ComponentRegistry safeComponents, ComponentRegistry allComponents) {
        return new ProcedureViewImpl(signatureVersion, ProcedureRegistry.copyOf(registry), ComponentRegistry.copyOf(safeComponents), ComponentRegistry.copyOf(allComponents));
    }

    public <T> ThrowingFunction<Context, T, ProcedureException> lookupComponentProvider(Class<T> cls, boolean safe) {
        ComponentRegistry registryView = safe ? this.safeComponents : this.allComponents;
        return registryView.providerFor(cls);
    }

    public ProcedureHandle procedure(QualifiedName name, CypherScope scope) throws ProcedureException {
        return this.registry.procedure(name, scope);
    }

    public UserFunctionHandle function(QualifiedName name, CypherScope scope) {
        return this.registry.function(name, scope);
    }

    public UserFunctionHandle aggregationFunction(QualifiedName name, CypherScope scope) {
        return this.registry.aggregationFunction(name, scope);
    }

    public Stream<ProcedureSignature> getAllProcedures(CypherScope scope) {
        return this.registry.getAllProcedures(scope);
    }

    public Stream<UserFunctionSignature> getAllNonAggregatingFunctions(CypherScope scope) {
        return this.registry.getAllNonAggregatingFunctions(scope);
    }

    public Stream<UserFunctionSignature> getAllAggregatingFunctions(CypherScope scope) {
        return this.registry.getAllAggregatingFunctions(scope);
    }

    public ResourceRawIterator<AnyValue[], ProcedureException> callProcedure(Context ctx, int id, AnyValue[] input, ResourceMonitor resourceMonitor) throws ProcedureException {
        return this.registry.callProcedure(ctx, id, input, resourceMonitor);
    }

    public AnyValue callFunction(Context ctx, int id, AnyValue[] input) throws ProcedureException {
        return this.registry.callFunction(ctx, id, input);
    }

    public UserAggregationReducer createAggregationFunction(Context ctx, int id) throws ProcedureException {
        return this.registry.createAggregationFunction(ctx, id);
    }

    public int[] getProcedureIds(String procedureGlobbing) {
        return (int[])this.proceduresLookupCache.computeIfAbsent((Object)procedureGlobbing, this::matchProcedure);
    }

    public int[] getAdminProcedureIds() {
        return this.registry.getIdsOfProceduresMatching(p -> p.signature().admin());
    }

    public int[] getFunctionIds(String functionGlobbing) {
        return (int[])this.functionsLookupCache.computeIfAbsent((Object)functionGlobbing, this::matchFunction);
    }

    public int[] getAggregatingFunctionIds(String functionGlobbing) {
        return (int[])this.aggregationFunctionsLookupCache.computeIfAbsent((Object)functionGlobbing, this::matchAggregation);
    }

    public long signatureVersion() {
        return this.signatureVersion;
    }

    private int[] matchProcedure(String glob) {
        Predicate matcherPredicate = Globbing.globPredicate((String)glob);
        return this.registry.getIdsOfProceduresMatching(p -> matcherPredicate.test(p.signature().name().toString()));
    }

    private int[] matchFunction(String glob) {
        Predicate matcherPredicate = Globbing.globPredicate((String)glob);
        return this.registry.getIdsOfFunctionsMatching(p -> matcherPredicate.test(p.signature().name().toString()));
    }

    private int[] matchAggregation(String glob) {
        Predicate matcherPredicate = Globbing.globPredicate((String)glob);
        return this.registry.getIdsOfAggregatingFunctionsMatching(p -> matcherPredicate.test(p.signature().name().toString()));
    }
}

