/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl.temporal;

import java.time.Clock;
import java.time.ZoneId;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.impl.temporal.TemporalFunction;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.MapValue;

@Description(value="Creates a `DATE` instant.")
class DateFunction
extends TemporalFunction<DateValue> {
    private static final List<FieldSignature> INPUT_SIGNATURE = Collections.singletonList(FieldSignature.inputField((String)"input", (Neo4jTypes.AnyType)Neo4jTypes.NTAny, (DefaultParameterValue)DEFAULT_PARAMETER_VALUE, (boolean)false, (String)"Either a string representation of a temporal value, a map containing the single key 'timezone', or a map containing temporal values ('date', 'year', 'month', 'day', 'week', 'dayOfWeek', 'quarter', 'dayOfQuarter', 'ordinalDay') as components."));

    DateFunction(Supplier<ZoneId> defaultZone) {
        super((Neo4jTypes.AnyType)Neo4jTypes.NTDate, INPUT_SIGNATURE, defaultZone);
    }

    @Override
    protected DateValue now(Clock clock, String timezone, Supplier<ZoneId> defaultZone) {
        return timezone == null ? DateValue.now((Clock)clock, defaultZone) : DateValue.now((Clock)clock, (String)timezone);
    }

    @Override
    protected DateValue parse(TextValue value, Supplier<ZoneId> defaultZone) {
        return DateValue.parse((TextValue)value);
    }

    @Override
    protected DateValue build(MapValue map, Supplier<ZoneId> defaultZone) {
        return DateValue.build((MapValue)map, defaultZone);
    }

    @Override
    protected DateValue select(AnyValue from, Supplier<ZoneId> defaultZone) {
        return DateValue.select((AnyValue)from, defaultZone);
    }

    @Override
    protected List<FieldSignature> getTemporalTruncateSignature() {
        return Arrays.asList(FieldSignature.inputField((String)"unit", (Neo4jTypes.AnyType)Neo4jTypes.NTString, (String)"A string representing one of the following: 'day', 'week', 'month', 'weekYear', 'quarter', 'year', 'decade', 'century', 'millennium'."), FieldSignature.inputField((String)"input", (Neo4jTypes.AnyType)Neo4jTypes.NTAny, (DefaultParameterValue)DEFAULT_PARAMETER_VALUE, (boolean)false, (String)"The date to be truncated using either `ZONED DATETIME`, `LOCAL DATETIME`, or `DATE`."), FieldSignature.inputField((String)"fields", (Neo4jTypes.AnyType)Neo4jTypes.NTMap, (DefaultParameterValue)DefaultParameterValue.nullValue((Neo4jTypes.AnyType)Neo4jTypes.NTMap), (boolean)false, (String)"A list of time components smaller than those specified in `unit` to preserve during truncation."));
    }

    @Override
    protected DateValue truncate(TemporalUnit unit, TemporalValue input, MapValue fields, Supplier<ZoneId> defaultZone) {
        return DateValue.truncate((TemporalUnit)unit, (TemporalValue)input, (MapValue)fields, defaultZone);
    }

    @Override
    protected String getTemporalCypherTypeName() {
        return "DATE";
    }
}

