/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.function.Predicates;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexSamplingMode;
import org.neo4j.kernel.impl.api.index.IndexingService;

public class IndexProcedures {
    private final KernelTransaction ktx;
    private final IndexingService indexingService;

    public IndexProcedures(KernelTransaction tx, IndexingService indexingService) {
        this.ktx = tx;
        this.indexingService = indexingService;
    }

    void awaitIndexByName(String indexName, long timeout, TimeUnit timeoutUnits) throws ProcedureException {
        IndexDescriptor index = this.getIndex(indexName, "awaitIndexByName");
        this.waitUntilOnline(index, timeout, timeoutUnits, "awaitIndexByName");
    }

    void resampleIndex(String indexName) throws ProcedureException {
        IndexDescriptor index = this.getIndex(indexName, "resampleIndex");
        this.triggerSampling(index);
    }

    void resampleOutdatedIndexes() {
        this.indexingService.triggerIndexSampling(IndexSamplingMode.backgroundRebuildUpdated());
    }

    void resampleOutdatedIndexes(long timeOutSeconds) {
        long millis = TimeUnit.SECONDS.toMillis(timeOutSeconds);
        IndexSamplingMode mode = IndexSamplingMode.foregroundRebuildUpdated((long)millis);
        this.indexingService.triggerIndexSampling(mode);
    }

    private IndexDescriptor getIndex(String indexName, String procedureName) throws ProcedureException {
        IndexDescriptor indexReference = this.ktx.schemaRead().indexGetForName(indexName);
        if (indexReference == IndexDescriptor.NO_INDEX) {
            throw ProcedureException.noSuchIndex((String)indexName, (String)procedureName, (Boolean)true);
        }
        return indexReference;
    }

    private void waitUntilOnline(IndexDescriptor index, long timeout, TimeUnit timeoutUnits, String procedureName) throws ProcedureException {
        try {
            Predicates.awaitEx(() -> this.isOnline(index, procedureName), (long)timeout, (TimeUnit)timeoutUnits);
        }
        catch (TimeoutException e) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureTimedOut, "Index on '%s' did not come online within %s %s", new Object[]{index.userDescription((TokenNameLookup)this.ktx.tokenRead()), timeout, timeoutUnits});
        }
    }

    private boolean isOnline(IndexDescriptor index, String procedureName) throws ProcedureException {
        InternalIndexState state = this.getState(index, procedureName);
        switch (state) {
            case POPULATING: {
                return false;
            }
            case ONLINE: {
                return true;
            }
            case FAILED: {
                String cause = this.getFailure(index, procedureName);
                throw new ProcedureException((Status)Status.Schema.IndexCreationFailed, IndexPopulationFailure.appendCauseOfFailure((String)"Index '%s' is in failed state.", (String)cause), new Object[]{index.getName()});
            }
        }
        throw new IllegalStateException("Unknown index state " + String.valueOf(state));
    }

    private InternalIndexState getState(IndexDescriptor index, String procedureName) throws ProcedureException {
        try {
            return this.ktx.schemaRead().indexGetState(index);
        }
        catch (IndexNotFoundKernelException e) {
            throw ProcedureException.noSuchIndex((String)index.getName(), (String)procedureName, (Boolean)false);
        }
    }

    private String getFailure(IndexDescriptor index, String procedureName) throws ProcedureException {
        try {
            return this.ktx.schemaRead().indexGetFailure(index);
        }
        catch (IndexNotFoundKernelException e) {
            throw ProcedureException.noSuchIndex((String)index.getName(), (String)procedureName, (Boolean)false);
        }
    }

    private void triggerSampling(IndexDescriptor index) {
        this.indexingService.triggerIndexSampling(index, IndexSamplingMode.backgroundRebuildAll());
    }
}

