/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin;

import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.neo4j.collection.RawIterator;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.kernel.api.ResourceMonitor;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.procedure.Mode;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.ListValueBuilder;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;

public class JmxQueryProcedure
extends CallableProcedure.BasicProcedure {
    private final MBeanServer jmxServer;

    public JmxQueryProcedure(QualifiedName name, MBeanServer jmxServer) {
        super(ProcedureSignature.procedureSignature((QualifiedName)name).in("query", (Neo4jTypes.AnyType)Neo4jTypes.NTString).out("name", (Neo4jTypes.AnyType)Neo4jTypes.NTString).out("description", (Neo4jTypes.AnyType)Neo4jTypes.NTString).out("attributes", (Neo4jTypes.AnyType)Neo4jTypes.NTMap).mode(Mode.DBMS).description("Query JMX management data by domain and name. For instance, \"*:*\"").systemProcedure().build());
        this.jmxServer = jmxServer;
    }

    public RawIterator<AnyValue[], ProcedureException> apply(Context ctx, AnyValue[] input, ResourceMonitor resourceMonitor) throws ProcedureException {
        String query = ((TextValue)input[0]).stringValue();
        try {
            Iterator<ObjectName> names = this.jmxServer.queryNames(new ObjectName(query), null).iterator();
            return RawIterator.from(() -> {
                if (!names.hasNext()) {
                    return null;
                }
                ObjectName name = (ObjectName)names.next();
                try {
                    MBeanInfo beanInfo = this.jmxServer.getMBeanInfo(name);
                    return new AnyValue[]{Values.stringValue((String)name.getCanonicalName()), Values.stringValue((String)beanInfo.getDescription()), this.toNeo4jValue(name, beanInfo.getAttributes())};
                }
                catch (JMException e) {
                    throw new ProcedureException((Status)Status.General.UnknownError, (Throwable)e, "JMX error while accessing `%s`, please report this. Message was: %s", new Object[]{name, e.getMessage()});
                }
            });
        }
        catch (MalformedObjectNameException e) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "'%s' is an invalid JMX name pattern. Valid queries should use the syntax outlined in the javax.management.ObjectName API documentation.For instance, use '*:*' to find all JMX beans.", new Object[]{query});
        }
    }

    private MapValue toNeo4jValue(ObjectName name, MBeanAttributeInfo[] attributes) throws JMException {
        MapValueBuilder out = new MapValueBuilder();
        for (MBeanAttributeInfo attribute : attributes) {
            if (!attribute.isReadable()) continue;
            out.add(attribute.getName(), (AnyValue)this.toNeo4jValue(name, attribute));
        }
        return out.build();
    }

    private MapValue toNeo4jValue(ObjectName name, MBeanAttributeInfo attribute) throws JMException {
        AnyValue value;
        try {
            value = this.toNeo4jValue(this.jmxServer.getAttribute(name, attribute.getName()));
        }
        catch (RuntimeMBeanException e) {
            if (e.getCause() != null && e.getCause() instanceof UnsupportedOperationException) {
                value = Values.NO_VALUE;
            }
            throw e;
        }
        MapValueBuilder builder = new MapValueBuilder(2);
        builder.add("description", (AnyValue)Values.stringValue((String)attribute.getDescription()));
        builder.add("value", value);
        return builder.build();
    }

    private AnyValue toNeo4jValue(Object attributeValue) {
        if (JmxQueryProcedure.isSimpleType(attributeValue)) {
            return ValueUtils.of((Object)attributeValue);
        }
        if (attributeValue.getClass().isArray()) {
            if (JmxQueryProcedure.isSimpleType(attributeValue.getClass().getComponentType())) {
                return ValueUtils.of((Object)attributeValue);
            }
            return this.toNeo4jValue((Object[])attributeValue);
        }
        if (attributeValue instanceof CompositeData) {
            return this.toNeo4jValue((CompositeData)attributeValue);
        }
        if (attributeValue instanceof ObjectName) {
            return Values.stringValue((String)((ObjectName)attributeValue).getCanonicalName());
        }
        if (attributeValue instanceof TabularData) {
            return this.toNeo4jValue((Map)attributeValue);
        }
        if (attributeValue instanceof Date) {
            return Values.longValue((long)((Date)attributeValue).getTime());
        }
        return Values.NO_VALUE;
    }

    private MapValue toNeo4jValue(Map<?, ?> attributeValue) {
        MapValueBuilder builder = new MapValueBuilder();
        attributeValue.forEach((key, value) -> builder.add(key.toString(), this.toNeo4jValue(value)));
        return builder.build();
    }

    private ListValue toNeo4jValue(Object[] array) {
        return (ListValue)Arrays.stream(array).map(this::toNeo4jValue).collect(ListValueBuilder.collector());
    }

    private MapValue toNeo4jValue(CompositeData composite) {
        MapValueBuilder properties = new MapValueBuilder();
        for (String key : composite.getCompositeType().keySet()) {
            properties.add(key, this.toNeo4jValue(composite.get(key)));
        }
        MapValueBuilder out = new MapValueBuilder();
        out.add("description", (AnyValue)Values.stringValue((String)composite.getCompositeType().getDescription()));
        out.add("properties", (AnyValue)properties.build());
        return out.build();
    }

    private static boolean isSimpleType(Object value) {
        return value == null || JmxQueryProcedure.isSimpleType(value.getClass());
    }

    private static boolean isSimpleType(Class<?> cls) {
        return String.class.isAssignableFrom(cls) || Number.class.isAssignableFrom(cls) || Boolean.class.isAssignableFrom(cls) || cls.isPrimitive();
    }
}

