/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin.routing;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingChangeListener;
import org.neo4j.configuration.helpers.ConfigPatternBuilder;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.procedure.builtin.routing.ClientRoutingDomainChecker;

public class SimpleClientRoutingDomainChecker
implements ClientRoutingDomainChecker {
    protected final InternalLog log;
    private volatile Pattern[] domainPatterns;

    private SimpleClientRoutingDomainChecker(InternalLogProvider logProvider) {
        this.log = logProvider.getLog(this.getClass());
    }

    public static ClientRoutingDomainChecker fromConfig(Config config, InternalLogProvider logProvider) {
        SimpleClientRoutingDomainChecker simpleChecker = new SimpleClientRoutingDomainChecker(logProvider);
        simpleChecker.setClientRoutingDomain((Set)config.get(GraphDatabaseSettings.client_side_router_enforce_for_domains));
        config.addListener(GraphDatabaseSettings.client_side_router_enforce_for_domains, (SettingChangeListener)simpleChecker);
        return simpleChecker;
    }

    @Override
    public boolean shouldGetClientRouting(SocketAddress address) {
        Pattern[] patternsToUse = this.domainPatterns;
        return this.shouldGetClientRouting(address, patternsToUse);
    }

    @Override
    public boolean isEmpty() {
        return this.domainPatterns == null || this.domainPatterns.length == 0;
    }

    boolean shouldGetClientRouting(SocketAddress address, Pattern[] patternsToUse) {
        if (patternsToUse.length == 0) {
            return false;
        }
        return SimpleClientRoutingDomainChecker.isMatch(patternsToUse, address);
    }

    private static boolean isMatch(Pattern[] patterns, SocketAddress address) {
        return Arrays.stream(patterns).anyMatch(p -> p.matcher(address.getHostname()).matches()) || Arrays.stream(patterns).anyMatch(p -> p.matcher(address.toString()).matches());
    }

    public synchronized void accept(Set<String> before, Set<String> after) {
        if (Objects.equals(before, after)) {
            return;
        }
        this.setClientRoutingDomain(after);
    }

    private void setClientRoutingDomain(Set<String> after) {
        Pattern[] newDomains = this.processPatterns(after);
        this.update(newDomains);
    }

    protected void update(Pattern[] newDomains) {
        this.domainPatterns = newDomains;
    }

    protected Pattern[] processPatterns(Set<String> userProvidedPatterns) {
        return (Pattern[])userProvidedPatterns.stream().map(p -> ConfigPatternBuilder.patternFromConfigString((String)p, (int)2)).toArray(Pattern[]::new);
    }
}

