/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.internal.kernel.api.procs.QualifiedName;

class ProcedureHolder<T> {
    private final Map<QualifiedName, Integer> nameToId = new HashMap<QualifiedName, Integer>();
    private final Map<QualifiedName, Integer> caseInsensitiveName2Id = new HashMap<QualifiedName, Integer>();
    private final List<Object> store = new ArrayList<Object>();
    private static final Object TOMBSTONE = new Object();

    ProcedureHolder() {
    }

    T get(QualifiedName name) {
        Integer id = this.name2Id(name);
        if (id == null) {
            return null;
        }
        Object value = this.store.get(id);
        if (value == TOMBSTONE) {
            return null;
        }
        return (T)value;
    }

    T get(int id) {
        Object element = this.store.get(id);
        if (element == TOMBSTONE) {
            return null;
        }
        return (T)element;
    }

    int put(QualifiedName name, T item, boolean caseInsensitive) {
        Integer id = this.name2Id(name);
        if (id != null) {
            this.store.set(id, item);
        } else {
            id = this.store.size();
            this.nameToId.put(name, id);
            this.store.add(item);
        }
        QualifiedName lowercaseName = this.toLowerCaseName(name);
        if (caseInsensitive) {
            this.caseInsensitiveName2Id.put(lowercaseName, id);
        } else {
            this.caseInsensitiveName2Id.remove(lowercaseName);
        }
        return id;
    }

    public static <T> ProcedureHolder<T> tombstone(ProcedureHolder<T> src, Set<Integer> preserve) {
        Objects.requireNonNull(preserve);
        ProcedureHolder<T> ret = new ProcedureHolder<T>();
        for (int i = 0; i < src.store.size(); ++i) {
            if (preserve.contains(i)) {
                ret.store.add(src.store.get(i));
                continue;
            }
            ret.store.add(TOMBSTONE);
        }
        src.caseInsensitiveName2Id.forEach((k, v) -> ret.caseInsensitiveName2Id.put((QualifiedName)k, (Integer)v));
        src.nameToId.forEach((k, v) -> ret.nameToId.put((QualifiedName)k, (Integer)v));
        return ret;
    }

    int idOf(QualifiedName name) {
        Integer id = this.name2Id(name);
        if (id == null || this.store.get(id) == TOMBSTONE) {
            throw new NoSuchElementException();
        }
        return id;
    }

    List<T> all() {
        return this.store.stream().filter(e -> e != TOMBSTONE).collect(Collectors.toList());
    }

    boolean contains(QualifiedName name) {
        return this.get(name) != null;
    }

    private Integer name2Id(QualifiedName name) {
        Integer id = this.nameToId.get(name);
        if (id == null) {
            QualifiedName lowerCaseName = this.toLowerCaseName(name);
            id = this.caseInsensitiveName2Id.get(lowerCaseName);
        }
        return id;
    }

    private QualifiedName toLowerCaseName(QualifiedName name) {
        String[] oldNs = name.namespace();
        String[] lowerCaseNamespace = new String[oldNs.length];
        for (int i = 0; i < oldNs.length; ++i) {
            lowerCaseNamespace[i] = oldNs[i].toLowerCase(Locale.ROOT);
        }
        String lowercaseName = name.name().toLowerCase(Locale.ROOT);
        return new QualifiedName(lowerCaseNamespace, lowercaseName);
    }

    public void unregister(QualifiedName name) {
        Integer id = this.name2Id(name);
        if (id != null) {
            this.store.set(id, TOMBSTONE);
        }
    }
}

