/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.query.QuerySnapshot;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.kernel.impl.query.QueryLogEntryContent;
import org.neo4j.kernel.impl.query.QueryLogFormatter;
import org.neo4j.logging.Log;

class QueryLogger
implements QueryExecutionMonitor {
    private final Log log;
    private final long thresholdMillis;
    private final boolean logQueryParameters;
    private final boolean logDetailedTime;
    private final boolean logAllocatedBytes;
    private final boolean logPageDetails;
    private static final Pattern PASSWORD_PATTERN = Pattern.compile("(?:(?i)call)\\s+dbms(?:\\.security)?\\.change(?:User)?Password\\((?:\\s*(?:'(?:(?<=\\\\)'|[^'])*'|\"(?:(?<=\\\\)\"|[^\"])*\"|[^,]*)\\s*,)?\\s*('(?:(?<=\\\\)'|[^'])*'|\"(?:(?<=\\\\)\"|[^\"])*\"|\\$\\w*|\\{\\w*\\})\\s*\\)");

    QueryLogger(Log log, long thresholdMillis, EnumSet<QueryLogEntryContent> flags) {
        this.log = log;
        this.thresholdMillis = thresholdMillis;
        this.logQueryParameters = flags.contains((Object)QueryLogEntryContent.LOG_PARAMETERS);
        this.logDetailedTime = flags.contains((Object)QueryLogEntryContent.LOG_DETAILED_TIME);
        this.logAllocatedBytes = flags.contains((Object)QueryLogEntryContent.LOG_ALLOCATED_BYTES);
        this.logPageDetails = flags.contains((Object)QueryLogEntryContent.LOG_PAGE_DETAILS);
    }

    public void startQueryExecution(ExecutingQuery query) {
    }

    public void endFailure(ExecutingQuery query, Throwable failure) {
        this.log.error(this.logEntry(query.snapshot()), failure);
    }

    public void endSuccess(ExecutingQuery query) {
        QuerySnapshot snapshot = query.snapshot();
        if (snapshot.elapsedTimeMillis() >= this.thresholdMillis) {
            this.log.info(this.logEntry(snapshot));
        }
    }

    private String logEntry(QuerySnapshot query) {
        String sourceString = query.clientConnection().asConnectionDetails();
        String queryText = query.queryText();
        HashSet<String> passwordParams = new HashSet<String>();
        Matcher matcher = PASSWORD_PATTERN.matcher(queryText);
        while (matcher.find()) {
            String password = matcher.group(1).trim();
            if (password.charAt(0) == '$') {
                passwordParams.add(password.substring(1));
                continue;
            }
            if (password.charAt(0) == '{') {
                passwordParams.add(password.substring(1, password.length() - 1));
                continue;
            }
            queryText = queryText.replace(password, "******");
            password = "";
        }
        StringBuilder result = new StringBuilder();
        result.append(query.elapsedTimeMillis()).append(" ms: ");
        if (this.logDetailedTime) {
            QueryLogFormatter.formatDetailedTime(result, query);
        }
        if (this.logAllocatedBytes) {
            QueryLogFormatter.formatAllocatedBytes(result, query);
        }
        if (this.logPageDetails) {
            QueryLogFormatter.formatPageDetails(result, query);
        }
        result.append(sourceString).append(" - ").append(queryText);
        if (this.logQueryParameters) {
            QueryLogFormatter.formatMap(result.append(" - "), query.queryParameters(), passwordParams);
        }
        QueryLogFormatter.formatMap(result.append(" - "), query.transactionAnnotationData());
        return result.toString();
    }
}

