/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.query;

import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.time.Duration;
import java.util.EnumSet;
import java.util.function.Supplier;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.file.Files;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.query.QueryLogEntryContent;
import org.neo4j.kernel.impl.query.QueryLogger;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.FormattedLog;
import org.neo4j.logging.Log;
import org.neo4j.logging.RotatingFileOutputStreamSupplier;

public class QueryLoggerKernelExtension
extends KernelExtensionFactory<Dependencies> {
    public QueryLoggerKernelExtension() {
        super("query-logging");
    }

    public Lifecycle newInstance(KernelContext context, Dependencies dependencies) throws Throwable {
        final Config config = dependencies.config();
        boolean queryLogEnabled = (Boolean)config.get(GraphDatabaseSettings.log_queries);
        final File queryLogFile = (File)config.get(GraphDatabaseSettings.log_queries_filename);
        final FileSystemAbstraction fileSystem = dependencies.fileSystem();
        final JobScheduler jobScheduler = dependencies.jobScheduler();
        final Monitors monitoring = dependencies.monitoring();
        if (!queryLogEnabled) {
            return this.createEmptyAdapter();
        }
        return new LifecycleAdapter(){
            Closeable closable;

            public void init() throws Throwable {
                FormattedLog log;
                Long thresholdMillis = ((Duration)config.get(GraphDatabaseSettings.log_queries_threshold)).toMillis();
                Long rotationThreshold = (Long)config.get(GraphDatabaseSettings.log_queries_rotation_threshold);
                int maxArchives = (Integer)config.get(GraphDatabaseSettings.log_queries_max_archives);
                EnumSet<QueryLogEntryContent> flags = EnumSet.noneOf(QueryLogEntryContent.class);
                for (QueryLogEntryContent flag : QueryLogEntryContent.values()) {
                    if (!flag.enabledIn(config)) continue;
                    flags.add(flag);
                }
                FormattedLog.Builder logBuilder = FormattedLog.withUTCTimeZone();
                if (rotationThreshold == 0L) {
                    OutputStream logOutputStream = Files.createOrOpenAsOuputStream((FileSystemAbstraction)fileSystem, (File)queryLogFile, (boolean)true);
                    log = logBuilder.toOutputStream(logOutputStream);
                    this.closable = logOutputStream;
                } else {
                    RotatingFileOutputStreamSupplier rotatingSupplier = new RotatingFileOutputStreamSupplier(fileSystem, queryLogFile, rotationThreshold.longValue(), 0L, maxArchives, jobScheduler.executor(JobScheduler.Groups.queryLogRotation));
                    log = logBuilder.toOutputStream((Supplier)rotatingSupplier);
                    this.closable = rotatingSupplier;
                }
                QueryLogger logger = new QueryLogger((Log)log, thresholdMillis, flags);
                monitoring.addMonitorListener((Object)logger, new String[0]);
            }

            public void shutdown() throws Throwable {
                this.closable.close();
            }
        };
    }

    private Lifecycle createEmptyAdapter() {
        return new LifecycleAdapter();
    }

    public static interface Dependencies {
        public FileSystemAbstraction fileSystem();

        public Config config();

        public Monitors monitoring();

        public LogService logger();

        public JobScheduler jobScheduler();
    }
}

