/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.router.impl.query;

import java.util.Optional;
import org.neo4j.cypher.internal.ast.CatalogName;
import org.neo4j.cypher.messages.MessageUtilProvider;
import org.neo4j.exceptions.InvalidSemanticsException;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.router.impl.query.QueryTarget;
import org.neo4j.router.query.DatabaseReferenceResolver;
import org.neo4j.router.query.TargetService;

public class StandardTargetService
implements TargetService {
    private final DatabaseReference sessionDatabase;
    private final DatabaseReferenceResolver databaseReferenceResolver;

    public StandardTargetService(DatabaseReference sessionDatabase, DatabaseReferenceResolver databaseReferenceResolver) {
        this.sessionDatabase = sessionDatabase;
        this.databaseReferenceResolver = databaseReferenceResolver;
    }

    @Override
    public QueryTarget target(TargetService.CatalogInfo catalogInfo) {
        Optional<QueryTarget> parsedTarget = this.toCatalogName(catalogInfo).map(catalogName -> this.databaseReferenceResolver.resolve(this.sessionDatabase, (CatalogName)catalogName));
        if (parsedTarget.filter(target -> target.reference().isComposite() || !target.reference().isPrimary() && target.reference().namespace().isPresent()).isPresent()) {
            String message = "Accessing a composite database and its constituents is only allowed when connected to it. Attempted to access '%s' while connected to '%s'";
            throw new InvalidSemanticsException(String.format(message, parsedTarget.get().reference().toPrettyString(), this.sessionDatabase.toPrettyString()));
        }
        if (parsedTarget.filter(target -> target.reference().isShard()).isPresent()) {
            String target2 = parsedTarget.get().reference().toPrettyString();
            String shardedDatabase = parsedTarget.get().reference().owningDatabaseName();
            throw InvalidSemanticsException.invalidShardTarget((String)"USE", (String)shardedDatabase, (String)target2);
        }
        return parsedTarget.orElse(new QueryTarget(this.sessionDatabase));
    }

    private Optional<CatalogName> toCatalogName(TargetService.CatalogInfo catalogInfo) {
        if (catalogInfo instanceof TargetService.SingleQueryCatalogInfo) {
            TargetService.SingleQueryCatalogInfo singleQueryCatalogInfo = (TargetService.SingleQueryCatalogInfo)catalogInfo;
            return singleQueryCatalogInfo.catalogName();
        }
        if (catalogInfo instanceof TargetService.UnionQueryCatalogInfo) {
            TargetService.UnionQueryCatalogInfo unionQueryCatalogInfo = (TargetService.UnionQueryCatalogInfo)catalogInfo;
            Optional<CatalogName> catalogName = unionQueryCatalogInfo.catalogNames().get(0);
            if (catalogName.isPresent() && unionQueryCatalogInfo.catalogNames().stream().anyMatch(Optional::isEmpty)) {
                NormalizedDatabaseName normalizedDatabaseName = new NormalizedDatabaseName(catalogName.get().qualifiedNameString());
                if (!this.sessionDatabase.fullName().name().equals(normalizedDatabaseName.name())) {
                    throw InvalidSemanticsException.accessingMultipleGraphsOnlySupportedOnCompositeDatabases((String)MessageUtilProvider.createMultipleGraphReferencesError((String)normalizedDatabaseName.name(), (boolean)false));
                }
            }
            return catalogName;
        }
        throw new IllegalArgumentException("Unexpected catalog info " + String.valueOf(catalogInfo));
    }
}

