/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.router.impl.query;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.cypher.internal.options.CypherExecutionMode;
import org.neo4j.cypher.internal.preparser.PreParsedQuery;
import org.neo4j.cypher.internal.preparser.QueryOptions;
import org.neo4j.cypher.internal.util.CancellationChecker;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.rendering.QueryOptionsRenderer;
import org.neo4j.fabric.executor.Location;
import org.neo4j.fabric.executor.QueryStatementLifecycles;
import org.neo4j.fabric.transaction.TransactionMode;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceImpl;
import org.neo4j.kernel.impl.query.ConstituentTransactionFactory;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.router.impl.query.DirectTargetService;
import org.neo4j.router.query.Query;
import org.neo4j.router.query.QueryProcessor;
import org.neo4j.router.query.TargetService;
import org.neo4j.router.transaction.RouterTransactionContext;
import org.neo4j.router.util.Errors;
import org.neo4j.values.virtual.MapValue;

public class ConstituentTransactionFactoryImpl
implements ConstituentTransactionFactory {
    private final QueryStatementLifecycles statementLifecycles;
    private final CancellationChecker cancellationChecker;
    private final QueryOptions queryOptions;
    private final RouterTransactionContext context;
    private final QueryProcessor queryProcessor;

    public ConstituentTransactionFactoryImpl(QueryProcessor queryProcessor, QueryStatementLifecycles queryStatementLifecycles, CancellationChecker cancellationChecker, QueryOptions queryOptions, RouterTransactionContext context) {
        this.queryProcessor = queryProcessor;
        this.statementLifecycles = queryStatementLifecycles;
        this.cancellationChecker = cancellationChecker;
        this.queryOptions = queryOptions;
        this.context = context;
    }

    public ConstituentTransactionFactory.ConstituentTransaction transactionFor(DatabaseReference databaseReference) {
        return new ConstituentTransactionImpl(databaseReference);
    }

    public DatabaseReferenceImpl.Composite sessionDatabase() {
        return (DatabaseReferenceImpl.Composite)this.context.sessionDatabaseReference();
    }

    public class ConstituentTransactionImpl
    implements ConstituentTransactionFactory.ConstituentTransaction {
        private final DatabaseReference targetReference;
        private final TargetService targetService;
        private final Location location;

        public ConstituentTransactionImpl(DatabaseReference targetReference) {
            if (ConstituentTransactionFactoryImpl.this.sessionDatabase().getConstituentByName(targetReference.fullName().name()).isEmpty()) {
                Errors.cantAccessOutsideCompositeMessage(targetReference, (DatabaseReference)ConstituentTransactionFactoryImpl.this.sessionDatabase());
            }
            this.targetReference = targetReference;
            this.targetService = new DirectTargetService(targetReference);
            this.location = ConstituentTransactionFactoryImpl.this.context.locationService().locationOf(targetReference);
        }

        public QueryExecution executeQuery(String queryString, MapValue parameters, QuerySubscriber querySubscriber) throws QueryExecutionKernelException {
            QueryStatementLifecycles.StatementLifecycle statementLifecycle = ConstituentTransactionFactoryImpl.this.statementLifecycles.create(ConstituentTransactionFactoryImpl.this.context.transactionInfo().statementLifecycleTransactionInfo(), queryString, parameters, null);
            statementLifecycle.startProcessing();
            Query query = Query.of(QueryOptionsRenderer.addOptions((String)queryString, (QueryOptions)ConstituentTransactionFactoryImpl.this.queryOptions), parameters);
            CypherVersion defaultQueryLanguage = ConstituentTransactionFactoryImpl.this.context.transactionInfo().defaultQueryLanguageScope().defaultQueryLanguage();
            PreParsedQuery preParsedQuery = ConstituentTransactionFactoryImpl.this.queryProcessor.preParse(query, defaultQueryLanguage);
            statementLifecycle.donePreParsing(preParsedQuery);
            QueryProcessor.ProcessedQueryInfo processedQuery = ConstituentTransactionFactoryImpl.this.queryProcessor.processQuery(query, preParsedQuery, this.targetService, dbRef -> this.location, ConstituentTransactionFactoryImpl.this.cancellationChecker, (DatabaseReference)ConstituentTransactionFactoryImpl.this.sessionDatabase());
            Set<InternalNotification> notifications = Stream.concat(processedQuery.routingNotifications().stream(), processedQuery.parsingNotifications().stream()).collect(Collectors.toSet());
            statementLifecycle.doneRouterProcessing(processedQuery.obfuscationMetadata().get(), processedQuery.queryOptions().offset(), this.targetReference.isComposite(), notifications);
            TransactionMode mode = TransactionMode.from((AccessMode)ConstituentTransactionFactoryImpl.this.context.transactionInfo().accessMode(), (CypherExecutionMode)ConstituentTransactionFactoryImpl.this.queryOptions.queryOptions().executionMode(), (boolean)processedQuery.statementType().isReadQuery(), (boolean)this.targetReference.isComposite());
            return ConstituentTransactionFactoryImpl.this.context.transactionFor(this.location, mode).executeQuery(query, querySubscriber, statementLifecycle, notifications);
        }
    }
}

