/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.router.impl.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.neo4j.cypher.internal.ast.CatalogName;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.dbms.api.DatabaseNotFoundHelper;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.database.NormalizedCatalogEntry;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.router.impl.query.QueryTarget;
import org.neo4j.router.query.DatabaseReferenceResolver;

public class DefaultDatabaseReferenceResolver
implements DatabaseReferenceResolver {
    private final DatabaseReferenceRepository repository;

    public DefaultDatabaseReferenceResolver(DatabaseReferenceRepository repository) {
        this.repository = repository;
    }

    @Override
    public QueryTarget resolve(DatabaseReference sessionDatabase, CatalogName catalogName) {
        if (catalogName.resolveByDisplayName()) {
            return this.repository.getByDisplayName(catalogName.simplifiedQualifiedNameString()).map(QueryTarget::new).orElseThrow(DefaultDatabaseReferenceResolver.databaseNotFound(catalogName));
        }
        return this.resolveByCatalogName(sessionDatabase, catalogName);
    }

    private QueryTarget resolveByCatalogName(DatabaseReference sessionDatabase, CatalogName catalogName) {
        boolean containsQuotedNameParts;
        boolean bl = containsQuotedNameParts = !catalogName.names().stream().filter(name -> name.contains(".")).toList().isEmpty();
        if (catalogName.names().size() > 2) {
            if (containsQuotedNameParts) {
                throw DefaultDatabaseReferenceResolver.databaseNotFound(catalogName).get();
            }
            List<NormalizedCatalogEntry> allNameCombinations = DefaultDatabaseReferenceResolver.getAllNameCombinations(catalogName.names());
            return (QueryTarget)allNameCombinations.stream().flatMap(name -> this.queryTarget((NormalizedCatalogEntry)name).stream()).findFirst().orElseThrow(DefaultDatabaseReferenceResolver.databaseNotFound(catalogName));
        }
        if (catalogName.names().size() == 2) {
            if (((String)catalogName.names().getFirst()).contains(".")) {
                throw DefaultDatabaseReferenceResolver.databaseNotFound(catalogName).get();
            }
            NormalizedCatalogEntry constituentEntry = NormalizedCatalogEntry.fromList((List)catalogName.names());
            NormalizedCatalogEntry aliasEntry = new NormalizedCatalogEntry(DefaultDatabaseReferenceResolver.namePartsToName(catalogName.names()));
            if (containsQuotedNameParts) {
                return this.queryTarget(constituentEntry).orElseThrow(DefaultDatabaseReferenceResolver.databaseNotFound(catalogName));
            }
            if (sessionDatabase.isComposite()) {
                return this.queryTarget(constituentEntry).or(() -> this.queryTarget(aliasEntry)).orElseThrow(DefaultDatabaseReferenceResolver.databaseNotFound(catalogName));
            }
            return this.queryTarget(aliasEntry).or(() -> this.queryTarget(constituentEntry)).orElseThrow(DefaultDatabaseReferenceResolver.databaseNotFound(catalogName));
        }
        return this.queryTarget(NormalizedCatalogEntry.fromList((List)catalogName.names())).orElseThrow(DefaultDatabaseReferenceResolver.databaseNotFound(catalogName));
    }

    private Optional<QueryTarget> queryTarget(NormalizedCatalogEntry catalogEntry) {
        Optional databaseReference = this.repository.getByAlias(catalogEntry);
        return databaseReference.map(QueryTarget::new);
    }

    static List<NormalizedCatalogEntry> getAllNameCombinations(List<String> nameParts) {
        ArrayList<NormalizedCatalogEntry> combinations = new ArrayList<NormalizedCatalogEntry>();
        combinations.add(new NormalizedCatalogEntry(DefaultDatabaseReferenceResolver.namePartsToName(nameParts)));
        for (int i = 1; i < nameParts.size(); ++i) {
            String composite = DefaultDatabaseReferenceResolver.namePartsToName(nameParts.subList(0, i));
            String constituent = DefaultDatabaseReferenceResolver.namePartsToName(nameParts.subList(i, nameParts.size()));
            combinations.add(new NormalizedCatalogEntry(composite, constituent));
        }
        return combinations;
    }

    private static String namePartsToName(List<String> nameParts) {
        return String.join((CharSequence)".", nameParts);
    }

    @Override
    public DatabaseReference resolve(String name) {
        return this.resolve(new NormalizedDatabaseName(name));
    }

    @Override
    public DatabaseReference resolve(NormalizedDatabaseName name) {
        return (DatabaseReference)this.repository.getByAlias(name).or(() -> this.getCompositeConstituentAlias(name)).orElseThrow(DefaultDatabaseReferenceResolver.databaseNotFound(name));
    }

    private Optional<DatabaseReference> getCompositeConstituentAlias(NormalizedDatabaseName name) {
        return this.repository.getCompositeDatabaseReferences().stream().flatMap(comp -> comp.constituents().stream()).filter(constituent -> constituent.fullName().equals((Object)name)).findFirst();
    }

    private static Supplier<DatabaseNotFoundException> databaseNotFound(NormalizedDatabaseName databaseNameRaw) {
        return () -> DatabaseNotFoundHelper.graphNotFound((String)databaseNameRaw.name());
    }

    private static Supplier<DatabaseNotFoundException> databaseNotFound(CatalogName databaseNameRaw) {
        return () -> DatabaseNotFoundHelper.graphNotFound((String)databaseNameRaw.qualifiedNameString());
    }
}

