/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.router.impl.query.parsing;

import java.util.Optional;
import org.neo4j.cypher.internal.PreParsedQuery;
import org.neo4j.cypher.internal.PreParser;
import org.neo4j.cypher.internal.ast.AdministrationCommand;
import org.neo4j.cypher.internal.ast.CatalogName;
import org.neo4j.cypher.internal.ast.Statement;
import org.neo4j.cypher.internal.compiler.CypherParsing;
import org.neo4j.cypher.internal.frontend.phases.BaseState;
import org.neo4j.cypher.internal.frontend.phases.CompilationPhaseTracer;
import org.neo4j.cypher.internal.tracing.CompilationTracer;
import org.neo4j.cypher.internal.util.CancellationChecker;
import org.neo4j.cypher.internal.util.InternalNotificationLogger;
import org.neo4j.cypher.internal.util.RecordingNotificationLogger;
import org.neo4j.fabric.eval.StaticUseEvaluation;
import org.neo4j.router.query.Query;
import org.neo4j.router.query.QueryPreParsedInfoParser;
import scala.Option;
import scala.jdk.javaapi.OptionConverters;

public class StandardQueryPreParser
implements QueryPreParsedInfoParser {
    public static final CatalogName SYSTEM_DATABASE_CATALOG_NAME = CatalogName.of((String)"system");
    private final QueryPreParsedInfoParser.Cache cache;
    private final PreParser preParser;
    private final CypherParsing parsing;
    private final CompilationTracer tracer;
    private final CancellationChecker cancellationChecker;
    private final StaticUseEvaluation staticUseEvaluation = new StaticUseEvaluation();

    public StandardQueryPreParser(QueryPreParsedInfoParser.Cache cache, PreParser preParser, CypherParsing parsing, CompilationTracer tracer, CancellationChecker cancellationChecker) {
        this.cache = cache;
        this.preParser = preParser;
        this.parsing = parsing;
        this.tracer = tracer;
        this.cancellationChecker = cancellationChecker;
    }

    @Override
    public QueryPreParsedInfoParser.PreParsedInfo parseQuery(Query query) {
        return this.cache.computeIfAbsent(query.text(), () -> this.doParseQuery(query));
    }

    private QueryPreParsedInfoParser.PreParsedInfo doParseQuery(Query query) {
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer.compileQuery(query.text());
        RecordingNotificationLogger notificationLogger = new RecordingNotificationLogger();
        PreParsedQuery preParsedQuery = this.preParser.preParse(query.text(), (InternalNotificationLogger)notificationLogger);
        BaseState parsedQuery = this.parse(query, queryTracer, preParsedQuery);
        return this.preParsedInfo(parsedQuery);
    }

    private BaseState parse(Query query, CompilationTracer.QueryCompilationEvent queryTracer, PreParsedQuery preParsedQuery) {
        return this.parsing.parseQuery(preParsedQuery.statement(), preParsedQuery.rawStatement(), (InternalNotificationLogger)new RecordingNotificationLogger(), preParsedQuery.options().queryOptions().planner().name(), Option.apply((Object)preParsedQuery.options().offset()), (CompilationPhaseTracer)queryTracer, query.parameters(), this.cancellationChecker);
    }

    private QueryPreParsedInfoParser.PreParsedInfo preParsedInfo(BaseState parsedQuery) {
        Statement statement = parsedQuery.statement();
        Optional obfuscationMetadata = OptionConverters.toJava((Option)parsedQuery.maybeObfuscationMetadata());
        if (statement instanceof AdministrationCommand) {
            return new QueryPreParsedInfoParser.PreParsedInfo(Optional.of(SYSTEM_DATABASE_CATALOG_NAME), obfuscationMetadata);
        }
        Option catalogNameOption = this.staticUseEvaluation.evaluateStaticLeadingGraphSelection(statement);
        return new QueryPreParsedInfoParser.PreParsedInfo(OptionConverters.toJava((Option)catalogNameOption), obfuscationMetadata);
    }
}

