/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.router.impl.transaction;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.fabric.bookmark.TransactionBookmarkManager;
import org.neo4j.fabric.executor.Location;
import org.neo4j.fabric.transaction.ErrorReporter;
import org.neo4j.fabric.transaction.TransactionMode;
import org.neo4j.fabric.transaction.parent.AbstractCompoundTransaction;
import org.neo4j.kernel.api.TerminationMark;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.router.QueryRouterException;
import org.neo4j.router.impl.query.StatementType;
import org.neo4j.router.transaction.DatabaseTransaction;
import org.neo4j.router.transaction.DatabaseTransactionFactory;
import org.neo4j.router.transaction.RouterTransaction;
import org.neo4j.router.transaction.TransactionInfo;
import org.neo4j.time.SystemNanoClock;
import reactor.core.publisher.Mono;

public class RouterTransactionImpl
extends AbstractCompoundTransaction<DatabaseTransaction>
implements RouterTransaction {
    private final TransactionInfo transactionInfo;
    private final DatabaseTransactionFactory<Location.Local> localDatabaseTransactionFactory;
    private final DatabaseTransactionFactory<Location.Remote> remoteDatabaseTransactionFactory;
    private final TransactionBookmarkManager transactionBookmarkManager;
    private final ConcurrentHashMap<UUID, DatabaseTransaction> databaseTransactions;
    private StatementType statementType = null;

    public RouterTransactionImpl(TransactionInfo transactionInfo, DatabaseTransactionFactory<Location.Local> localDatabaseTransactionFactory, DatabaseTransactionFactory<Location.Remote> remoteDatabaseTransactionFactory, ErrorReporter errorReporter, SystemNanoClock clock, TransactionBookmarkManager transactionBookmarkManager) {
        super(errorReporter, clock);
        this.transactionInfo = transactionInfo;
        this.localDatabaseTransactionFactory = localDatabaseTransactionFactory;
        this.remoteDatabaseTransactionFactory = remoteDatabaseTransactionFactory;
        this.transactionBookmarkManager = transactionBookmarkManager;
        this.databaseTransactions = new ConcurrentHashMap();
    }

    @Override
    public DatabaseTransaction transactionFor(Location location) {
        TransactionMode mode = switch (this.transactionInfo.accessMode()) {
            default -> throw new IncompatibleClassChangeError();
            case AccessMode.WRITE -> TransactionMode.MAYBE_WRITE;
            case AccessMode.READ -> TransactionMode.DEFINITELY_READ;
        };
        return this.databaseTransactions.computeIfAbsent(location.databaseReference().id(), ref -> (DatabaseTransaction)this.registerNewChildTransaction(location, mode, () -> this.createTransactionFor(location)));
    }

    private DatabaseTransaction createTransactionFor(Location location) {
        if (location instanceof Location.Local) {
            Location.Local local = (Location.Local)location;
            return this.localDatabaseTransactionFactory.beginTransaction(local, this.transactionInfo, this.transactionBookmarkManager);
        }
        if (location instanceof Location.Remote) {
            Location.Remote remote = (Location.Remote)location;
            return this.remoteDatabaseTransactionFactory.beginTransaction(remote, this.transactionInfo, this.transactionBookmarkManager);
        }
        throw new IllegalArgumentException("Unexpected Location type: " + location);
    }

    protected boolean isUninitialized() {
        return false;
    }

    protected void closeContextsAndRemoveTransaction() {
        this.databaseTransactions.values().forEach(DatabaseTransaction::close);
    }

    protected Mono<Void> childTransactionCommit(DatabaseTransaction databaseTransaction) {
        return Mono.fromRunnable(databaseTransaction::commit);
    }

    protected Mono<Void> childTransactionRollback(DatabaseTransaction databaseTransaction) {
        return Mono.fromRunnable(databaseTransaction::rollback);
    }

    protected Mono<Void> childTransactionTerminate(DatabaseTransaction databaseTransaction, Status reason) {
        return Mono.fromRunnable(() -> databaseTransaction.terminate(reason));
    }

    @Override
    public Optional<Status> getReasonIfTerminated() {
        return this.getTerminationMark().map(TerminationMark::getReason);
    }

    @Override
    public void verifyStatementType(StatementType type) {
        if (this.statementType == null) {
            this.statementType = type;
        } else {
            StatementType oldType = this.statementType;
            if (oldType != type) {
                boolean allowedCombination;
                boolean queryAfterQuery = type.isQuery() && oldType.isQuery();
                boolean readQueryAfterSchema = type.isReadQuery() && oldType.isSchemaCommand();
                boolean schemaAfterReadQuery = type.isSchemaCommand() && oldType.isReadQuery();
                boolean bl = allowedCombination = queryAfterQuery || readQueryAfterSchema || schemaAfterReadQuery;
                if (allowedCombination) {
                    boolean upgrade;
                    boolean writeQueryAfterReadQuery = queryAfterQuery && !type.isReadQuery() && oldType.isReadQuery();
                    boolean bl2 = upgrade = writeQueryAfterReadQuery || schemaAfterReadQuery;
                    if (upgrade) {
                        this.statementType = type;
                    }
                } else {
                    throw new QueryRouterException((Status)Status.Transaction.ForbiddenDueToTransactionType, "Tried to execute %s after executing %s", new Object[]{type, oldType});
                }
            }
        }
    }
}

