/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.router.impl.transaction;

import java.time.Duration;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.kernel.api.TerminationMark;
import org.neo4j.kernel.api.TransactionTimeout;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.transaction.monitor.TransactionMonitor;
import org.neo4j.kernel.impl.api.transaction.trace.TransactionInitializationTrace;
import org.neo4j.logging.internal.LogService;
import org.neo4j.router.impl.transaction.RouterTransactionImpl;
import org.neo4j.router.transaction.TransactionInfo;
import org.neo4j.time.SystemNanoClock;

public class QueryRouterTransactionMonitor
extends TransactionMonitor<QueryRouterMonitoredTransaction> {
    private final Map<RouterTransactionImpl, QueryRouterMonitoredTransaction> transactions = new ConcurrentHashMap<RouterTransactionImpl, QueryRouterMonitoredTransaction>();
    private final SystemNanoClock clock;
    private final Config config;

    public QueryRouterTransactionMonitor(Config config, SystemNanoClock clock, LogService logService) {
        super(config, clock, logService);
        this.clock = clock;
        this.config = config;
    }

    public void startMonitoringTransaction(RouterTransactionImpl transaction) {
        long startTimeNanos = this.clock.nanos();
        TransactionInfo transactionInfo = transaction.transactionInfo();
        TransactionTimeout timeout = transactionInfo.txTimeout() != null ? new TransactionTimeout(transactionInfo.txTimeout(), (Status)Status.Transaction.TransactionTimedOutClientConfiguration) : new TransactionTimeout((Duration)this.config.get(GraphDatabaseSettings.transaction_timeout), (Status)Status.Transaction.TransactionTimedOut);
        this.transactions.put(transaction, new QueryRouterMonitoredTransaction(transaction, startTimeNanos, timeout));
    }

    public void stopMonitoringTransaction(RouterTransactionImpl transaction) {
        this.transactions.remove(transaction);
    }

    protected Set<QueryRouterMonitoredTransaction> getActiveTransactions() {
        return new HashSet<QueryRouterMonitoredTransaction>(this.transactions.values());
    }

    static class QueryRouterMonitoredTransaction
    implements TransactionMonitor.MonitoredTransaction {
        private final RouterTransactionImpl routerTransaction;
        private final long startTimeNanos;
        private final TransactionTimeout timeout;

        QueryRouterMonitoredTransaction(RouterTransactionImpl routerTransaction, long startTimeNanos, TransactionTimeout timeout) {
            this.routerTransaction = routerTransaction;
            this.startTimeNanos = startTimeNanos;
            this.timeout = timeout;
        }

        public long startTimeNanos() {
            return this.startTimeNanos;
        }

        public TransactionTimeout timeout() {
            return this.timeout;
        }

        public boolean isSchemaTransaction() {
            return this.routerTransaction.isSchemaTransaction();
        }

        public Optional<TerminationMark> terminationMark() {
            return this.routerTransaction.getTerminationMark();
        }

        public boolean markForTermination(Status reason) {
            return this.routerTransaction.markForTermination(reason);
        }

        public String getIdentifyingDescription() {
            StringBuilder sb = new StringBuilder();
            sb.append("QueryRouterTransaction[");
            String rawAddress = this.routerTransaction.transactionInfo().clientInfo().clientAddress();
            String address = rawAddress == null ? "embedded" : rawAddress;
            sb.append("clientAddress=").append(address);
            AuthSubject authSubject = this.routerTransaction.transactionInfo().loginContext().subject();
            if (authSubject != AuthSubject.ANONYMOUS && authSubject != AuthSubject.AUTH_DISABLED) {
                sb.append(",").append("username=").append(authSubject.executingUser());
            }
            sb.append("]");
            return sb.toString();
        }

        public TransactionInitializationTrace transactionInitialisationTrace() {
            return this.routerTransaction.initializationTrace();
        }
    }
}

