/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.router;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseServiceSPI;
import org.neo4j.bolt.dbapi.BoltTransaction;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.bolt.protocol.common.message.request.connection.RoutingContext;
import org.neo4j.collection.Dependencies;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.cypher.internal.PreParser;
import org.neo4j.cypher.internal.cache.CacheTracer;
import org.neo4j.cypher.internal.cache.CaffeineCacheFactory;
import org.neo4j.cypher.internal.cache.ExecutorBasedCaffeineCacheFactory;
import org.neo4j.cypher.internal.compiler.CypherParsing;
import org.neo4j.cypher.internal.compiler.CypherParsingConfig;
import org.neo4j.cypher.internal.compiler.CypherPlannerConfiguration;
import org.neo4j.cypher.internal.config.CypherConfiguration;
import org.neo4j.cypher.internal.tracing.CompilationTracer;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.exceptions.InvalidSemanticsException;
import org.neo4j.fabric.bookmark.LocalGraphTransactionIdTracker;
import org.neo4j.fabric.bootstrap.CommonQueryRouterBoostrap;
import org.neo4j.fabric.executor.Location;
import org.neo4j.fabric.executor.QueryStatementLifecycles;
import org.neo4j.fabric.transaction.ErrorReporter;
import org.neo4j.fabric.transaction.TransactionManager;
import org.neo4j.function.Observable;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.impl.api.transaction.monitor.TransactionMonitor;
import org.neo4j.kernel.impl.api.transaction.monitor.TransactionMonitorScheduler;
import org.neo4j.kernel.impl.query.QueryExecutionConfiguration;
import org.neo4j.kernel.impl.query.QueryRoutingMonitor;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.logging.internal.LogService;
import org.neo4j.monitoring.Monitors;
import org.neo4j.router.impl.CommunityLocationService;
import org.neo4j.router.impl.QueryRouterImpl;
import org.neo4j.router.impl.bolt.QueryRouterBoltSpi;
import org.neo4j.router.impl.query.DefaultDatabaseReferenceResolver;
import org.neo4j.router.impl.query.ProcessedQueryInfoCache;
import org.neo4j.router.impl.query.QueryProcessorImpl;
import org.neo4j.router.impl.transaction.QueryRouterTransactionMonitor;
import org.neo4j.router.impl.transaction.RouterTransactionManager;
import org.neo4j.router.impl.transaction.database.LocalDatabaseTransactionFactory;
import org.neo4j.router.location.LocationService;
import org.neo4j.router.transaction.DatabaseTransactionFactory;
import org.neo4j.router.transaction.RoutingInfo;
import org.neo4j.router.transaction.TransactionLookup;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.MonitoredJobExecutor;
import org.neo4j.time.SystemNanoClock;

public class CommunityQueryRouterBoostrap
extends CommonQueryRouterBoostrap {
    private final LogService logService;
    private final DatabaseContextProvider<? extends DatabaseContext> databaseProvider;
    private final DatabaseReferenceRepository databaseReferenceRepo;
    private final AbstractSecurityLog securityLog;

    public CommunityQueryRouterBoostrap(LifeSupport lifeSupport, Dependencies dependencies, LogService logService, DatabaseContextProvider<? extends DatabaseContext> databaseProvider, DatabaseReferenceRepository databaseReferenceRepo, AbstractSecurityLog securityLog) {
        super(lifeSupport, dependencies, databaseProvider);
        this.logService = logService;
        this.databaseProvider = databaseProvider;
        this.databaseReferenceRepo = databaseReferenceRepo;
        this.securityLog = securityLog;
    }

    public BoltGraphDatabaseManagementServiceSPI bootstrapServices(DatabaseManagementService databaseManagementService) {
        this.bootstrapCommonServices(databaseManagementService, this.logService);
        return this.createBoltDatabaseManagementServiceProvider();
    }

    protected BoltGraphDatabaseManagementServiceSPI getCompositeDatabaseStack() {
        return (databaseName, memoryTracker) -> new BoltGraphDatabaseServiceSPI(){

            public BoltTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo clientInfo, List<String> bookmarks, Duration txTimeout, AccessMode accessMode, Map<String, Object> txMetadata, RoutingContext routingContext, QueryExecutionConfiguration queryExecutionConfiguration) {
                throw new InvalidSemanticsException("Composite database is not supported in Community Edition");
            }

            public DatabaseReference getDatabaseReference() {
                throw new InvalidSemanticsException("Composite database is not supported in Community Edition");
            }
        };
    }

    protected LocationService createLocationService(RoutingInfo routingInfo) {
        return new CommunityLocationService();
    }

    protected DatabaseTransactionFactory<Location.Remote> createRemoteDatabaseTransactionFactory() {
        return (location, transactionInfo, bookmarkManager, terminationCallback) -> {
            throw new IllegalStateException("Remote transactions are not supported in Community Edition");
        };
    }

    protected BoltGraphDatabaseManagementServiceSPI createBoltDatabaseManagementServiceProvider() {
        Config config = this.resolve(Config.class);
        CypherConfiguration cypherConfig = CypherConfiguration.fromConfig((Config)config);
        JobScheduler jobScheduler = this.resolve(JobScheduler.class);
        MonitoredJobExecutor monitoredExecutor = jobScheduler.monitoredJobExecutor(Group.CYPHER_CACHE);
        Monitors monitors = this.resolve(Monitors.class);
        ExecutorBasedCaffeineCacheFactory cacheFactory = new ExecutorBasedCaffeineCacheFactory(job -> monitoredExecutor.execute(JobMonitoringParams.systemJob((String)"Query plan cache maintenance"), job));
        ProcessedQueryInfoCache targetCache = new ProcessedQueryInfoCache((CaffeineCacheFactory)cacheFactory, (Observable<Integer>)cypherConfig.queryCacheSize(), (CacheTracer<String>)((CacheTracer)monitors.newMonitor(CacheTracer.class, new String[]{"cypher.cache.router"})));
        PreParser preParser = new PreParser(cypherConfig);
        CypherPlannerConfiguration plannerConfig = CypherPlannerConfiguration.fromCypherConfiguration((CypherConfiguration)cypherConfig, (Config)config, (boolean)true);
        CypherParsing parsing = new CypherParsing(null, CypherParsingConfig.fromCypherPlannerConfiguration((CypherPlannerConfiguration)plannerConfig));
        DefaultDatabaseReferenceResolver databaseReferenceResolver = new DefaultDatabaseReferenceResolver(this.databaseReferenceRepo);
        DatabaseContextProvider databaseManager = this.resolve(DatabaseContextProvider.class);
        Tracers tracers = this.resolve(Tracers.class);
        SystemNanoClock systemNanoClock = this.resolve(SystemNanoClock.class);
        QueryStatementLifecycles statementLifecycles = new QueryStatementLifecycles(databaseManager, monitors, config, tracers.getLockTracer(), systemNanoClock);
        GlobalProcedures globalProcedures = this.resolve(GlobalProcedures.class);
        Boolean useQueryRouterForCompositeQueries = (Boolean)config.get(GraphDatabaseInternalSettings.composite_queries_with_query_router);
        LocalGraphTransactionIdTracker transactionIdTracker = this.resolve(LocalGraphTransactionIdTracker.class);
        QueryRouterTransactionMonitor txMonitor = new QueryRouterTransactionMonitor(config, systemNanoClock, this.logService);
        long transactionCheckInterval = ((Duration)config.get(GraphDatabaseSettings.transaction_monitor_check_interval)).toMillis();
        this.registerWithLifecycle((Lifecycle)new TransactionMonitorScheduler((TransactionMonitor)txMonitor, jobScheduler, transactionCheckInterval, null));
        RouterTransactionManager routerTxManager = new RouterTransactionManager(txMonitor);
        this.dependencies.satisfyDependency((Object)routerTxManager);
        TransactionManager compositeTxManager = null;
        if (this.dependencies.containsDependency(TransactionManager.class)) {
            compositeTxManager = (TransactionManager)this.dependencies.resolveDependency(TransactionManager.class);
        }
        TransactionLookup transactionLookup = new TransactionLookup(routerTxManager, compositeTxManager);
        this.dependencies.satisfyDependency((Object)transactionLookup);
        QueryRouterImpl queryRouter = new QueryRouterImpl(config, databaseReferenceResolver, this::createLocationService, new QueryProcessorImpl(targetCache, preParser, parsing, CompilationTracer.NO_COMPILATION_TRACING, globalProcedures, this.databaseProvider), this.getLocalDatabaseTransactionFactory(this.databaseProvider, transactionIdTracker), this.createRemoteDatabaseTransactionFactory(), new ErrorReporter(this.logService), systemNanoClock, transactionIdTracker, statementLifecycles, (QueryRoutingMonitor)monitors.newMonitor(QueryRoutingMonitor.class, new String[0]), routerTxManager, this.securityLog);
        this.dependencies.satisfyDependency((Object)queryRouter);
        return new QueryRouterBoltSpi.DatabaseManagementService(queryRouter, databaseReferenceResolver, this.getCompositeDatabaseStack(), useQueryRouterForCompositeQueries);
    }

    protected LocalDatabaseTransactionFactory getLocalDatabaseTransactionFactory(DatabaseContextProvider<? extends DatabaseContext> databaseProvider, LocalGraphTransactionIdTracker transactionIdTracker) {
        return new LocalDatabaseTransactionFactory(databaseProvider, transactionIdTracker);
    }

    protected <T> T resolve(Class<T> type) {
        return (T)this.dependencies.resolveDependency(type);
    }

    protected LogService getLogService() {
        return this.logService;
    }
}

