/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.router.impl.query;

import java.util.function.BiFunction;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.cypher.internal.QueryOptions;
import org.neo4j.cypher.internal.options.CypherExecutionMode;
import org.neo4j.cypher.internal.util.CancellationChecker;
import org.neo4j.cypher.rendering.QueryRenderer;
import org.neo4j.fabric.executor.Location;
import org.neo4j.fabric.executor.QueryStatementLifecycles;
import org.neo4j.fabric.transaction.TransactionMode;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.impl.query.ConstituentTransactionFactory;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.router.impl.query.DirectTargetService;
import org.neo4j.router.location.LocationService;
import org.neo4j.router.query.Query;
import org.neo4j.router.query.QueryProcessor;
import org.neo4j.router.query.TargetService;
import org.neo4j.router.transaction.DatabaseTransaction;
import org.neo4j.router.transaction.TransactionInfo;
import org.neo4j.values.virtual.MapValue;

public class ConstituentTransactionFactoryImpl
implements ConstituentTransactionFactory {
    private final QueryStatementLifecycles statementLifecycles;
    private final CancellationChecker cancellationChecker;
    private final QueryOptions queryOptions;
    private final QueryProcessor queryProcessor;
    private final TransactionInfo transactionInfo;
    private final BiFunction<Location, TransactionMode, DatabaseTransaction> transactionFor;
    private final LocationService locationService;
    private final String NL = System.lineSeparator();

    public ConstituentTransactionFactoryImpl(QueryProcessor queryProcessor, BiFunction<Location, TransactionMode, DatabaseTransaction> transactionFor, LocationService locationService, QueryStatementLifecycles queryStatementLifecycles, TransactionInfo transactionInfo, CancellationChecker cancellationChecker, QueryOptions queryOptions) {
        this.queryProcessor = queryProcessor;
        this.transactionInfo = transactionInfo;
        this.transactionFor = transactionFor;
        this.locationService = locationService;
        this.statementLifecycles = queryStatementLifecycles;
        this.cancellationChecker = cancellationChecker;
        this.queryOptions = queryOptions;
    }

    public ConstituentTransactionFactory.ConstituentTransaction transactionFor(DatabaseReference databaseReference) {
        return new ConstituentTransactionImpl(databaseReference);
    }

    public class ConstituentTransactionImpl
    implements ConstituentTransactionFactory.ConstituentTransaction {
        private final DatabaseReference reference;
        private final TargetService targetService;
        private final Location location;

        public ConstituentTransactionImpl(DatabaseReference reference) {
            this.reference = reference;
            this.targetService = new DirectTargetService(reference);
            this.location = ConstituentTransactionFactoryImpl.this.locationService.locationOf(reference);
        }

        public QueryExecution executeQuery(String queryString, MapValue parameters, QuerySubscriber querySubscriber) throws QueryExecutionKernelException {
            QueryStatementLifecycles.StatementLifecycle statementLifecycle = ConstituentTransactionFactoryImpl.this.statementLifecycles.create(ConstituentTransactionFactoryImpl.this.transactionInfo.statementLifecycleTransactionInfo(), queryString, parameters, null);
            statementLifecycle.startProcessing();
            Query query = Query.of(QueryRenderer.addOptions((String)queryString, (QueryOptions)ConstituentTransactionFactoryImpl.this.queryOptions), parameters);
            QueryProcessor.ProcessedQueryInfo processedQuery = ConstituentTransactionFactoryImpl.this.queryProcessor.processQuery(query, this.targetService, dbRef -> this.location, ConstituentTransactionFactoryImpl.this.cancellationChecker, false);
            statementLifecycle.doneRouterProcessing(processedQuery.obfuscationMetadata().get(), this.reference.isComposite());
            TransactionMode mode = TransactionMode.from((AccessMode)ConstituentTransactionFactoryImpl.this.transactionInfo.accessMode(), (CypherExecutionMode)ConstituentTransactionFactoryImpl.this.queryOptions.queryOptions().executionMode(), (boolean)processedQuery.statementType().isReadQuery(), (boolean)this.reference.isComposite());
            return ConstituentTransactionFactoryImpl.this.transactionFor.apply(this.location, mode).executeQuery(query, querySubscriber, statementLifecycle);
        }
    }
}

