/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.router.impl.query;

import java.util.Optional;
import org.neo4j.cypher.internal.ast.CatalogName;
import org.neo4j.cypher.messages.MessageUtilProvider;
import org.neo4j.exceptions.InvalidSemanticsException;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.router.query.DatabaseReferenceResolver;
import org.neo4j.router.query.TargetService;

public class StandardTargetService
implements TargetService {
    private final DatabaseReference sessionDatabase;
    private final DatabaseReferenceResolver databaseReferenceResolver;

    public StandardTargetService(DatabaseReference sessionDatabase, DatabaseReferenceResolver databaseReferenceResolver) {
        this.sessionDatabase = sessionDatabase;
        this.databaseReferenceResolver = databaseReferenceResolver;
    }

    @Override
    public DatabaseReference target(TargetService.CatalogInfo catalogInfo) {
        Optional<DatabaseReference> parsedTarget = this.toCatalogName(catalogInfo).map(CatalogName::qualifiedNameString).map(this.databaseReferenceResolver::resolve);
        if (parsedTarget.filter(target -> target.isComposite() || !target.isPrimary() && target.namespace().isPresent()).isPresent()) {
            String message = "Accessing a composite database and its constituents is only allowed when connected to it. Attempted to access '%s' while connected to '%s'";
            throw new InvalidSemanticsException(String.format(message, parsedTarget.get().toPrettyString(), this.sessionDatabase.toPrettyString()));
        }
        return parsedTarget.orElse(this.sessionDatabase);
    }

    private Optional<CatalogName> toCatalogName(TargetService.CatalogInfo catalogInfo) {
        if (catalogInfo instanceof TargetService.SingleQueryCatalogInfo) {
            TargetService.SingleQueryCatalogInfo singleQueryCatalogInfo = (TargetService.SingleQueryCatalogInfo)catalogInfo;
            return singleQueryCatalogInfo.catalogName();
        }
        if (catalogInfo instanceof TargetService.UnionQueryCatalogInfo) {
            TargetService.UnionQueryCatalogInfo unionQueryCatalogInfo = (TargetService.UnionQueryCatalogInfo)catalogInfo;
            Optional<CatalogName> catalogName = unionQueryCatalogInfo.catalogNames().get(0);
            if (catalogName.isPresent() && unionQueryCatalogInfo.catalogNames().stream().anyMatch(Optional::isEmpty)) {
                NormalizedDatabaseName normalizedDatabaseName = new NormalizedDatabaseName(catalogName.get().qualifiedNameString());
                if (!this.sessionDatabase.fullName().name().equals(normalizedDatabaseName.name())) {
                    throw new InvalidSemanticsException(MessageUtilProvider.createMultipleGraphReferencesError((String)normalizedDatabaseName.name(), (boolean)false));
                }
            }
            return catalogName;
        }
        throw new IllegalArgumentException("Unexpected catalog info " + catalogInfo);
    }
}

