/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.router.impl;

import java.util.Set;
import java.util.function.Function;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.configuration.Config;
import org.neo4j.cypher.internal.QueryOptions;
import org.neo4j.cypher.internal.options.CypherExecutionMode;
import org.neo4j.cypher.internal.util.CancellationChecker;
import org.neo4j.cypher.internal.util.InputPosition;
import org.neo4j.cypher.internal.util.ObfuscationMetadata;
import org.neo4j.fabric.bookmark.BookmarkFormat;
import org.neo4j.fabric.bookmark.LocalGraphTransactionIdTracker;
import org.neo4j.fabric.bookmark.TransactionBookmarkManager;
import org.neo4j.fabric.bookmark.TransactionBookmarkManagerImpl;
import org.neo4j.fabric.executor.Location;
import org.neo4j.fabric.executor.QueryStatementLifecycles;
import org.neo4j.fabric.transaction.ErrorReporter;
import org.neo4j.fabric.transaction.TransactionMode;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceImpl;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.kernel.database.PrivilegeDatabaseReference;
import org.neo4j.kernel.impl.api.transaction.trace.TraceProviderFactory;
import org.neo4j.kernel.impl.query.ConstituentTransactionFactory;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QueryRoutingMonitor;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.logging.InternalLog;
import org.neo4j.router.QueryRouter;
import org.neo4j.router.QueryRouterException;
import org.neo4j.router.impl.query.ConstituentTransactionFactoryImpl;
import org.neo4j.router.impl.query.DirectTargetService;
import org.neo4j.router.impl.query.StandardTargetService;
import org.neo4j.router.impl.query.StatementType;
import org.neo4j.router.impl.query.TransactionTargetService;
import org.neo4j.router.impl.transaction.RouterTransactionContextImpl;
import org.neo4j.router.impl.transaction.RouterTransactionImpl;
import org.neo4j.router.impl.transaction.RouterTransactionManager;
import org.neo4j.router.impl.transaction.database.LocalDatabaseTransaction;
import org.neo4j.router.location.LocationService;
import org.neo4j.router.query.DatabaseReferenceResolver;
import org.neo4j.router.query.Query;
import org.neo4j.router.query.QueryProcessor;
import org.neo4j.router.query.TargetService;
import org.neo4j.router.transaction.DatabaseTransaction;
import org.neo4j.router.transaction.DatabaseTransactionFactory;
import org.neo4j.router.transaction.RouterTransaction;
import org.neo4j.router.transaction.RouterTransactionContext;
import org.neo4j.router.transaction.RoutingInfo;
import org.neo4j.router.transaction.TransactionInfo;
import org.neo4j.router.util.Errors;
import org.neo4j.time.SystemNanoClock;

public class QueryRouterImpl
implements QueryRouter {
    private final QueryProcessor queryProcessor;
    private final DatabaseTransactionFactory<Location.Local> localDatabaseTransactionFactory;
    private final DatabaseTransactionFactory<Location.Remote> remoteDatabaseTransactionFactory;
    private final Function<RoutingInfo, LocationService> locationServiceFactory;
    private final Config config;
    private final DatabaseReferenceResolver databaseReferenceResolver;
    private final ErrorReporter errorReporter;
    private final SystemNanoClock systemNanoClock;
    private final LocalGraphTransactionIdTracker transactionIdTracker;
    private final QueryStatementLifecycles statementLifecycles;
    private final RouterTransactionManager transactionManager;
    private final QueryRoutingMonitor queryRoutingMonitor;
    private final AbstractSecurityLog securityLog;
    private final InternalLog queryRouterLog;

    public QueryRouterImpl(Config config, DatabaseReferenceResolver databaseReferenceResolver, Function<RoutingInfo, LocationService> locationServiceFactory, QueryProcessor queryProcessor, DatabaseTransactionFactory<Location.Local> localDatabaseTransactionFactory, DatabaseTransactionFactory<Location.Remote> remoteDatabaseTransactionFactory, ErrorReporter errorReporter, SystemNanoClock systemNanoClock, LocalGraphTransactionIdTracker transactionIdTracker, QueryStatementLifecycles statementLifecycles, QueryRoutingMonitor queryRoutingMonitor, RouterTransactionManager transactionManager, AbstractSecurityLog securityLog, InternalLog queryRouterLog) {
        this.config = config;
        this.databaseReferenceResolver = databaseReferenceResolver;
        this.locationServiceFactory = locationServiceFactory;
        this.queryProcessor = queryProcessor;
        this.localDatabaseTransactionFactory = localDatabaseTransactionFactory;
        this.remoteDatabaseTransactionFactory = remoteDatabaseTransactionFactory;
        this.errorReporter = errorReporter;
        this.systemNanoClock = systemNanoClock;
        this.transactionIdTracker = transactionIdTracker;
        this.statementLifecycles = statementLifecycles;
        this.queryRoutingMonitor = queryRoutingMonitor;
        this.transactionManager = transactionManager;
        this.securityLog = securityLog;
        this.queryRouterLog = queryRouterLog;
    }

    @Override
    public RouterTransactionContext beginTransaction(TransactionInfo incomingTransactionInfo) {
        TransactionBookmarkManagerImpl transactionBookmarkManager = new TransactionBookmarkManagerImpl(BookmarkFormat.parse(incomingTransactionInfo.bookmarks()));
        transactionBookmarkManager.getBookmarkForLocalSystemDatabase().ifPresent(localBookmark -> this.transactionIdTracker.awaitSystemGraphUpToDate(localBookmark.transactionId()));
        TransactionInfo transactionInfo = incomingTransactionInfo.withDefaults(this.config);
        DatabaseReference sessionDatabaseReference = this.resolveSessionDatabaseReference(transactionInfo);
        this.authorize(sessionDatabaseReference, incomingTransactionInfo.loginContext());
        RoutingInfo routingInfo = new RoutingInfo(sessionDatabaseReference, transactionInfo.routingContext(), transactionInfo.accessMode());
        TargetService queryTargetService = this.createTargetService(routingInfo);
        LocationService locationService = this.createLocationService(routingInfo);
        RouterTransactionImpl routerTransaction = this.createRouterTransaction(transactionInfo, (TransactionBookmarkManager)transactionBookmarkManager);
        this.transactionManager.registerTransaction(routerTransaction);
        boolean rpcCall = this.isRpcCall(sessionDatabaseReference);
        DatabaseTransaction sessionTransaction = null;
        try {
            TransactionMode dummyTransactionMode = transactionInfo.accessMode().equals((Object)AccessMode.READ) ? TransactionMode.DEFINITELY_READ : TransactionMode.MAYBE_WRITE;
            Location.Local location = rpcCall ? new Location.Local(-1L, (DatabaseReferenceImpl.Internal)sessionDatabaseReference) : locationService.locationOf(sessionDatabaseReference);
            sessionTransaction = routerTransaction.transactionFor((Location)location, dummyTransactionMode, locationService);
        }
        catch (Exception e) {
            this.queryRouterLog.warn("Could not eagerly create kernel transaction due to: %s".formatted(e));
        }
        return new RouterTransactionContextImpl(transactionInfo, routingInfo, routerTransaction, new TransactionTargetService(queryTargetService), locationService, (TransactionBookmarkManager)transactionBookmarkManager, sessionTransaction, rpcCall);
    }

    private DatabaseReference resolveSessionDatabaseReference(TransactionInfo transactionInfo) {
        NormalizedDatabaseName sessionDatabaseName = transactionInfo.sessionDatabaseName();
        return this.databaseReferenceResolver.resolve(sessionDatabaseName);
    }

    private TargetService createTargetService(RoutingInfo routingInfo) {
        DatabaseReference sessionDatabaseReference = routingInfo.sessionDatabaseReference();
        if (sessionDatabaseReference.isComposite()) {
            return new DirectTargetService(sessionDatabaseReference);
        }
        return new StandardTargetService(sessionDatabaseReference, this.databaseReferenceResolver);
    }

    private CypherExecutionMode executionMode(QueryOptions queryOptions, Boolean isComposite) {
        CypherExecutionMode cypherExecutionMode = queryOptions.queryOptions().executionMode();
        if (isComposite.booleanValue() && cypherExecutionMode.isProfile()) {
            Errors.semantic("'PROFILE' is not supported on composite databases.");
        }
        return cypherExecutionMode;
    }

    private LocationService createLocationService(RoutingInfo routingInfo) {
        return this.locationServiceFactory.apply(routingInfo);
    }

    private RouterTransactionImpl createRouterTransaction(TransactionInfo transactionInfo, TransactionBookmarkManager transactionBookmarkManager) {
        return new RouterTransactionImpl(transactionInfo, this.localDatabaseTransactionFactory, this.remoteDatabaseTransactionFactory, this.errorReporter, this.systemNanoClock, transactionBookmarkManager, TraceProviderFactory.getTraceProvider((Config)this.config), this.transactionManager);
    }

    private void authorize(DatabaseReference sessionDb, LoginContext loginContext) {
        loginContext.authorize(LoginContext.IdLookup.EMPTY, (PrivilegeDatabaseReference)sessionDb, this.securityLog);
    }

    private boolean isRpcCall(DatabaseReference databaseReference) {
        return databaseReference instanceof DatabaseReferenceImpl.SPDShard;
    }

    @Override
    public QueryExecution executeQuery(RouterTransactionContext context, Query query, QuerySubscriber subscriber) {
        if (context.isRpcCall()) {
            return this.executeRpcQuery(context, query, subscriber);
        }
        TransactionInfo transactionInfo = context.transactionInfo();
        QueryStatementLifecycles.StatementLifecycle statementLifecycle = this.statementLifecycles.create(transactionInfo.statementLifecycleTransactionInfo(), query.text(), query.parameters(), null);
        statementLifecycle.startProcessing();
        try {
            LocationService locationService = context.locationService();
            QueryProcessor.ProcessedQueryInfo processedQueryInfo = this.queryProcessor.processQuery(query, context.targetService(), locationService, this.cancellationChecker(context.routerTransaction()), context.sessionDatabaseReference());
            StatementType statementType = processedQueryInfo.statementType();
            QueryOptions queryOptions = processedQueryInfo.queryOptions();
            CypherExecutionMode executionMode = this.executionMode(queryOptions, transactionInfo.isComposite());
            AccessMode accessMode = transactionInfo.accessMode();
            context.verifyStatementType(statementType);
            DatabaseReference target = processedQueryInfo.target();
            this.verifyAccessModeWithStatementType(executionMode, accessMode, statementType, target);
            Location location = locationService.locationOf(target);
            if (statementType.statementType().equals((Object)StatementType.AdminCommand()) && !transactionInfo.targetsSystemDatabase() && context.sessionTransaction() != null) {
                context.routerTransaction().closeTransaction(context.sessionTransaction());
            }
            this.updateQueryRouterMetric(location);
            statementLifecycle.doneRouterProcessing(processedQueryInfo.obfuscationMetadata().get(), queryOptions.offset(), target.isComposite(), processedQueryInfo.parsingNotifications());
            RouterTransaction routerTransaction = context.routerTransaction();
            ConstituentTransactionFactory constituentTransactionFactory = this.getConstituentTransactionFactory(context, queryOptions);
            routerTransaction.setConstituentTransactionFactory(constituentTransactionFactory);
            DatabaseTransaction databaseTransaction = context.transactionFor(location, TransactionMode.from((AccessMode)accessMode, (CypherExecutionMode)executionMode, (boolean)statementType.isReadQuery(), (boolean)target.isComposite()));
            if (databaseTransaction instanceof LocalDatabaseTransaction) {
                ((LocalDatabaseTransaction)databaseTransaction).setConstituentTransactionFactory(constituentTransactionFactory);
            }
            return databaseTransaction.executeQuery(processedQueryInfo.rewrittenQuery(), subscriber, statementLifecycle);
        }
        catch (RuntimeException e) {
            statementLifecycle.endFailure((Throwable)e);
            throw e;
        }
    }

    private QueryExecution executeRpcQuery(RouterTransactionContext context, Query query, QuerySubscriber subscriber) {
        TransactionInfo transactionInfo = context.transactionInfo();
        QueryStatementLifecycles.StatementLifecycle statementLifecycle = this.statementLifecycles.create(transactionInfo.statementLifecycleTransactionInfo(), query.text(), query.parameters(), null);
        statementLifecycle.startProcessing();
        statementLifecycle.doneRouterProcessing(ObfuscationMetadata.empty(), InputPosition.NONE(), false, Set.of());
        try {
            return context.sessionTransaction().executeQuery(query, subscriber, statementLifecycle);
        }
        catch (RuntimeException e) {
            statementLifecycle.endFailure((Throwable)e);
            throw e;
        }
    }

    private CancellationChecker cancellationChecker(RouterTransaction routerTransaction) {
        return () -> routerTransaction.throwIfTerminatedOrClosed(() -> "Trying to process query in a closed transaction");
    }

    private ConstituentTransactionFactory getConstituentTransactionFactory(RouterTransactionContext context, QueryOptions queryOptions) {
        if (!context.transactionInfo().isComposite()) {
            return ConstituentTransactionFactory.throwing();
        }
        return new ConstituentTransactionFactoryImpl(this.queryProcessor, this.statementLifecycles, this.cancellationChecker(context.routerTransaction()), queryOptions, context);
    }

    private void verifyAccessModeWithStatementType(CypherExecutionMode executionMode, AccessMode accessMode, StatementType statementType, DatabaseReference databaseReference) {
        if (!executionMode.isExplain() && accessMode == AccessMode.READ && statementType.isWrite()) {
            throw new QueryRouterException((Status)Status.Statement.AccessMode, "Writing in read access mode not allowed. Attempted write to %s", databaseReference.alias().name());
        }
    }

    @Override
    public long clearQueryCachesForDatabase(String databaseName) {
        return this.queryProcessor.clearQueryCachesForDatabase(databaseName);
    }

    private void updateQueryRouterMetric(Location location) {
        if (location instanceof Location.Local) {
            this.queryRoutingMonitor.queryRoutedLocal();
        } else if (location instanceof Location.Remote.Internal) {
            this.queryRoutingMonitor.queryRoutedRemoteInternal();
        } else {
            this.queryRoutingMonitor.queryRoutedRemoteExternal();
        }
    }
}

