/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.router.impl.transaction.database;

import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.neo4j.common.DependencyResolver;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.fabric.bookmark.LocalGraphTransactionIdTracker;
import org.neo4j.fabric.bookmark.TransactionBookmarkManager;
import org.neo4j.fabric.executor.Location;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.kernel.database.DatabaseReferenceImpl;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.factory.KernelTransactionFactory;
import org.neo4j.kernel.impl.query.ConstituentTransactionFactory;
import org.neo4j.kernel.impl.query.Neo4jTransactionalContextFactory;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.kernel.impl.query.TransactionalContextFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.router.QueryRouterException;
import org.neo4j.router.impl.transaction.database.LocalDatabaseTransaction;
import org.neo4j.router.transaction.DatabaseTransaction;
import org.neo4j.router.transaction.DatabaseTransactionFactory;
import org.neo4j.router.transaction.TransactionInfo;

public class LocalDatabaseTransactionFactory
implements DatabaseTransactionFactory<Location.Local> {
    protected final DatabaseContextProvider<?> databaseContextProvider;
    protected final LocalGraphTransactionIdTracker transactionIdTracker;

    public LocalDatabaseTransactionFactory(DatabaseContextProvider<?> databaseContextProvider, LocalGraphTransactionIdTracker transactionIdTracker) {
        this.databaseContextProvider = databaseContextProvider;
        this.transactionIdTracker = transactionIdTracker;
    }

    @Override
    public DatabaseTransaction beginTransaction(Location.Local location, TransactionInfo transactionInfo, TransactionBookmarkManager bookmarkManager, Consumer<Status> terminationCallback, ConstituentTransactionFactory constituentTransactionFactory) {
        DatabaseContext databaseContext = (DatabaseContext)this.databaseContextProvider.getDatabaseContext(location.databaseReference().databaseId()).orElseThrow(LocalDatabaseTransactionFactory.databaseNotFound(location.getDatabaseName()));
        GraphDatabaseAPI databaseApi = databaseContext.databaseFacade();
        DependencyResolver resolver = databaseContext.dependencies();
        try {
            databaseContext.database().getDatabaseAvailabilityGuard().assertDatabaseAvailable();
        }
        catch (UnavailableException e) {
            throw new QueryRouterException(e.status(), (Throwable)e);
        }
        QueryExecutionEngine queryExecutionEngine = (QueryExecutionEngine)resolver.resolveDependency(QueryExecutionEngine.class);
        TransactionalContextFactory transactionalContextFactory = this.getTransactionalContextFactory(location, resolver, this.dbMode(location));
        bookmarkManager.getBookmarkForLocal(location).ifPresent(bookmark -> this.transactionIdTracker.awaitGraphUpToDate(location, bookmark.transactionId()));
        InternalTransaction internalTransaction = this.beginInternalTransaction(databaseApi, transactionInfo, terminationCallback);
        return new LocalDatabaseTransaction(location, transactionInfo, internalTransaction, transactionalContextFactory, queryExecutionEngine, bookmarkManager, this.transactionIdTracker, constituentTransactionFactory);
    }

    protected TransactionalContextFactory getTransactionalContextFactory(Location.Local location, DependencyResolver resolver, TransactionalContext.DatabaseMode dbMode) {
        return Neo4jTransactionalContextFactory.create((Supplier)resolver.provideDependency(GraphDatabaseQueryService.class), (KernelTransactionFactory)((KernelTransactionFactory)resolver.resolveDependency(KernelTransactionFactory.class)), (TransactionalContext.DatabaseMode)dbMode);
    }

    protected InternalTransaction beginInternalTransaction(GraphDatabaseAPI databaseApi, TransactionInfo transactionInfo, Consumer<Status> terminationCallback) {
        InternalTransaction internalTransaction = databaseApi.beginTransaction(transactionInfo.type(), transactionInfo.loginContext(), transactionInfo.clientInfo(), transactionInfo.txTimeout().toMillis(), TimeUnit.MILLISECONDS, terminationCallback, this::transformTerminalOperationError);
        internalTransaction.setMetaData(transactionInfo.txMetadata());
        return internalTransaction;
    }

    private RuntimeException transformTerminalOperationError(Exception e) {
        if (e instanceof Status.HasStatus) {
            Status.HasStatus se = (Status.HasStatus)e;
            if (e instanceof RuntimeException) {
                RuntimeException re = (RuntimeException)e;
                return re;
            }
            return new QueryRouterException(se.status(), e.getMessage(), e);
        }
        throw new TransactionFailureException("Unable to complete transaction.", (Throwable)e);
    }

    protected static Supplier<DatabaseNotFoundException> databaseNotFound(String databaseNameRaw) {
        return () -> new DatabaseNotFoundException("Database " + databaseNameRaw + " not found");
    }

    private TransactionalContext.DatabaseMode dbMode(Location.Local location) {
        if (location.databaseReference() instanceof DatabaseReferenceImpl.SPD) {
            return TransactionalContext.DatabaseMode.SHARDED;
        }
        return TransactionalContext.DatabaseMode.SINGLE;
    }
}

