/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.router;

import org.neo4j.fabric.executor.Location;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.ErrorMessageHolder;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlRuntimeException;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.HasQuery;
import org.neo4j.kernel.api.exceptions.Status;

public class QueryRouterException
extends GqlRuntimeException
implements Status.HasStatus,
HasQuery {
    private final Status statusCode;
    private Long queryId;

    @Deprecated
    public QueryRouterException(Status statusCode, Throwable cause) {
        super(ErrorMessageHolder.getOldCauseMessage((Throwable)cause), cause);
        this.statusCode = statusCode;
        this.queryId = null;
    }

    private QueryRouterException(ErrorGqlStatusObject gqlStatusObject, Status statusCode, Throwable cause) {
        super(gqlStatusObject, ErrorMessageHolder.getOldCauseMessage((Throwable)cause), cause);
        this.statusCode = statusCode;
        this.queryId = null;
    }

    @Deprecated
    public QueryRouterException(Status statusCode, String message, Object ... parameters) {
        super(String.format(message, parameters));
        this.statusCode = statusCode;
        this.queryId = null;
    }

    private QueryRouterException(ErrorGqlStatusObject gqlStatusObject, Status statusCode, String message, Object ... parameters) {
        super(gqlStatusObject, String.format(message, parameters));
        this.statusCode = statusCode;
        this.queryId = null;
    }

    @Deprecated
    public QueryRouterException(Status statusCode, String message, Throwable cause) {
        super(message, cause);
        this.statusCode = statusCode;
        this.queryId = null;
    }

    public QueryRouterException(ErrorGqlStatusObject gqlStatusObject, Status statusCode, String message, Throwable cause) {
        super(gqlStatusObject, message, cause);
        this.statusCode = statusCode;
        this.queryId = null;
    }

    public static QueryRouterException executeQueryInClosedTransaction(String legacyMessage) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N07).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_25N05).build()).build();
        return new QueryRouterException(gql, (Status)Status.Statement.ExecutionFailed, legacyMessage, new Object[0]);
    }

    public static QueryRouterException writeDuringLeaderSwitch(Location attempt, Location current) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N34).build();
        return new QueryRouterException(gql, (Status)Status.Transaction.LeaderSwitch, "Could not write to a database due to a cluster leader switch that occurred during the transaction. Previous leader: %s, Current leader: %s.", current, attempt);
    }

    public static QueryRouterException invalidCombinationOfStatementTypes(String query, String message) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_25N01).withParam(GqlParams.StringParam.query, query).build();
        return new QueryRouterException(gql, (Status)Status.Transaction.ForbiddenDueToTransactionType, message, new Object[0]);
    }

    public Status status() {
        return this.statusCode;
    }

    public Long query() {
        return this.queryId;
    }

    public void setQuery(Long queryId) {
        this.queryId = queryId;
    }
}

