/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import org.neo4j.values.storable.BooleanArray;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.ByteArray;
import org.neo4j.values.storable.ByteValue;
import org.neo4j.values.storable.CharArray;
import org.neo4j.values.storable.CharValue;
import org.neo4j.values.storable.DateArray;
import org.neo4j.values.storable.DateTimeArray;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DoubleArray;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.DurationArray;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.ExtremeValuesLibrary;
import org.neo4j.values.storable.Float32Vector;
import org.neo4j.values.storable.Float64Vector;
import org.neo4j.values.storable.FloatArray;
import org.neo4j.values.storable.FloatValue;
import org.neo4j.values.storable.Int16Vector;
import org.neo4j.values.storable.Int32Vector;
import org.neo4j.values.storable.Int64Vector;
import org.neo4j.values.storable.Int8Vector;
import org.neo4j.values.storable.IntArray;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.LocalDateTimeArray;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeArray;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.LongArray;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.PointArray;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.ShortArray;
import org.neo4j.values.storable.ShortValue;
import org.neo4j.values.storable.StringArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeArray;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueRepresentation;

public enum ValueType {
    BOOLEAN(ValueRepresentation.BOOLEAN, BooleanValue.class, ExtremeValuesLibrary.EXTREME_BOOLEAN),
    BYTE(ValueRepresentation.INT8, ByteValue.class, ExtremeValuesLibrary.EXTREME_BYTE),
    SHORT(ValueRepresentation.INT16, ShortValue.class, ExtremeValuesLibrary.EXTREME_SHORT),
    INT(ValueRepresentation.INT32, IntValue.class, ExtremeValuesLibrary.EXTREME_INT),
    LONG(ValueRepresentation.INT64, LongValue.class, ExtremeValuesLibrary.EXTREME_LONG),
    FLOAT(ValueRepresentation.FLOAT32, FloatValue.class, ExtremeValuesLibrary.EXTREME_FLOAT),
    DOUBLE(ValueRepresentation.FLOAT64, DoubleValue.class, ExtremeValuesLibrary.EXTREME_DOUBLE),
    CHAR(ValueRepresentation.UTF8_TEXT, CharValue.class, ExtremeValuesLibrary.EXTREME_CHAR),
    STRING(ValueRepresentation.UTF8_TEXT, TextValue.class, ExtremeValuesLibrary.EXTREME_STRING),
    STRING_ALPHANUMERIC(ValueRepresentation.UTF8_TEXT, TextValue.class, ExtremeValuesLibrary.EXTREME_STRING_ALPHANUMERIC),
    STRING_ASCII(ValueRepresentation.UTF8_TEXT, TextValue.class, ExtremeValuesLibrary.EXTREME_STRING_ASCII),
    STRING_BMP(ValueRepresentation.UTF8_TEXT, TextValue.class, ExtremeValuesLibrary.EXTREME_STRING_BMP),
    LOCAL_DATE_TIME(ValueRepresentation.LOCAL_DATE_TIME, LocalDateTimeValue.class, ExtremeValuesLibrary.EXTREME_LOCAL_DATE_TIME),
    DATE(ValueRepresentation.DATE, DateValue.class, ExtremeValuesLibrary.EXTREME_DATE),
    LOCAL_TIME(ValueRepresentation.LOCAL_TIME, LocalTimeValue.class, ExtremeValuesLibrary.EXTREME_LOCAL_TIME),
    PERIOD(ValueRepresentation.DURATION, DurationValue.class, ExtremeValuesLibrary.EXTREME_PERIOD),
    DURATION(ValueRepresentation.DURATION, DurationValue.class, ExtremeValuesLibrary.EXTREME_DURATION),
    TIME(ValueRepresentation.ZONED_TIME, TimeValue.class, ExtremeValuesLibrary.EXTREME_TIME),
    DATE_TIME(ValueRepresentation.ZONED_DATE_TIME, DateTimeValue.class, ExtremeValuesLibrary.EXTREME_DATE_TIME),
    CARTESIAN_POINT(ValueRepresentation.GEOMETRY, PointValue.class, ExtremeValuesLibrary.EXTREME_CARTESIAN_POINT),
    CARTESIAN_POINT_3D(ValueRepresentation.GEOMETRY, PointValue.class, ExtremeValuesLibrary.EXTREME_CARTESIAN_POINT_3D),
    GEOGRAPHIC_POINT(ValueRepresentation.GEOMETRY, PointValue.class, ExtremeValuesLibrary.EXTREME_GEOGRAPHIC_POINT),
    GEOGRAPHIC_POINT_3D(ValueRepresentation.GEOMETRY, PointValue.class, ExtremeValuesLibrary.EXTREME_GEOGRAPHIC_POINT_3D),
    BOOLEAN_ARRAY(ValueRepresentation.BOOLEAN_ARRAY, BooleanArray.class, true, ExtremeValuesLibrary.EXTREME_BOOLEAN_ARRAY),
    BYTE_ARRAY(ValueRepresentation.INT8_ARRAY, ByteArray.class, true, ExtremeValuesLibrary.EXTREME_BYTE_ARRAY),
    SHORT_ARRAY(ValueRepresentation.INT16_ARRAY, ShortArray.class, true, ExtremeValuesLibrary.EXTREME_SHORT_ARRAY),
    INT_ARRAY(ValueRepresentation.INT32_ARRAY, IntArray.class, true, ExtremeValuesLibrary.EXTREME_INT_ARRAY),
    LONG_ARRAY(ValueRepresentation.INT64_ARRAY, LongArray.class, true, ExtremeValuesLibrary.EXTREME_LONG_ARRAY),
    FLOAT_ARRAY(ValueRepresentation.FLOAT32_ARRAY, FloatArray.class, true, ExtremeValuesLibrary.EXTREME_FLOAT_ARRAY),
    DOUBLE_ARRAY(ValueRepresentation.FLOAT64_ARRAY, DoubleArray.class, true, ExtremeValuesLibrary.EXTREME_DOUBLE_ARRAY),
    CHAR_ARRAY(ValueRepresentation.TEXT_ARRAY, CharArray.class, true, ExtremeValuesLibrary.EXTREME_CHAR_ARRAY),
    STRING_ARRAY(ValueRepresentation.TEXT_ARRAY, StringArray.class, true, ExtremeValuesLibrary.EXTREME_STRING_ARRAY),
    STRING_ALPHANUMERIC_ARRAY(ValueRepresentation.TEXT_ARRAY, StringArray.class, true, ExtremeValuesLibrary.EXTREME_STRING_ALPHANUMERIC_ARRAY),
    STRING_ASCII_ARRAY(ValueRepresentation.TEXT_ARRAY, StringArray.class, true, ExtremeValuesLibrary.EXTREME_STRING_ASCII_ARRAY),
    STRING_BMP_ARRAY(ValueRepresentation.TEXT_ARRAY, StringArray.class, true, ExtremeValuesLibrary.EXTREME_STRING_BMP_ARRAY),
    LOCAL_DATE_TIME_ARRAY(ValueRepresentation.LOCAL_DATE_TIME_ARRAY, LocalDateTimeArray.class, true, ExtremeValuesLibrary.EXTREME_LOCAL_DATE_TIME_ARRAY),
    DATE_ARRAY(ValueRepresentation.DATE_ARRAY, DateArray.class, true, ExtremeValuesLibrary.EXTREME_DATE_ARRAY),
    LOCAL_TIME_ARRAY(ValueRepresentation.LOCAL_TIME_ARRAY, LocalTimeArray.class, true, ExtremeValuesLibrary.EXTREME_LOCAL_TIME_ARRAY),
    PERIOD_ARRAY(ValueRepresentation.DURATION_ARRAY, DurationArray.class, true, ExtremeValuesLibrary.EXTREME_PERIOD_ARRAY),
    DURATION_ARRAY(ValueRepresentation.DURATION_ARRAY, DurationArray.class, true, ExtremeValuesLibrary.EXTREME_DURATION_ARRAY),
    TIME_ARRAY(ValueRepresentation.ZONED_TIME_ARRAY, TimeArray.class, true, ExtremeValuesLibrary.EXTREME_TIME_ARRAY),
    DATE_TIME_ARRAY(ValueRepresentation.ZONED_DATE_TIME_ARRAY, DateTimeArray.class, true, ExtremeValuesLibrary.EXTREME_DATE_TIME_ARRAY),
    CARTESIAN_POINT_ARRAY(ValueRepresentation.GEOMETRY_ARRAY, PointArray.class, true, ExtremeValuesLibrary.EXTREME_CARTESIAN_POINT_ARRAY),
    CARTESIAN_POINT_3D_ARRAY(ValueRepresentation.GEOMETRY_ARRAY, PointArray.class, true, ExtremeValuesLibrary.EXTREME_CARTESIAN_POINT_3D_ARRAY),
    GEOGRAPHIC_POINT_ARRAY(ValueRepresentation.GEOMETRY_ARRAY, PointArray.class, true, ExtremeValuesLibrary.EXTREME_GEOGRAPHIC_POINT_ARRAY),
    GEOGRAPHIC_POINT_3D_ARRAY(ValueRepresentation.GEOMETRY_ARRAY, PointArray.class, true, ExtremeValuesLibrary.EXTREME_GEOGRAPHIC_POINT_3D_ARRAY),
    INT8VECTOR(ValueRepresentation.INT8_VECTOR, Int8Vector.class, ExtremeValuesLibrary.EXTREME_INT8_VECTOR),
    INT16VECTOR(ValueRepresentation.INT16_VECTOR, Int16Vector.class, ExtremeValuesLibrary.EXTREME_INT16_VECTOR),
    INT32VECTOR(ValueRepresentation.INT32_VECTOR, Int32Vector.class, ExtremeValuesLibrary.EXTREME_INT32_VECTOR),
    INT64VECTOR(ValueRepresentation.INT64_VECTOR, Int64Vector.class, ExtremeValuesLibrary.EXTREME_INT64_VECTOR),
    FLOAT32VECTOR(ValueRepresentation.FLOAT32_VECTOR, Float32Vector.class, ExtremeValuesLibrary.EXTREME_FLOAT32_VECTOR),
    FLOAT64VECTOR(ValueRepresentation.FLOAT64_VECTOR, Float64Vector.class, ExtremeValuesLibrary.EXTREME_FLOAT64_VECTOR);

    public final ValueRepresentation valueRepresentation;
    public final ValueGroup valueGroup;
    public final Class<? extends Value> valueClass;
    public final boolean arrayType;
    private final Value[] extremeValues;
    public static final ValueType[] ALL_TYPES;

    private ValueType(ValueRepresentation valueRepresentation, Class<? extends Value> valueClass, Value ... extremeValues) {
        this(valueRepresentation, valueClass, false, extremeValues);
    }

    private ValueType(ValueRepresentation valueRepresentation, Class<? extends Value> valueClass, boolean arrayType, Value ... extremeValues) {
        this.valueRepresentation = valueRepresentation;
        this.valueGroup = valueRepresentation.valueGroup();
        this.valueClass = valueClass;
        this.arrayType = arrayType;
        this.extremeValues = extremeValues;
    }

    public Value[] extremeValues() {
        return this.extremeValues;
    }

    public static ValueType[] arrayTypes() {
        return (ValueType[])Arrays.stream(ALL_TYPES).filter(t -> t.arrayType).toArray(ValueType[]::new);
    }

    static {
        ALL_TYPES = ValueType.values();
    }
}

