/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import java.lang.annotation.ElementType;
import java.util.Optional;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.LifecycleMethodExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.platform.commons.support.AnnotationSupport;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.StatefulFieldExtension;
import org.neo4j.values.storable.RandomValues;
import org.opentest4j.AssertionFailedError;
import org.opentest4j.TestAbortedException;

public class RandomExtension
extends StatefulFieldExtension<RandomSupport>
implements BeforeEachCallback,
AfterEachCallback,
BeforeAllCallback,
TestExecutionExceptionHandler,
LifecycleMethodExecutionExceptionHandler {
    public static final String RANDOM = "random";
    public static final ExtensionContext.Namespace RANDOM_NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"random"});
    private final RandomValues.Configuration config;

    public RandomExtension() {
        this(new RandomValues.Default());
    }

    public RandomExtension(RandomValues.Default config) {
        this.config = config;
    }

    protected String getFieldKey() {
        return RANDOM;
    }

    protected Class<RandomSupport> getFieldType() {
        return RandomSupport.class;
    }

    protected ExtensionContext.Namespace getNameSpace() {
        return RANDOM_NAMESPACE;
    }

    protected RandomSupport createField(ExtensionContext extensionContext) {
        return new RandomSupport().withConfiguration(this.config);
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        RandomExtension.validateAnnotationType(extensionContext, TestInstance.Lifecycle.PER_CLASS);
        if (RandomExtension.getLifecycle(extensionContext) == TestInstance.Lifecycle.PER_CLASS) {
            this.setSeed(extensionContext);
        }
    }

    public void beforeEach(ExtensionContext extensionContext) {
        RandomExtension.validateAnnotationType(extensionContext, TestInstance.Lifecycle.PER_METHOD);
        if (RandomExtension.getLifecycle(extensionContext) == TestInstance.Lifecycle.PER_METHOD) {
            this.setSeed(extensionContext);
        }
    }

    public void afterEach(ExtensionContext context) {
        this.removeStoredValue(context);
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable t) {
        this.handleException(context, t);
    }

    public void handleBeforeEachMethodExecutionException(ExtensionContext context, Throwable t) {
        this.handleException(context, t);
    }

    public void handleAfterEachMethodExecutionException(ExtensionContext context, Throwable t) {
        this.handleException(context, t);
    }

    public void handleAfterAllMethodExecutionException(ExtensionContext context, Throwable t) {
        this.handleException(context, t);
    }

    private void handleException(ExtensionContext context, Throwable t) {
        if (t instanceof TestAbortedException) {
            return;
        }
        RandomSupport random = (RandomSupport)this.getStoredValue(context);
        RandomExtension.decorateAndThrow(random, t);
    }

    public static void decorateAndThrow(RandomSupport random, Throwable cause) {
        throw new AssertionFailedError(String.format("%s [ random seed used: %dL ]", cause.getMessage(), random.seed()), cause);
    }

    private void setSeed(ExtensionContext extensionContext) {
        Optional<RandomSupport.Seed> optionalSeed = RandomExtension.getAnnotatedSeed(extensionContext);
        Long seed = optionalSeed.map(RandomSupport.Seed::value).orElse(System.currentTimeMillis());
        ((RandomSupport)this.getStoredValue(extensionContext)).setSeed(seed);
    }

    private static void validateAnnotationType(ExtensionContext extensionContext, TestInstance.Lifecycle lifecycle) {
        ElementType expectedType;
        ElementType elementType = expectedType = lifecycle == TestInstance.Lifecycle.PER_CLASS ? ElementType.TYPE : ElementType.METHOD;
        if (RandomExtension.getAnnotatedSeed(extensionContext).isPresent() && RandomExtension.getLifecycle(extensionContext) != lifecycle) {
            throw new UnsupportedOperationException("Annotation @Seed is only allowed on " + expectedType + " when using " + lifecycle);
        }
    }

    private static Optional<RandomSupport.Seed> getAnnotatedSeed(ExtensionContext extensionContext) {
        return AnnotationSupport.findAnnotation((Optional)extensionContext.getElement(), RandomSupport.Seed.class);
    }

    private static TestInstance.Lifecycle getLifecycle(ExtensionContext context) {
        return context.getTestInstanceLifecycle().orElse(TestInstance.Lifecycle.PER_METHOD);
    }
}

