/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.util.Arrays;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;

class UTF8StringValueBuilder {
    private static final int DEFAULT_SIZE = 8;
    private byte[] bytes;
    private int length;

    UTF8StringValueBuilder() {
        this(8);
    }

    UTF8StringValueBuilder(int initialCapacity) {
        this.bytes = new byte[initialCapacity];
    }

    void add(byte b) {
        if (this.bytes.length == this.length) {
            this.ensureCapacity();
        }
        this.bytes[this.length++] = b;
    }

    private void ensureCapacity() {
        int newCapacity = this.bytes.length << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Fail to increase capacity.");
        }
        this.bytes = Arrays.copyOf(this.bytes, newCapacity);
    }

    TextValue build() {
        return Values.utf8Value((byte[])this.bytes, (int)0, (int)this.length);
    }

    void addCodePoint(int codePoint) {
        assert (codePoint >= 0);
        if (codePoint < 128) {
            this.add((byte)codePoint);
        } else if (codePoint < 2048) {
            this.add((byte)(0xC0 | 0x1F & codePoint >> 6));
            this.add((byte)(0x80 | 0x3F & codePoint));
        } else if (codePoint < 65536) {
            this.add((byte)(0xE0 | 0xF & codePoint >> 12));
            this.add((byte)(0x80 | 0x3F & codePoint >> 6));
            this.add((byte)(0x80 | 0x3F & codePoint));
        } else {
            this.add((byte)(0xF0 | 0x1F & codePoint >> 18));
            this.add((byte)(0x80 | 0x3F & codePoint >> 12));
            this.add((byte)(0x80 | 0x3F & codePoint >> 6));
            this.add((byte)(0x80 | 0x3F & codePoint));
        }
    }
}

