/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.util.StringJoiner;
import java.util.function.IntFunction;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.EndpointType;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.string.Mask;
import org.neo4j.token.api.TokenIdPrettyPrinter;

public final class SchemaUserDescription {
    public static final String TOKEN_LABEL = "<any-labels>";
    public static final String TOKEN_REL_TYPE = "<any-types>";
    public static final TokenNameLookup TOKEN_ID_NAME_LOOKUP = new TokenNameLookup(){

        public String labelGetName(int labelId) {
            return "Label[" + labelId + "]";
        }

        public String relationshipTypeGetName(int relationshipTypeId) {
            return "RelationshipType[" + relationshipTypeId + "]";
        }

        public String propertyKeyGetName(int propertyKeyId) {
            return "PropertyKey[" + propertyKeyId + "]";
        }
    };

    private SchemaUserDescription() {
    }

    static String forSchema(TokenNameLookup tokenNameLookup, EntityType entityType, int[] entityTokens, int[] propertyKeyIds) {
        String suffix;
        String prefix = entityType == EntityType.RELATIONSHIP ? "()-[" : "(";
        String string = suffix = entityType == EntityType.RELATIONSHIP ? "]-()" : ")";
        if (entityTokens.length == 0 && propertyKeyIds.length == 0) {
            String entityTokenType = ":" + (entityType == EntityType.RELATIONSHIP ? TOKEN_REL_TYPE : TOKEN_LABEL);
            return prefix + entityTokenType + suffix;
        }
        IntFunction<String> lookup = entityType == EntityType.NODE ? arg_0 -> ((TokenNameLookup)tokenNameLookup).labelGetName(arg_0) : arg_0 -> ((TokenNameLookup)tokenNameLookup).relationshipTypeGetName(arg_0);
        return prefix + TokenIdPrettyPrinter.niceEntityLabels(lookup, (int[])entityTokens) + " " + TokenIdPrettyPrinter.niceProperties((TokenNameLookup)tokenNameLookup, (int[])propertyKeyIds, (char)'{', (char)'}') + suffix;
    }

    static String forPrototype(TokenNameLookup tokenNameLookup, String name, String indexType, SchemaDescriptor schema, IndexProviderDescriptor indexProvider) {
        StringJoiner joiner = new StringJoiner(", ", "Index( ", " )");
        SchemaUserDescription.addPrototypeParams(tokenNameLookup, name, indexType, schema, indexProvider, joiner, Mask.NO);
        return joiner.toString();
    }

    public static String forIndex(TokenNameLookup tokenNameLookup, long id, String name, String indexType, SchemaDescriptor schema, IndexProviderDescriptor indexProvider, Long owningConstraintId) {
        return SchemaUserDescription.forIndex(tokenNameLookup, id, name, indexType, schema, indexProvider, owningConstraintId, Mask.NO);
    }

    public static String forIndex(TokenNameLookup tokenNameLookup, long id, String name, String indexType, SchemaDescriptor schema, IndexProviderDescriptor indexProvider, Long owningConstraintId, Mask mask) {
        StringJoiner joiner = new StringJoiner(", ", "Index( ", " )");
        joiner.add("id=" + id);
        SchemaUserDescription.addPrototypeParams(tokenNameLookup, name, indexType, schema, indexProvider, joiner, mask);
        if (owningConstraintId != null) {
            joiner.add("owningConstraint=" + owningConstraintId);
        }
        return joiner.toString();
    }

    public static String forConstraint(TokenNameLookup tokenNameLookup, long id, String name, ConstraintType type, SchemaDescriptor schema, Long ownedIndex, PropertyTypeSet propertyType, String enforcedLabel, EndpointType endpointType, Mask mask) {
        StringJoiner joiner = new StringJoiner(", ", "Constraint( ", " )");
        SchemaUserDescription.maybeAddId(id, joiner);
        SchemaUserDescription.maybeAddName(name, joiner, mask);
        SchemaUserDescription.addType(type.userDescription(schema.entityType(), endpointType), joiner);
        SchemaUserDescription.addSchema(tokenNameLookup, schema, joiner);
        if (ownedIndex != null) {
            joiner.add("ownedIndex=" + ownedIndex);
        }
        SchemaUserDescription.maybeAddAllowedPropertyTypes(propertyType, joiner);
        SchemaUserDescription.maybeAddEnforcedLabel(enforcedLabel, joiner);
        return joiner.toString();
    }

    private static void maybeAddId(long id, StringJoiner joiner) {
        if (id != -1L) {
            joiner.add("id=" + id);
        }
    }

    private static void maybeAddName(String name, StringJoiner joiner, Mask mask) {
        if (name != null) {
            joiner.add("name='" + mask.filter((Object)name) + "'");
        }
    }

    private static void maybeAddAllowedPropertyTypes(PropertyTypeSet propertyType, StringJoiner joiner) {
        if (propertyType != null) {
            joiner.add("propertyType=" + propertyType.userDescription());
        }
    }

    private static void maybeAddEnforcedLabel(String label, StringJoiner joiner) {
        if (label != null) {
            joiner.add("enforcedLabel=" + label);
        }
    }

    private static void addPrototypeParams(TokenNameLookup tokenNameLookup, String name, String indexType, SchemaDescriptor schema, IndexProviderDescriptor indexProvider, StringJoiner joiner, Mask mask) {
        SchemaUserDescription.maybeAddName(name, joiner, mask);
        SchemaUserDescription.addType(indexType, joiner);
        SchemaUserDescription.addSchema(tokenNameLookup, schema, joiner);
        joiner.add("indexProvider='" + indexProvider.name() + "'");
    }

    private static void addType(String type, StringJoiner joiner) {
        joiner.add("type='" + type + "'");
    }

    private static void addSchema(TokenNameLookup tokenNameLookup, SchemaDescriptor schema, StringJoiner joiner) {
        joiner.add("schema=" + schema.userDescription(tokenNameLookup));
    }
}

