/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema.constraints;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Stream;
import org.neo4j.internal.schema.constraints.ConstrainableType;
import org.neo4j.internal.schema.constraints.SpecialTypes;
import org.neo4j.internal.schema.constraints.TypeRepresentation;

public class PropertyTypeSet
implements Iterable<ConstrainableType> {
    private final Set<? extends ConstrainableType> lookup;
    private final List<? extends ConstrainableType> types;
    private final boolean acceptsEmptyList;

    private PropertyTypeSet(Set<? extends ConstrainableType> lookup, List<? extends ConstrainableType> types, boolean acceptsEmptyList) {
        this.lookup = lookup;
        this.types = types;
        this.acceptsEmptyList = acceptsEmptyList;
    }

    public static PropertyTypeSet empty() {
        return new PropertyTypeSet(Set.of(), List.of(), false);
    }

    public static PropertyTypeSet of(Collection<? extends ConstrainableType> types) {
        if (types.isEmpty()) {
            return PropertyTypeSet.empty();
        }
        Set<? extends ConstrainableType> lookup = Set.copyOf(types);
        List uniqueTypes = lookup.stream().sorted(TypeRepresentation::compare).toList();
        boolean acceptsEmptyList = types.stream().anyMatch(TypeRepresentation::isList);
        return new PropertyTypeSet(lookup, uniqueTypes, acceptsEmptyList);
    }

    public static PropertyTypeSet of(ConstrainableType ... types) {
        return PropertyTypeSet.of(Arrays.asList(types));
    }

    public String userDescription() {
        if (this.types.isEmpty()) {
            return "NOTHING";
        }
        StringJoiner joiner = new StringJoiner(" | ");
        for (ConstrainableType constrainableType : this.types) {
            joiner.add(constrainableType.userDescription());
        }
        return joiner.toString();
    }

    public int hashCode() {
        return this.types.stream().mapToInt(type -> type.serialize().hashCode()).sum();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyTypeSet that = (PropertyTypeSet)o;
        return this.types.equals(that.types);
    }

    public int size() {
        return this.types.size();
    }

    public boolean contains(TypeRepresentation repr) {
        if (repr instanceof ConstrainableType) {
            ConstrainableType type = (ConstrainableType)repr;
            return this.lookup.contains(type);
        }
        if (repr == SpecialTypes.NULL) {
            return true;
        }
        return this.acceptsEmptyList && repr == SpecialTypes.LIST_NOTHING;
    }

    public PropertyTypeSet union(PropertyTypeSet other) {
        return PropertyTypeSet.of(Stream.concat(this.stream(), other.stream()).toList());
    }

    public PropertyTypeSet intersection(PropertyTypeSet other) {
        return PropertyTypeSet.of(this.stream().filter(other.lookup::contains).toList());
    }

    public PropertyTypeSet difference(PropertyTypeSet other) {
        return PropertyTypeSet.of(this.stream().filter(v -> !other.lookup.contains(v)).toList());
    }

    public Stream<? extends ConstrainableType> stream() {
        return this.types.stream();
    }

    @Override
    public Iterator<ConstrainableType> iterator() {
        return this.types.iterator();
    }

    public ConstrainableType[] values() {
        return (ConstrainableType[])this.types.toArray(ConstrainableType[]::new);
    }
}

