/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

public enum IndexType {
    FULLTEXT(1),
    LOOKUP(2),
    TEXT(3),
    RANGE(4),
    POINT(5),
    VECTOR(6);

    private final int typeNumber;

    private IndexType(int typeNumber) {
        this.typeNumber = typeNumber;
    }

    public static IndexType fromPublicApi(org.neo4j.graphdb.schema.IndexType type) {
        if (type == null) {
            return null;
        }
        return switch (type) {
            default -> throw new MatchException(null, null);
            case org.neo4j.graphdb.schema.IndexType.FULLTEXT -> FULLTEXT;
            case org.neo4j.graphdb.schema.IndexType.LOOKUP -> LOOKUP;
            case org.neo4j.graphdb.schema.IndexType.TEXT -> TEXT;
            case org.neo4j.graphdb.schema.IndexType.RANGE -> RANGE;
            case org.neo4j.graphdb.schema.IndexType.POINT -> POINT;
            case org.neo4j.graphdb.schema.IndexType.VECTOR -> VECTOR;
        };
    }

    public org.neo4j.graphdb.schema.IndexType toPublicApi() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> org.neo4j.graphdb.schema.IndexType.FULLTEXT;
            case 1 -> org.neo4j.graphdb.schema.IndexType.LOOKUP;
            case 2 -> org.neo4j.graphdb.schema.IndexType.TEXT;
            case 3 -> org.neo4j.graphdb.schema.IndexType.RANGE;
            case 4 -> org.neo4j.graphdb.schema.IndexType.POINT;
            case 5 -> org.neo4j.graphdb.schema.IndexType.VECTOR;
        };
    }

    public boolean isLookup() {
        return this == LOOKUP;
    }

    public int getTypeNumber() {
        return this.typeNumber;
    }
}

