/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.exceptions.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.exceptions.KernelException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.EndpointType;
import org.neo4j.kernel.api.exceptions.Status;

public class CreateConstraintFailureException
extends SchemaKernelException {
    private final ConstraintDescriptor constraint;
    private final String cause;

    private CreateConstraintFailureException(ErrorGqlStatusObject gqlStatusObject, ConstraintDescriptor constraint, Throwable cause, String causeString) {
        super(gqlStatusObject, (Status)Status.Schema.ConstraintCreationFailed, cause, "Unable to create constraint %s: %s", constraint, causeString);
        this.constraint = constraint;
        this.cause = causeString;
    }

    public static CreateConstraintFailureException constraintCreationFailed(ConstraintDescriptor constraint, TokenNameLookup tokenNameLookup, Throwable cause) {
        return CreateConstraintFailureException.constraintCreationFailed(constraint, tokenNameLookup, cause, cause.getMessage(), null);
    }

    public static CreateConstraintFailureException constraintCreationFailed(ConstraintDescriptor constraint, TokenNameLookup tokenNameLookup, String causeMessage) {
        return CreateConstraintFailureException.constraintCreationFailed(constraint, tokenNameLookup, null, causeMessage, null);
    }

    public static CreateConstraintFailureException constraintCreationFailedOnCommunity(ConstraintDescriptor constraint, TokenNameLookup tokenNameLookup, String causeMessage) {
        ErrorGqlStatusObject gqlStatusCause = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N27).withParam(GqlParams.StringParam.feat, String.format("%s constraint", switch (constraint.type()) {
            case ConstraintType.EXISTS -> "Property existence";
            case ConstraintType.PROPERTY_TYPE -> "Property type";
            case ConstraintType.NODE_LABEL_EXISTENCE -> "Node Label existence";
            case ConstraintType.RELATIONSHIP_ENDPOINT_LABEL -> {
                EndpointType type = constraint.asRelationshipEndpointLabelConstraint().endpointType();
                switch (type) {
                    case START: {
                        yield "Relationship source label";
                    }
                    case END: {
                        yield "Relationship target label";
                    }
                }
                throw InvalidArgumentException.internalError((String)CreateConstraintFailureException.class.getSimpleName(), (String)String.format("Unexpected endpoint type: %s", new Object[]{type}));
            }
            case ConstraintType.UNIQUE_EXISTS -> "Key";
            default -> throw InvalidArgumentException.internalError((String)CreateConstraintFailureException.class.getSimpleName(), (String)String.format("Unexpected constraint type: %s", new Object[]{constraint.type()}));
        })).withParam(GqlParams.StringParam.edition, "community edition").build();
        return CreateConstraintFailureException.constraintCreationFailed(constraint, tokenNameLookup, null, causeMessage, gqlStatusCause);
    }

    private static CreateConstraintFailureException constraintCreationFailed(ConstraintDescriptor constraint, TokenNameLookup tokenNameLookup, Throwable cause, String causeString, ErrorGqlStatusObject gqlStatusCause) {
        String constraintString = constraint.userDescription(tokenNameLookup);
        ErrorGqlStatusObjectImplementation.Builder gqlStatusBuilder = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_50N11).withParam(GqlParams.StringParam.constrDescrOrName, constraint.getName() != null ? constraint.getName() : constraintString);
        if (gqlStatusCause != null) {
            gqlStatusBuilder.withCause(gqlStatusCause);
        }
        return new CreateConstraintFailureException(gqlStatusBuilder.build(), constraint, cause, causeString);
    }

    public ConstraintDescriptor constraint() {
        return this.constraint;
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        StringBuilder sb = new StringBuilder("Unable to create ").append(this.constraint.userDescription(tokenNameLookup));
        Throwable throwable = this.getCause();
        if (throwable instanceof KernelException) {
            KernelException kernelCause = (KernelException)throwable;
            sb.append(':').append(System.lineSeparator()).append(kernelCause.getUserMessage(tokenNameLookup));
        } else if (this.cause != null) {
            sb.append(':').append(System.lineSeparator()).append(this.cause);
        }
        return sb.append(". Note that only the first found violation is shown.").toString();
    }
}

