/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.util.Comparator;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.factory.SortedSets;
import org.eclipse.collections.api.multimap.sortedset.MutableSortedSetMultimap;
import org.eclipse.collections.api.set.sorted.ImmutableSortedSet;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.factory.Multimaps;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Value;

public class IndexConfigValidationRecords {
    private final MutableSortedSetMultimap<State, IndexConfigValidationRecord> records;

    public IndexConfigValidationRecords() {
        this.records = Multimaps.mutable.sortedSet.with(IndexConfigValidationRecord.COMPARATOR);
    }

    public IndexConfigValidationRecords with(IndexConfigValidationRecord record) {
        this.records.put((Object)record.state(), (Object)record);
        return this;
    }

    public ImmutableSortedSet<IndexConfigValidationRecord> get(State state) {
        return this.records.get((Object)state).toImmutableSortedSet();
    }

    public boolean invalid() {
        return this.records.keysView().asLazy().select((Predicate)Predicates.notEqual((Object)((Object)State.VALID))).notEmpty();
    }

    public boolean valid() {
        return !this.invalid();
    }

    public ImmutableSortedSet<Valid> validRecords() {
        return this.records.get((Object)State.VALID).asLazy().collect(Valid.class::cast).toImmutableSortedSet();
    }

    public static sealed interface IndexConfigValidationRecord
    extends NamedSetting,
    Comparable<IndexConfigValidationRecord>
    permits Valid, Invalid {
        public static final Comparator<IndexConfigValidationRecord> COMPARATOR = Comparator.comparing(IndexConfigValidationRecord::state).thenComparing(NamedSetting::settingName, String.CASE_INSENSITIVE_ORDER);

        public State state();

        @Override
        default public int compareTo(IndexConfigValidationRecord other) {
            return COMPARATOR.compare(this, other);
        }
    }

    public static enum State {
        VALID,
        PENDING,
        UNRECOGNIZED_SETTING,
        MISSING_SETTING,
        INCORRECT_TYPE,
        INVALID_VALUE;

        public static final ImmutableSortedSet<State> INVALID_STATES;

        static {
            INVALID_STATES = SortedSets.mutable.of((Object[])State.values()).without((Object)VALID).toImmutableSortedSet();
        }
    }

    public record Valid(IndexSetting setting, Object value, Value stored) implements KnownSetting,
    IndexConfigValidationRecord
    {
        public Valid(Pending pending, Value stored) {
            this(pending.setting, pending.value, stored);
        }

        @Override
        public State state() {
            return State.VALID;
        }

        public <T> T get() {
            return (T)this.value;
        }
    }

    public record InvalidValue(IndexSetting setting, AnyValue rawValue, Object value, Object valid) implements KnownSetting,
    Invalid
    {
        public InvalidValue(Pending pending, Object value, Object valid) {
            this(pending.setting, pending.rawValue, value, valid);
        }

        public InvalidValue(Pending pending, Object valid) {
            this(pending, pending.value, valid);
        }

        @Override
        public State state() {
            return State.INVALID_VALUE;
        }
    }

    public record IncorrectType(IndexSetting setting, AnyValue rawValue, Class<?> targetType) implements KnownSetting,
    Invalid
    {
        public IncorrectType(Pending pending, Class<?> targetType) {
            this(pending.setting, pending.rawValue, targetType);
        }

        @Override
        public State state() {
            return State.INCORRECT_TYPE;
        }

        public Class<?> providedType() {
            return this.rawValue.getClass();
        }

        public String providedTypeString() {
            return this.rawValue.prettify();
        }
    }

    public record MissingSetting(IndexSetting setting) implements KnownSetting,
    Invalid
    {
        @Override
        public State state() {
            return State.MISSING_SETTING;
        }
    }

    public record UnrecognizedSetting(String settingName) implements Invalid
    {
        @Override
        public State state() {
            return State.UNRECOGNIZED_SETTING;
        }
    }

    public record Pending(IndexSetting setting, AnyValue rawValue, Object value) implements KnownSetting,
    Invalid
    {
        public Pending(IndexSetting setting, AnyValue rawValue) {
            this(setting, rawValue, null);
        }

        public Pending(Pending pending, Object value) {
            this(pending.setting, pending.rawValue, value);
        }

        @Override
        public State state() {
            return State.PENDING;
        }

        public <T> T get() {
            return (T)this.value;
        }
    }

    public static sealed interface Invalid
    extends IndexConfigValidationRecord
    permits Pending, UnrecognizedSetting, MissingSetting, IncorrectType, InvalidValue {
    }

    public static interface KnownSetting
    extends NamedSetting {
        public IndexSetting setting();

        @Override
        default public String settingName() {
            return this.setting().getSettingName();
        }
    }

    @FunctionalInterface
    public static interface NamedSetting {
        public String settingName();
    }
}

