/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.AnyTokenSchemaDescriptor;
import org.neo4j.internal.schema.FulltextSchemaDescriptor;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.PropertySchemaType;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaProcessor;
import org.neo4j.internal.schema.SchemaUserDescription;
import org.neo4j.lock.ResourceType;
import org.neo4j.lock.ResourceTypes;

public final class SchemaDescriptorImplementation
implements SchemaDescriptor,
LabelSchemaDescriptor,
RelationTypeSchemaDescriptor,
FulltextSchemaDescriptor,
AnyTokenSchemaDescriptor {
    public static final long TOKEN_INDEX_LOCKING_ID = Long.MAX_VALUE;
    private static final long[] TOKEN_INDEX_LOCKING_IDS = new long[]{Long.MAX_VALUE};
    private final EntityType entityType;
    private final PropertySchemaType propertySchemaType;
    private final int[] entityTokens;
    private final int[] propertyKeyIds;
    private final boolean archetypalLabelSchema;
    private final boolean archetypalRelationshipTypeSchema;
    private final boolean archetypalFulltextSchema;
    private final boolean archetypalAnyTokenSchema;

    public SchemaDescriptorImplementation(EntityType entityType, PropertySchemaType propertySchemaType, int[] entityTokens, int[] propertyKeyIds) {
        this.entityType = Objects.requireNonNull(entityType, "EntityType cannot be null.");
        this.propertySchemaType = Objects.requireNonNull(propertySchemaType, "PropertySchemaType cannot be null.");
        this.entityTokens = Objects.requireNonNull(entityTokens, "Entity tokens array cannot be null.");
        this.propertyKeyIds = Objects.requireNonNull(propertyKeyIds, "Property key ids array cannot be null.");
        if (propertySchemaType != PropertySchemaType.ENTITY_TOKENS) {
            SchemaDescriptorImplementation.validatePropertySchema(entityType, entityTokens, propertyKeyIds);
        } else {
            SchemaDescriptorImplementation.validateEntityTokenSchema(entityType, entityTokens, propertyKeyIds);
        }
        boolean generalSingleEntity = entityTokens.length == 1 && propertySchemaType == PropertySchemaType.COMPLETE_ALL_TOKENS;
        this.archetypalLabelSchema = entityType == EntityType.NODE && generalSingleEntity;
        this.archetypalRelationshipTypeSchema = entityType == EntityType.RELATIONSHIP && generalSingleEntity;
        this.archetypalFulltextSchema = propertySchemaType == PropertySchemaType.PARTIAL_ANY_TOKEN;
        this.archetypalAnyTokenSchema = propertySchemaType == PropertySchemaType.ENTITY_TOKENS;
    }

    private static void validatePropertySchema(EntityType entityType, int[] entityTokens, int[] propertyKeyIds) {
        if (entityTokens.length == 0) {
            throw new IllegalArgumentException("Schema descriptor must have at least one " + (entityType == EntityType.NODE ? "label." : "relationship type."));
        }
        if (propertyKeyIds.length == 0) {
            throw new IllegalArgumentException("Schema descriptor must have at least one property key id.");
        }
        switch (entityType) {
            case NODE: {
                SchemaDescriptorImplementation.validateLabelIds(entityTokens);
                break;
            }
            case RELATIONSHIP: {
                SchemaDescriptorImplementation.validateRelationshipTypeIds(entityTokens);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown entity type: " + entityType + ".");
            }
        }
        SchemaDescriptorImplementation.validatePropertyIds(propertyKeyIds);
    }

    private static void validateEntityTokenSchema(EntityType entityType, int[] entityTokens, int[] propertyKeyIds) {
        if (entityTokens.length != 0) {
            throw new IllegalArgumentException("Schema descriptor with propertySchemaType " + PropertySchemaType.ENTITY_TOKENS + " should not have any specified " + (entityType == EntityType.NODE ? "labels." : "relationship types."));
        }
        if (propertyKeyIds.length != 0) {
            throw new IllegalArgumentException("Schema descriptor with propertySchemaType " + PropertySchemaType.ENTITY_TOKENS + " should not have any specified property key ids.");
        }
    }

    private static void validatePropertyIds(int ... propertyIds) {
        for (int propertyId : propertyIds) {
            if (-1 != propertyId) continue;
            throw new IllegalArgumentException("Index schema descriptor can't be created for non existent property.");
        }
    }

    private static void validateRelationshipTypeIds(int ... relTypes) {
        for (int relType : relTypes) {
            if (-1 != relType) continue;
            throw new IllegalArgumentException("Index schema descriptor can't be created for non existent relationship type.");
        }
    }

    private static void validateLabelIds(int ... labelIds) {
        for (int labelId : labelIds) {
            if (-1 != labelId) continue;
            throw new IllegalArgumentException("Index schema descriptor can't be created for non existent label.");
        }
    }

    @Override
    public boolean isLabelSchemaDescriptor() {
        return this.archetypalLabelSchema;
    }

    @Override
    public LabelSchemaDescriptor asLabelSchemaDescriptor() {
        if (!this.archetypalLabelSchema) {
            throw this.cannotCastException("LabelSchemaDescriptor");
        }
        return this;
    }

    @Override
    public boolean isRelationshipTypeSchemaDescriptor() {
        return this.archetypalRelationshipTypeSchema;
    }

    @Override
    public RelationTypeSchemaDescriptor asRelationshipTypeSchemaDescriptor() {
        if (!this.archetypalRelationshipTypeSchema) {
            throw this.cannotCastException("RelationTypeSchemaDescriptor");
        }
        return this;
    }

    @Override
    public boolean isFulltextSchemaDescriptor() {
        return this.archetypalFulltextSchema;
    }

    @Override
    public FulltextSchemaDescriptor asFulltextSchemaDescriptor() {
        if (!this.archetypalFulltextSchema) {
            throw this.cannotCastException("FulltextSchemaDescriptor");
        }
        return this;
    }

    @Override
    public boolean isAnyTokenSchemaDescriptor() {
        return this.archetypalAnyTokenSchema;
    }

    @Override
    public AnyTokenSchemaDescriptor asAnyTokenSchemaDescriptor() {
        if (!this.archetypalAnyTokenSchema) {
            throw this.cannotCastException("AnyTokenSchemaDescriptor");
        }
        return this;
    }

    private IllegalStateException cannotCastException(String descriptorType) {
        return new IllegalStateException("Cannot cast this schema to a " + descriptorType + " because it does not match that structure: " + this + ".");
    }

    @Override
    public boolean isAffected(long[] entityTokenIds) {
        for (int id : this.entityTokens) {
            if (!ArrayUtils.contains((long[])entityTokenIds, (long)id)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void processWith(SchemaProcessor processor) {
        if (this.archetypalLabelSchema) {
            processor.processSpecific(this.asLabelSchemaDescriptor());
        } else if (this.archetypalRelationshipTypeSchema) {
            processor.processSpecific(this.asRelationshipTypeSchemaDescriptor());
        } else {
            processor.processSpecific((SchemaDescriptor)this);
        }
    }

    @Override
    public String userDescription(TokenNameLookup tokenNameLookup) {
        return SchemaUserDescription.forSchema(tokenNameLookup, this.entityType, this.entityTokens, this.propertyKeyIds);
    }

    @Override
    public int[] getPropertyIds() {
        return this.propertyKeyIds;
    }

    @Override
    public int[] getEntityTokenIds() {
        return this.entityTokens;
    }

    @Override
    public ResourceType keyType() {
        return this.entityType == EntityType.NODE ? ResourceTypes.LABEL : ResourceTypes.RELATIONSHIP_TYPE;
    }

    @Override
    public EntityType entityType() {
        return this.entityType;
    }

    @Override
    public PropertySchemaType propertySchemaType() {
        return this.propertySchemaType;
    }

    @Override
    public long[] lockingKeys() {
        if (this.archetypalAnyTokenSchema) {
            return TOKEN_INDEX_LOCKING_IDS;
        }
        int[] tokenIds = this.getEntityTokenIds();
        int length = tokenIds.length;
        long[] lockingIds = new long[length];
        for (int i = 0; i < length; ++i) {
            lockingIds[i] = tokenIds[i];
        }
        return lockingIds;
    }

    @Override
    public SchemaDescriptor schema() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SchemaDescriptor)) {
            return false;
        }
        SchemaDescriptor that = (SchemaDescriptor)o;
        return this.entityType == that.entityType() && this.propertySchemaType == that.propertySchemaType() && Arrays.equals(this.entityTokens, that.getEntityTokenIds()) && Arrays.equals(this.propertyKeyIds, that.getPropertyIds());
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.entityType, this.propertySchemaType});
        result = 31 * result + Arrays.hashCode(this.entityTokens);
        result = 31 * result + Arrays.hashCode(this.propertyKeyIds);
        return result;
    }

    public String toString() {
        return this.userDescription(SchemaUserDescription.TOKEN_ID_NAME_LOOKUP);
    }
}

