/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema.constraints;

import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorImplementation;
import org.neo4j.internal.schema.constraints.NodeExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.NodeKeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.RelExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;

public class ConstraintDescriptorFactory {
    private ConstraintDescriptorFactory() {
    }

    public static NodeExistenceConstraintDescriptor existsForLabel(int labelId, int ... propertyIds) {
        return new ConstraintDescriptorImplementation(ConstraintType.EXISTS, SchemaDescriptors.forLabel(labelId, propertyIds));
    }

    public static RelExistenceConstraintDescriptor existsForRelType(int relTypeId, int ... propertyIds) {
        return new ConstraintDescriptorImplementation(ConstraintType.EXISTS, SchemaDescriptors.forRelType(relTypeId, propertyIds));
    }

    public static UniquenessConstraintDescriptor uniqueForLabel(int labelId, int ... propertyIds) {
        return ConstraintDescriptorFactory.uniqueForSchema(SchemaDescriptors.forLabel(labelId, propertyIds));
    }

    public static UniquenessConstraintDescriptor uniqueForLabel(IndexType indexType, int labelId, int ... propertyIds) {
        return ConstraintDescriptorFactory.uniqueForSchema(SchemaDescriptors.forLabel(labelId, propertyIds), indexType);
    }

    public static NodeKeyConstraintDescriptor nodeKeyForLabel(int labelId, int ... propertyIds) {
        return ConstraintDescriptorFactory.nodeKeyForSchema(SchemaDescriptors.forLabel(labelId, propertyIds));
    }

    public static NodeKeyConstraintDescriptor nodeKeyForLabel(IndexType indexType, int labelId, int ... propertyIds) {
        return ConstraintDescriptorFactory.nodeKeyForSchema(SchemaDescriptors.forLabel(labelId, propertyIds), indexType);
    }

    public static ConstraintDescriptor existsForSchema(SchemaDescriptor schema) {
        ConstraintDescriptorImplementation constraint = new ConstraintDescriptorImplementation(ConstraintType.EXISTS, schema);
        if (schema.isLabelSchemaDescriptor()) {
            return constraint.asNodePropertyExistenceConstraint();
        }
        if (schema.isRelationshipTypeSchemaDescriptor()) {
            return constraint.asRelationshipPropertyExistenceConstraint();
        }
        throw new UnsupportedOperationException("Cannot create existence constraint for the given schema.");
    }

    public static NodeExistenceConstraintDescriptor existsForSchema(LabelSchemaDescriptor schema) {
        return new ConstraintDescriptorImplementation(ConstraintType.EXISTS, schema);
    }

    public static RelExistenceConstraintDescriptor existsForSchema(RelationTypeSchemaDescriptor schema) {
        return new ConstraintDescriptorImplementation(ConstraintType.EXISTS, schema);
    }

    public static UniquenessConstraintDescriptor uniqueForSchema(SchemaDescriptor schema) {
        return new ConstraintDescriptorImplementation(ConstraintType.UNIQUE, schema, IndexType.RANGE);
    }

    public static UniquenessConstraintDescriptor uniqueForSchema(SchemaDescriptor schema, IndexType indexType) {
        return new ConstraintDescriptorImplementation(ConstraintType.UNIQUE, schema, indexType);
    }

    public static NodeKeyConstraintDescriptor nodeKeyForSchema(SchemaDescriptor schema) {
        return new ConstraintDescriptorImplementation(ConstraintType.UNIQUE_EXISTS, schema, IndexType.RANGE).asNodeKeyConstraint();
    }

    public static NodeKeyConstraintDescriptor nodeKeyForSchema(SchemaDescriptor schema, IndexType indexType) {
        return new ConstraintDescriptorImplementation(ConstraintType.UNIQUE_EXISTS, schema, indexType).asNodeKeyConstraint();
    }
}

