/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema.constraints;

import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaNameUtil;
import org.neo4j.internal.schema.SchemaUserDescription;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.internal.schema.constraints.KeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.NodeExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.RelExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.util.Preconditions;

public class ConstraintDescriptorImplementation
implements ConstraintDescriptor,
NodeExistenceConstraintDescriptor,
KeyConstraintDescriptor,
RelExistenceConstraintDescriptor,
UniquenessConstraintDescriptor {
    private final ConstraintType type;
    private final SchemaDescriptor schema;
    private final long id;
    private final String name;
    private final Long ownedIndex;
    private final IndexType ownedIndexType;

    ConstraintDescriptorImplementation(ConstraintType type, SchemaDescriptor schema) {
        Preconditions.checkState((type == ConstraintType.EXISTS ? 1 : 0) != 0, (String)"Index type should be supplied for index-backed constraints");
        this.type = type;
        this.schema = schema;
        this.id = -1L;
        this.name = null;
        this.ownedIndex = null;
        this.ownedIndexType = null;
    }

    ConstraintDescriptorImplementation(ConstraintType type, SchemaDescriptor schema, IndexType ownedIndexType) {
        this.type = type;
        this.schema = schema;
        this.id = -1L;
        this.name = null;
        this.ownedIndex = null;
        Preconditions.checkState((type != ConstraintType.EXISTS && ownedIndexType != null || type == ConstraintType.EXISTS && ownedIndexType == null ? 1 : 0) != 0, (String)"Index type should be supplied for index-backed constraints");
        this.ownedIndexType = ownedIndexType;
    }

    private ConstraintDescriptorImplementation(ConstraintType type, SchemaDescriptor schema, long id, String name, Long ownedIndex, IndexType ownedIndexType) {
        this.type = type;
        this.schema = schema;
        this.id = id;
        this.name = name;
        this.ownedIndex = ownedIndex;
        this.ownedIndexType = ownedIndexType;
    }

    @Override
    public ConstraintType type() {
        return this.type;
    }

    @Override
    public SchemaDescriptor schema() {
        return this.schema;
    }

    @Override
    public boolean enforcesUniqueness() {
        return this.type.enforcesUniqueness();
    }

    @Override
    public boolean enforcesPropertyExistence() {
        return this.type.enforcesPropertyExistence();
    }

    @Override
    public String userDescription(TokenNameLookup tokenNameLookup) {
        return SchemaUserDescription.forConstraint(tokenNameLookup, this.id, this.name, this.type, this.schema(), this.ownedIndex);
    }

    @Override
    public boolean isRelationshipPropertyExistenceConstraint() {
        return this.schema.entityType() == EntityType.RELATIONSHIP && this.type == ConstraintType.EXISTS;
    }

    @Override
    public RelExistenceConstraintDescriptor asRelationshipPropertyExistenceConstraint() {
        if (!this.isRelationshipPropertyExistenceConstraint()) {
            throw this.conversionException(RelExistenceConstraintDescriptor.class);
        }
        return this;
    }

    @Override
    public boolean isNodePropertyExistenceConstraint() {
        return this.schema.entityType() == EntityType.NODE && this.type == ConstraintType.EXISTS;
    }

    @Override
    public NodeExistenceConstraintDescriptor asNodePropertyExistenceConstraint() {
        if (!this.isNodePropertyExistenceConstraint()) {
            throw this.conversionException(NodeExistenceConstraintDescriptor.class);
        }
        return this;
    }

    @Override
    public boolean isUniquenessConstraint() {
        return this.schema.entityType() == EntityType.NODE && this.type == ConstraintType.UNIQUE;
    }

    @Override
    public UniquenessConstraintDescriptor asUniquenessConstraint() {
        if (!this.isUniquenessConstraint()) {
            throw this.conversionException(UniquenessConstraintDescriptor.class);
        }
        return this;
    }

    @Override
    public boolean isNodeKeyConstraint() {
        return this.schema.entityType() == EntityType.NODE && this.type == ConstraintType.UNIQUE_EXISTS;
    }

    @Override
    public boolean isRelationshipKeyConstraint() {
        return this.schema.entityType() == EntityType.RELATIONSHIP && this.type == ConstraintType.UNIQUE_EXISTS;
    }

    @Override
    public boolean isIndexBackedConstraint() {
        return this.isUniquenessConstraint() || this.isNodeKeyConstraint() || this.isRelationshipKeyConstraint();
    }

    @Override
    public IndexBackedConstraintDescriptor asIndexBackedConstraint() {
        if (!this.isIndexBackedConstraint()) {
            throw this.conversionException(IndexBackedConstraintDescriptor.class);
        }
        return this;
    }

    @Override
    public boolean isKeyConstraint() {
        return this.isNodeKeyConstraint() || this.isRelationshipKeyConstraint();
    }

    @Override
    public KeyConstraintDescriptor asKeyConstraint() {
        if (!this.isKeyConstraint()) {
            throw this.conversionException(KeyConstraintDescriptor.class);
        }
        return this;
    }

    private IllegalStateException conversionException(Class<? extends ConstraintDescriptor> targetType) {
        return new IllegalStateException("Cannot cast this schema to a " + targetType + " because it does not match that structure: " + this + ".");
    }

    public final boolean equals(Object o) {
        if (o instanceof ConstraintDescriptor) {
            boolean compare;
            ConstraintDescriptor that = (ConstraintDescriptor)o;
            boolean bl = compare = this.type() == that.type() && this.schema().equals(that.schema());
            if (compare && that.isIndexBackedConstraint()) {
                compare = compare && this.indexType().equals((Object)that.asIndexBackedConstraint().indexType());
            }
            return compare;
        }
        return false;
    }

    public final int hashCode() {
        return this.type.hashCode() & this.schema().hashCode();
    }

    @Override
    public long getId() {
        if (this.id == -1L) {
            throw new IllegalStateException("This constraint descriptor have no id assigned: " + this);
        }
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasOwnedIndexId() {
        return this.ownedIndex != null;
    }

    @Override
    public long ownedIndexId() {
        if (this.ownedIndex == null) {
            throw new IllegalStateException("This constraint does not own an index.");
        }
        return this.ownedIndex;
    }

    @Override
    public IndexType indexType() {
        if (this.ownedIndexType == null) {
            throw new IllegalStateException("This constraint does not own an index.");
        }
        return this.ownedIndexType;
    }

    @Override
    public ConstraintDescriptorImplementation withId(long id) {
        return new ConstraintDescriptorImplementation(this.type, this.schema, id, this.name, this.ownedIndex, this.ownedIndexType);
    }

    @Override
    public ConstraintDescriptorImplementation withName(String name) {
        if (name == null) {
            return this;
        }
        name = SchemaNameUtil.sanitiseName(name);
        return new ConstraintDescriptorImplementation(this.type, this.schema, this.id, name, this.ownedIndex, this.ownedIndexType);
    }

    @Override
    public ConstraintDescriptorImplementation withOwnedIndexId(long ownedIndex) {
        Preconditions.checkState((this.ownedIndexType != null ? 1 : 0) != 0, (String)"ConstraintDescriptor missing IndexType when connected to index");
        return new ConstraintDescriptorImplementation(this.type, this.schema, this.id, this.name, ownedIndex, this.ownedIndexType);
    }

    public String toString() {
        return this.userDescription(SchemaUserDescription.TOKEN_ID_NAME_LOOKUP);
    }
}

