/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.PropertySchemaType;
import org.neo4j.lock.ResourceType;

public interface SchemaDescriptor {
    public <T extends SchemaDescriptor> boolean isSchemaDescriptorType(Class<T> var1);

    public <T extends SchemaDescriptor> T asSchemaDescriptorType(Class<T> var1);

    public boolean isAffected(int[] var1);

    public int[] getPropertyIds();

    default public int getPropertyId() {
        int[] propertyIds = this.getPropertyIds();
        if (propertyIds.length != 1) {
            throw new IllegalStateException("Single property schema requires one property but had " + propertyIds.length);
        }
        return propertyIds[0];
    }

    public int[] getEntityTokenIds();

    default public int getLabelId() {
        if (this.entityType() != EntityType.NODE) {
            throw new IllegalStateException("Cannot get label id from a schema on " + this.entityType() + " entities.");
        }
        int[] entityTokenIds = this.getEntityTokenIds();
        if (entityTokenIds.length != 1) {
            throw new IllegalStateException("Cannot get a single label id from a multi-token schema descriptor: " + this);
        }
        return entityTokenIds[0];
    }

    default public int getRelTypeId() {
        if (this.entityType() != EntityType.RELATIONSHIP) {
            throw new IllegalStateException("Cannot get relationship type id from a schema on " + this.entityType() + " entities.");
        }
        int[] entityTokenIds = this.getEntityTokenIds();
        if (entityTokenIds.length != 1) {
            throw new IllegalStateException("Cannot get a single relationship type id from a multi-token schema descriptor: " + this);
        }
        return entityTokenIds[0];
    }

    public long[] lockingKeys();

    public ResourceType keyType();

    public EntityType entityType();

    public PropertySchemaType propertySchemaType();

    public String userDescription(TokenNameLookup var1);
}

