/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import org.neo4j.common.EntityType;

public enum ConstraintType {
    UNIQUE(true, false, false),
    EXISTS(false, true, false),
    UNIQUE_EXISTS(true, true, false),
    PROPERTY_TYPE(false, false, true),
    ENDPOINT(false, false, false);

    private final boolean isUnique;
    private final boolean mustExist;
    private final boolean isType;

    private ConstraintType(boolean isUnique, boolean mustExist, boolean isType) {
        this.isUnique = isUnique;
        this.mustExist = mustExist;
        this.isType = isType;
    }

    public boolean enforcesUniqueness() {
        return this.isUnique;
    }

    public boolean enforcesPropertyExistence() {
        return this.mustExist;
    }

    public boolean enforcesPropertyType() {
        return this.isType;
    }

    public String userDescription(EntityType entityType) {
        String name = entityType.name();
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case EXISTS -> name + " PROPERTY EXISTENCE";
            case UNIQUE -> {
                if (entityType == EntityType.NODE) {
                    yield "UNIQUENESS";
                }
                yield name + " UNIQUENESS";
            }
            case UNIQUE_EXISTS -> name + " KEY";
            case PROPERTY_TYPE -> name + " PROPERTY TYPE";
            case ENDPOINT -> name + " ENDPOINT";
        };
    }
}

