/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema.constraints;

import java.util.Objects;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.GraphTypeDependence;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaNameUtil;
import org.neo4j.internal.schema.SchemaUserDescription;
import org.neo4j.internal.schema.constraints.ExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.internal.schema.constraints.KeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.LabelCoexistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.internal.schema.constraints.RelationshipEndpointConstraintDescriptor;
import org.neo4j.internal.schema.constraints.TypeConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.string.Mask;
import org.neo4j.util.Preconditions;

public class ConstraintDescriptorImplementation
implements ConstraintDescriptor,
ExistenceConstraintDescriptor,
KeyConstraintDescriptor,
UniquenessConstraintDescriptor,
TypeConstraintDescriptor {
    private final ConstraintType type;
    private final GraphTypeDependence graphTypeDependence;
    private final SchemaDescriptor schema;
    private final long id;
    private final String name;
    private final Long ownedIndex;
    private final IndexType ownedIndexType;
    private final PropertyTypeSet propertyType;

    static ConstraintDescriptorImplementation makeExistsConstraint(SchemaDescriptor schema) {
        return ConstraintDescriptorImplementation.makeExistsConstraint(schema, false);
    }

    static ConstraintDescriptorImplementation makeExistsConstraint(SchemaDescriptor schema, boolean isDependent) {
        return new ConstraintDescriptorImplementation(ConstraintType.EXISTS, isDependent ? GraphTypeDependence.DEPENDENT : GraphTypeDependence.INDEPENDENT, schema, -1L, null, null, null, null);
    }

    static KeyConstraintDescriptor makeUniqueExistsConstraint(SchemaDescriptor schema, IndexType indexType) {
        Preconditions.checkState((indexType != null ? 1 : 0) != 0, (String)"Index type should be supplied for index-backed constraints");
        return new ConstraintDescriptorImplementation(ConstraintType.UNIQUE_EXISTS, GraphTypeDependence.UNDESIGNATED, schema, -1L, null, null, indexType, null);
    }

    static UniquenessConstraintDescriptor makeUniqueConstraint(SchemaDescriptor schema, IndexType indexType) {
        Preconditions.checkState((indexType != null ? 1 : 0) != 0, (String)"Index type should be supplied for index-backed constraints");
        return new ConstraintDescriptorImplementation(ConstraintType.UNIQUE, GraphTypeDependence.UNDESIGNATED, schema, -1L, null, null, indexType, null);
    }

    static TypeConstraintDescriptor makePropertyTypeConstraint(SchemaDescriptor schema, PropertyTypeSet propertyType) {
        return ConstraintDescriptorImplementation.makePropertyTypeConstraint(schema, propertyType, false);
    }

    static TypeConstraintDescriptor makePropertyTypeConstraint(SchemaDescriptor schema, PropertyTypeSet propertyType, boolean isDependent) {
        Preconditions.checkState((propertyType != null ? 1 : 0) != 0, (String)"Property types should be supplied for property type constraints");
        return new ConstraintDescriptorImplementation(ConstraintType.PROPERTY_TYPE, isDependent ? GraphTypeDependence.DEPENDENT : GraphTypeDependence.INDEPENDENT, schema, -1L, null, null, null, propertyType);
    }

    private ConstraintDescriptorImplementation(ConstraintType type, GraphTypeDependence graphTypeDependence, SchemaDescriptor schema, long id, String name, Long ownedIndex, IndexType ownedIndexType, PropertyTypeSet propertyType) {
        this.type = type;
        this.graphTypeDependence = graphTypeDependence;
        this.schema = schema;
        this.id = id;
        this.name = name;
        this.ownedIndex = ownedIndex;
        this.ownedIndexType = ownedIndexType;
        this.propertyType = propertyType;
    }

    @Override
    public ConstraintType type() {
        return this.type;
    }

    @Override
    public GraphTypeDependence graphTypeDependence() {
        return this.graphTypeDependence;
    }

    @Override
    public SchemaDescriptor schema() {
        return this.schema;
    }

    @Override
    public boolean enforcesUniqueness() {
        return this.type.enforcesUniqueness();
    }

    @Override
    public boolean enforcesPropertyExistence() {
        return this.type.enforcesPropertyExistence();
    }

    @Override
    public boolean enforcesPropertyType() {
        return this.type.enforcesPropertyType();
    }

    @Override
    public String userDescription(TokenNameLookup tokenNameLookup) {
        return this.userDescription(tokenNameLookup, Mask.NO);
    }

    private String userDescription(TokenNameLookup tokenNameLookup, Mask mask) {
        return SchemaUserDescription.forConstraint(tokenNameLookup, this.id, this.name, this.type, this.schema(), this.ownedIndex, this.propertyType, null, mask);
    }

    @Override
    public boolean isNodePropertyTypeConstraint() {
        return this.schema.entityType() == EntityType.NODE && this.type == ConstraintType.PROPERTY_TYPE;
    }

    @Override
    public boolean isRelationshipPropertyTypeConstraint() {
        return this.schema.entityType() == EntityType.RELATIONSHIP && this.type == ConstraintType.PROPERTY_TYPE;
    }

    @Override
    public boolean isPropertyTypeConstraint() {
        return this.type == ConstraintType.PROPERTY_TYPE;
    }

    @Override
    public TypeConstraintDescriptor asPropertyTypeConstraint() {
        if (!this.isPropertyTypeConstraint()) {
            throw this.conversionException(TypeConstraintDescriptor.class);
        }
        return this;
    }

    @Override
    public boolean isPropertyExistenceConstraint() {
        return this.type == ConstraintType.EXISTS;
    }

    @Override
    public boolean isRelationshipPropertyExistenceConstraint() {
        return this.schema.entityType() == EntityType.RELATIONSHIP && this.type == ConstraintType.EXISTS;
    }

    @Override
    public boolean isNodePropertyExistenceConstraint() {
        return this.schema.entityType() == EntityType.NODE && this.type == ConstraintType.EXISTS;
    }

    @Override
    public ExistenceConstraintDescriptor asPropertyExistenceConstraint() {
        if (!this.isPropertyExistenceConstraint()) {
            throw this.conversionException(ExistenceConstraintDescriptor.class);
        }
        return this;
    }

    @Override
    public boolean isUniquenessConstraint() {
        return this.type == ConstraintType.UNIQUE;
    }

    @Override
    public boolean isNodeUniquenessConstraint() {
        return this.schema.entityType() == EntityType.NODE && this.type == ConstraintType.UNIQUE;
    }

    @Override
    public boolean isRelationshipUniquenessConstraint() {
        return this.schema.entityType() == EntityType.RELATIONSHIP && this.type == ConstraintType.UNIQUE;
    }

    @Override
    public UniquenessConstraintDescriptor asUniquenessConstraint() {
        if (!this.isUniquenessConstraint()) {
            throw this.conversionException(UniquenessConstraintDescriptor.class);
        }
        return this;
    }

    @Override
    public boolean isNodeKeyConstraint() {
        return this.schema.entityType() == EntityType.NODE && this.type == ConstraintType.UNIQUE_EXISTS;
    }

    @Override
    public boolean isRelationshipKeyConstraint() {
        return this.schema.entityType() == EntityType.RELATIONSHIP && this.type == ConstraintType.UNIQUE_EXISTS;
    }

    @Override
    public boolean isIndexBackedConstraint() {
        return this.type.enforcesUniqueness();
    }

    @Override
    public IndexBackedConstraintDescriptor asIndexBackedConstraint() {
        if (!this.isIndexBackedConstraint()) {
            throw this.conversionException(IndexBackedConstraintDescriptor.class);
        }
        return this;
    }

    @Override
    public boolean isKeyConstraint() {
        return this.isNodeKeyConstraint() || this.isRelationshipKeyConstraint();
    }

    @Override
    public KeyConstraintDescriptor asKeyConstraint() {
        if (!this.isKeyConstraint()) {
            throw this.conversionException(KeyConstraintDescriptor.class);
        }
        return this;
    }

    @Override
    public boolean isRelationshipEndpointConstraint() {
        return false;
    }

    @Override
    public boolean isLabelCoexistenceConstraint() {
        return false;
    }

    @Override
    public RelationshipEndpointConstraintDescriptor asRelationshipEndpointConstraint() {
        throw this.conversionException(RelationshipEndpointConstraintDescriptor.class);
    }

    @Override
    public LabelCoexistenceConstraintDescriptor asLabelCoexistenceConstraint() {
        throw this.conversionException(LabelCoexistenceConstraintDescriptor.class);
    }

    private IllegalStateException conversionException(Class<? extends ConstraintDescriptor> targetType) {
        return new IllegalStateException("Cannot cast this schema to a " + targetType + " because it does not match that structure: " + this + ".");
    }

    public final boolean equals(Object o) {
        if (!(o instanceof ConstraintDescriptor)) {
            return false;
        }
        ConstraintDescriptor that = (ConstraintDescriptor)o;
        if (this.type != that.type()) {
            return false;
        }
        if (this.graphTypeDependence != that.graphTypeDependence()) {
            return false;
        }
        if (!this.schema().equals(that.schema())) {
            return false;
        }
        if (that.isIndexBackedConstraint() && !this.indexType().equals((Object)that.asIndexBackedConstraint().indexType())) {
            return false;
        }
        return !that.enforcesPropertyType() || this.propertyType.equals(that.asPropertyTypeConstraint().propertyType());
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.type, this.graphTypeDependence, this.schema});
    }

    @Override
    public long getId() {
        if (this.id == -1L) {
            throw new IllegalStateException("This constraint descriptor have no id assigned: " + this);
        }
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasOwnedIndexId() {
        return this.ownedIndex != null;
    }

    @Override
    public long ownedIndexId() {
        if (this.ownedIndex == null) {
            throw new IllegalStateException("This constraint does not own an index.");
        }
        return this.ownedIndex;
    }

    @Override
    public IndexType indexType() {
        if (this.ownedIndexType == null) {
            throw new IllegalStateException("This constraint does not own an index.");
        }
        return this.ownedIndexType;
    }

    @Override
    public ConstraintDescriptorImplementation withId(long id) {
        return new ConstraintDescriptorImplementation(this.type, this.graphTypeDependence, this.schema, id, this.name, this.ownedIndex, this.ownedIndexType, this.propertyType);
    }

    @Override
    public ConstraintDescriptorImplementation withName(String name) {
        if (name == null) {
            return this;
        }
        name = SchemaNameUtil.sanitiseName(name);
        return new ConstraintDescriptorImplementation(this.type, this.graphTypeDependence, this.schema, this.id, name, this.ownedIndex, this.ownedIndexType, this.propertyType);
    }

    @Override
    public PropertyTypeSet propertyType() {
        if (!this.enforcesPropertyType()) {
            throw new IllegalStateException("This constraint does not enforce property types.");
        }
        return this.propertyType;
    }

    @Override
    public ConstraintDescriptorImplementation withOwnedIndexId(long ownedIndex) {
        Preconditions.checkState((this.ownedIndexType != null ? 1 : 0) != 0, (String)"ConstraintDescriptor missing IndexType when connected to index");
        return new ConstraintDescriptorImplementation(this.type, this.graphTypeDependence, this.schema, this.id, this.name, ownedIndex, this.ownedIndexType, this.propertyType);
    }

    public String toString() {
        return this.toString(Mask.NO);
    }

    public String toString(Mask mask) {
        return this.userDescription(SchemaUserDescription.TOKEN_ID_NAME_LOOKUP, mask);
    }
}

