/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema.constraints;

import java.util.Objects;
import org.apache.commons.lang3.NotImplementedException;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.GraphTypeDependence;
import org.neo4j.internal.schema.LabelCoexistenceSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaNameUtil;
import org.neo4j.internal.schema.SchemaUserDescription;
import org.neo4j.internal.schema.constraints.ExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.internal.schema.constraints.KeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.LabelCoexistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.RelationshipEndpointConstraintDescriptor;
import org.neo4j.internal.schema.constraints.TypeConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.string.Mask;

final class LabelCoexistenceConstraintDescriptorImplementation
implements LabelCoexistenceConstraintDescriptor {
    private final long id;
    private final String name;
    private final LabelCoexistenceSchemaDescriptor schema;
    private final int requiredLabelId;

    LabelCoexistenceConstraintDescriptorImplementation(LabelCoexistenceSchemaDescriptor schema, long id, int requiredLabelId, String name) {
        if (requiredLabelId < 0) {
            throw new IllegalArgumentException("requiredLabelId cannot be negative");
        }
        this.schema = Objects.requireNonNull(schema, "LabelCoexistenceSchemaDescriptor cannot be null");
        if (requiredLabelId == schema.getLabelId()) {
            throw new IllegalArgumentException("requiredLabelId cannot be same as schema labelId");
        }
        this.requiredLabelId = requiredLabelId;
        this.id = id;
        this.name = name;
    }

    static LabelCoexistenceConstraintDescriptor make(LabelCoexistenceSchemaDescriptor schema, int requiredLabelId) {
        return new LabelCoexistenceConstraintDescriptorImplementation(schema, -1L, requiredLabelId, null);
    }

    @Override
    public SchemaDescriptor schema() {
        return this.schema;
    }

    @Override
    public ConstraintType type() {
        return ConstraintType.LABEL_COEXISTENCE;
    }

    @Override
    public GraphTypeDependence graphTypeDependence() {
        return GraphTypeDependence.DEPENDENT;
    }

    @Override
    public boolean enforcesUniqueness() {
        return false;
    }

    @Override
    public boolean enforcesPropertyExistence() {
        return false;
    }

    @Override
    public boolean enforcesPropertyType() {
        return false;
    }

    @Override
    public boolean isPropertyTypeConstraint() {
        return false;
    }

    @Override
    public boolean isRelationshipEndpointConstraint() {
        return false;
    }

    @Override
    public boolean isLabelCoexistenceConstraint() {
        return true;
    }

    @Override
    public boolean isNodePropertyTypeConstraint() {
        return false;
    }

    @Override
    public boolean isRelationshipPropertyTypeConstraint() {
        return false;
    }

    @Override
    public TypeConstraintDescriptor asPropertyTypeConstraint() {
        throw this.conversionException(TypeConstraintDescriptor.class);
    }

    @Override
    public boolean isPropertyExistenceConstraint() {
        return false;
    }

    @Override
    public boolean isRelationshipPropertyExistenceConstraint() {
        return false;
    }

    @Override
    public boolean isNodePropertyExistenceConstraint() {
        return false;
    }

    @Override
    public ExistenceConstraintDescriptor asPropertyExistenceConstraint() {
        throw this.conversionException(ExistenceConstraintDescriptor.class);
    }

    @Override
    public boolean isUniquenessConstraint() {
        return false;
    }

    @Override
    public boolean isNodeUniquenessConstraint() {
        return false;
    }

    @Override
    public boolean isRelationshipUniquenessConstraint() {
        return false;
    }

    @Override
    public UniquenessConstraintDescriptor asUniquenessConstraint() {
        throw this.conversionException(UniquenessConstraintDescriptor.class);
    }

    @Override
    public boolean isNodeKeyConstraint() {
        return false;
    }

    @Override
    public boolean isRelationshipKeyConstraint() {
        return false;
    }

    @Override
    public boolean isIndexBackedConstraint() {
        return false;
    }

    @Override
    public IndexBackedConstraintDescriptor asIndexBackedConstraint() {
        throw this.conversionException(IndexBackedConstraintDescriptor.class);
    }

    @Override
    public boolean isKeyConstraint() {
        return false;
    }

    @Override
    public KeyConstraintDescriptor asKeyConstraint() {
        throw this.conversionException(KeyConstraintDescriptor.class);
    }

    @Override
    public LabelCoexistenceConstraintDescriptor withId(long newId) {
        return new LabelCoexistenceConstraintDescriptorImplementation(this.schema, newId, this.requiredLabelId, this.name);
    }

    @Override
    public LabelCoexistenceConstraintDescriptor withName(String newName) {
        if (newName == null) {
            return this;
        }
        newName = SchemaNameUtil.sanitiseName(newName);
        return new LabelCoexistenceConstraintDescriptorImplementation(this.schema, this.id, this.requiredLabelId, newName);
    }

    @Override
    public IndexBackedConstraintDescriptor withOwnedIndexId(long id) {
        throw new NotImplementedException();
    }

    @Override
    public RelationshipEndpointConstraintDescriptor asRelationshipEndpointConstraint() {
        throw this.conversionException(RelationshipEndpointConstraintDescriptor.class);
    }

    @Override
    public LabelCoexistenceConstraintDescriptor asLabelCoexistenceConstraint() {
        return this;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LabelCoexistenceConstraintDescriptor)) {
            return false;
        }
        LabelCoexistenceConstraintDescriptor that = (LabelCoexistenceConstraintDescriptor)o;
        if (this.requiredLabelId != that.requiredLabelId()) {
            return false;
        }
        return this.schema().equals(that.schema());
    }

    public int hashCode() {
        return Objects.hash(this.schema);
    }

    @Override
    public long getId() {
        if (this.id == -1L) {
            throw new IllegalStateException("This constraint descriptor have no id assigned: " + this);
        }
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int requiredLabelId() {
        return this.requiredLabelId;
    }

    public String toString() {
        return this.toString(Mask.NO);
    }

    public String toString(Mask mask) {
        return this.userDescription(SchemaUserDescription.TOKEN_ID_NAME_LOOKUP, mask);
    }

    private String userDescription(TokenNameLookup tokenNameLookup, Mask mask) {
        return SchemaUserDescription.forConstraint(tokenNameLookup, this.id, this.name, ConstraintType.LABEL_COEXISTENCE, this.schema, null, null, tokenNameLookup.labelGetName(this.requiredLabelId), mask);
    }

    @Override
    public String userDescription(TokenNameLookup tokenNameLookup) {
        return this.userDescription(SchemaUserDescription.TOKEN_ID_NAME_LOOKUP, Mask.NO);
    }

    private IllegalStateException conversionException(Class<? extends ConstraintDescriptor> targetType) {
        return new IllegalStateException("Cannot cast this schema to a " + targetType + " because it does not match that structure: " + this + ".");
    }
}

