/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.util.List;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.MutableSet;
import org.neo4j.internal.schema.SchemaCommand;

public record SchemaTokens(ImmutableSet<String> labels, ImmutableSet<String> relationships, ImmutableSet<String> properties) {
    public static SchemaTokens collect(List<SchemaCommand> commands) {
        MutableSet labels = Sets.mutable.empty();
        MutableSet relationships = Sets.mutable.empty();
        MutableSet properties = Sets.mutable.empty();
        for (SchemaCommand command : commands) {
            if (command instanceof SchemaCommand.IndexCommand.Create.NodeRange) {
                SchemaCommand.IndexCommand.Create.NodeRange indexCommand = (SchemaCommand.IndexCommand.Create.NodeRange)command;
                labels.add((Object)indexCommand.label());
                properties.addAll(indexCommand.properties());
                continue;
            }
            if (command instanceof SchemaCommand.IndexCommand.Create.RelationshipRange) {
                SchemaCommand.IndexCommand.Create.RelationshipRange indexCommand = (SchemaCommand.IndexCommand.Create.RelationshipRange)command;
                relationships.add((Object)indexCommand.type());
                properties.addAll(indexCommand.properties());
                continue;
            }
            if (command instanceof SchemaCommand.IndexCommand.Create.NodeText) {
                SchemaCommand.IndexCommand.Create.NodeText indexCommand = (SchemaCommand.IndexCommand.Create.NodeText)command;
                labels.add((Object)indexCommand.label());
                properties.add((Object)indexCommand.property());
                continue;
            }
            if (command instanceof SchemaCommand.IndexCommand.Create.RelationshipText) {
                SchemaCommand.IndexCommand.Create.RelationshipText indexCommand = (SchemaCommand.IndexCommand.Create.RelationshipText)command;
                relationships.add((Object)indexCommand.type());
                properties.add((Object)indexCommand.property());
                continue;
            }
            if (command instanceof SchemaCommand.IndexCommand.Create.NodePoint) {
                SchemaCommand.IndexCommand.Create.NodePoint indexCommand = (SchemaCommand.IndexCommand.Create.NodePoint)command;
                labels.add((Object)indexCommand.label());
                properties.add((Object)indexCommand.property());
                continue;
            }
            if (command instanceof SchemaCommand.IndexCommand.Create.RelationshipPoint) {
                SchemaCommand.IndexCommand.Create.RelationshipPoint indexCommand = (SchemaCommand.IndexCommand.Create.RelationshipPoint)command;
                relationships.add((Object)indexCommand.type());
                properties.add((Object)indexCommand.property());
                continue;
            }
            if (command instanceof SchemaCommand.IndexCommand.Create.NodeFulltext) {
                SchemaCommand.IndexCommand.Create.NodeFulltext indexCommand = (SchemaCommand.IndexCommand.Create.NodeFulltext)command;
                labels.addAll(indexCommand.labels());
                properties.addAll(indexCommand.properties());
                continue;
            }
            if (command instanceof SchemaCommand.IndexCommand.Create.RelationshipFulltext) {
                SchemaCommand.IndexCommand.Create.RelationshipFulltext indexCommand = (SchemaCommand.IndexCommand.Create.RelationshipFulltext)command;
                relationships.addAll(indexCommand.types());
                properties.addAll(indexCommand.properties());
                continue;
            }
            if (command instanceof SchemaCommand.IndexCommand.Create.NodeVector) {
                SchemaCommand.IndexCommand.Create.NodeVector indexCommand = (SchemaCommand.IndexCommand.Create.NodeVector)command;
                labels.add((Object)indexCommand.label());
                properties.add((Object)indexCommand.property());
                continue;
            }
            if (command instanceof SchemaCommand.IndexCommand.Create.RelationshipVector) {
                SchemaCommand.IndexCommand.Create.RelationshipVector indexCommand = (SchemaCommand.IndexCommand.Create.RelationshipVector)command;
                relationships.add((Object)indexCommand.type());
                properties.add((Object)indexCommand.property());
                continue;
            }
            if (command instanceof SchemaCommand.ConstraintCommand.Create.NodeKey) {
                SchemaCommand.ConstraintCommand.Create.NodeKey constraintCommand = (SchemaCommand.ConstraintCommand.Create.NodeKey)command;
                labels.add((Object)constraintCommand.label());
                properties.addAll(constraintCommand.properties());
                continue;
            }
            if (command instanceof SchemaCommand.ConstraintCommand.Create.RelationshipKey) {
                SchemaCommand.ConstraintCommand.Create.RelationshipKey constraintCommand = (SchemaCommand.ConstraintCommand.Create.RelationshipKey)command;
                relationships.add((Object)constraintCommand.type());
                properties.addAll(constraintCommand.properties());
                continue;
            }
            if (command instanceof SchemaCommand.ConstraintCommand.Create.NodeUniqueness) {
                SchemaCommand.ConstraintCommand.Create.NodeUniqueness constraintCommand = (SchemaCommand.ConstraintCommand.Create.NodeUniqueness)command;
                labels.add((Object)constraintCommand.label());
                properties.addAll(constraintCommand.properties());
                continue;
            }
            if (command instanceof SchemaCommand.ConstraintCommand.Create.RelationshipUniqueness) {
                SchemaCommand.ConstraintCommand.Create.RelationshipUniqueness constraintCommand = (SchemaCommand.ConstraintCommand.Create.RelationshipUniqueness)command;
                relationships.add((Object)constraintCommand.type());
                properties.addAll(constraintCommand.properties());
                continue;
            }
            if (command instanceof SchemaCommand.ConstraintCommand.Create.NodeExistence) {
                SchemaCommand.ConstraintCommand.Create.NodeExistence constraintCommand = (SchemaCommand.ConstraintCommand.Create.NodeExistence)command;
                labels.add((Object)constraintCommand.label());
                properties.add((Object)constraintCommand.property());
                continue;
            }
            if (command instanceof SchemaCommand.ConstraintCommand.Create.RelationshipExistence) {
                SchemaCommand.ConstraintCommand.Create.RelationshipExistence constraintCommand = (SchemaCommand.ConstraintCommand.Create.RelationshipExistence)command;
                relationships.add((Object)constraintCommand.type());
                properties.add((Object)constraintCommand.property());
                continue;
            }
            if (command instanceof SchemaCommand.ConstraintCommand.Create.NodePropertyType) {
                SchemaCommand.ConstraintCommand.Create.NodePropertyType constraintCommand = (SchemaCommand.ConstraintCommand.Create.NodePropertyType)command;
                labels.add((Object)constraintCommand.label());
                properties.add((Object)constraintCommand.property());
                continue;
            }
            if (command instanceof SchemaCommand.ConstraintCommand.Create.RelationshipPropertyType) {
                SchemaCommand.ConstraintCommand.Create.RelationshipPropertyType constraintCommand = (SchemaCommand.ConstraintCommand.Create.RelationshipPropertyType)command;
                relationships.add((Object)constraintCommand.type());
                properties.add((Object)constraintCommand.property());
                continue;
            }
            if (command instanceof SchemaCommand.IndexCommand.Create.NodeLookup || command instanceof SchemaCommand.IndexCommand.Create.RelationshipLookup) continue;
            throw new IllegalStateException("Unrecognised command - unable to collect schema tokens for: " + command);
        }
        return new SchemaTokens((ImmutableSet<String>)labels.toImmutable(), (ImmutableSet<String>)relationships.toImmutable(), (ImmutableSet<String>)properties.toImmutable());
    }
}

