/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.io.Serializable;
import java.util.Map;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.map.mutable.MapAdapter;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.graphdb.schema.IndexSettingImpl;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public interface SettingsAccessor {
    public static final ImmutableMap<String, IndexSetting> INDEX_SETTING_LOOKUP = Lists.mutable.of((Object[])IndexSettingImpl.values()).toImmutableMap(IndexSetting::getSettingName, (Function & Serializable)setting -> setting);

    public boolean containsSetting(IndexSetting var1);

    public AnyValue get(IndexSetting var1);

    public ImmutableSet<String> settingNames();

    default public ImmutableSet<IndexSetting> settings() {
        return this.settingNames().asLazy().collect(arg_0 -> INDEX_SETTING_LOOKUP.get(arg_0)).toImmutableSet();
    }

    public static class MapValueAccessor
    implements SettingsAccessor {
        private final MapValue map;

        public MapValueAccessor(MapValue map) {
            this.map = map;
        }

        @Override
        public boolean containsSetting(IndexSetting setting) {
            return this.map.containsKey(setting.getSettingName());
        }

        @Override
        public AnyValue get(IndexSetting setting) {
            return this.map.get(setting.getSettingName());
        }

        @Override
        public ImmutableSet<String> settingNames() {
            return Sets.immutable.ofAll(this.map.keySet());
        }
    }

    public static class IndexConfigAccessor
    implements SettingsAccessor {
        private final IndexConfig config;

        public IndexConfigAccessor(IndexConfig config) {
            this.config = config;
        }

        @Override
        public boolean containsSetting(IndexSetting setting) {
            return this.config.asMap().containsKey(setting.getSettingName());
        }

        @Override
        public AnyValue get(IndexSetting setting) {
            return this.config.getOrDefault(setting.getSettingName(), Values.NO_VALUE);
        }

        @Override
        public ImmutableSet<String> settingNames() {
            return this.config.entries().asLazy().collect(Pair::getOne).toImmutableSet();
        }
    }

    public static class IndexSettingObjectMapAccessor
    implements SettingsAccessor {
        private final MapIterable<IndexSetting, Object> settings;

        public IndexSettingObjectMapAccessor(Map<IndexSetting, Object> settings) {
            this.settings = MapAdapter.adapt(settings);
        }

        @Override
        public boolean containsSetting(IndexSetting setting) {
            return this.settings.containsKey((Object)setting);
        }

        @Override
        public AnyValue get(IndexSetting setting) {
            return Values.of((Object)this.settings.get((Object)setting));
        }

        @Override
        public ImmutableSet<String> settingNames() {
            return this.settings.keysView().asLazy().collect(IndexSetting::getSettingName).toImmutableSet();
        }
    }
}

