/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import org.neo4j.internal.schema.IndexBehaviour;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueCategory;

public interface IndexCapability {
    public static final double COST_MULTIPLIER_STANDARD = 1.0;
    public static final IndexBehaviour[] BEHAVIOURS_NONE = new IndexBehaviour[0];
    public static final IndexCapability NO_CAPABILITY = new IndexCapability(){

        @Override
        public boolean supportsOrdering() {
            return false;
        }

        @Override
        public boolean supportsReturningValues() {
            return false;
        }

        @Override
        public boolean areValueCategoriesAccepted(ValueCategory ... valueCategories) {
            Preconditions.requireNonEmpty((Object[])valueCategories);
            Preconditions.requireNoNullElements((Object[])valueCategories);
            return false;
        }

        @Override
        public boolean isQuerySupported(IndexQuery.IndexQueryType queryType, ValueCategory valueCategory) {
            return false;
        }

        @Override
        public double getCostMultiplier(IndexQuery.IndexQueryType ... queryTypes) {
            return 1.0;
        }

        @Override
        public boolean supportPartitionedScan(IndexQuery ... queries) {
            Preconditions.requireNonEmpty((Object[])queries);
            Preconditions.requireNoNullElements((Object[])queries);
            return false;
        }
    };

    public boolean supportsOrdering();

    public boolean supportsReturningValues();

    public boolean areValueCategoriesAccepted(ValueCategory ... var1);

    default public boolean areValuesAccepted(Value ... values) {
        Preconditions.requireNonEmpty((Object[])values);
        Preconditions.requireNoNullElements((Object[])values);
        ValueCategory[] categories = new ValueCategory[values.length];
        for (int i = 0; i < values.length; ++i) {
            categories[i] = values[i].valueGroup().category();
        }
        return this.areValueCategoriesAccepted(categories);
    }

    public boolean isQuerySupported(IndexQuery.IndexQueryType var1, ValueCategory var2);

    public double getCostMultiplier(IndexQuery.IndexQueryType ... var1);

    public boolean supportPartitionedScan(IndexQuery ... var1);

    default public IndexBehaviour[] behaviours() {
        return BEHAVIOURS_NONE;
    }
}

