/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.util.Set;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueRepresentation;

public enum SchemaValueType {
    BOOLEAN("BOOLEAN", ValueRepresentation.BOOLEAN),
    STRING("STRING", ValueRepresentation.UTF8_TEXT, ValueRepresentation.UTF16_TEXT),
    INTEGER("INTEGER", ValueRepresentation.INT64, ValueRepresentation.INT32, ValueRepresentation.INT16, ValueRepresentation.INT8),
    FLOAT("FLOAT", ValueRepresentation.FLOAT64, ValueRepresentation.FLOAT32),
    DURATION("DURATION", ValueRepresentation.DURATION),
    DATE("DATE", ValueRepresentation.DATE),
    ZONED_DATETIME("ZONED DATETIME", ValueRepresentation.ZONED_DATE_TIME),
    LOCAL_DATETIME("LOCAL DATETIME", ValueRepresentation.LOCAL_DATE_TIME),
    ZONED_TIME("ZONED TIME", ValueRepresentation.ZONED_TIME),
    LOCAL_TIME("LOCAL TIME", ValueRepresentation.LOCAL_TIME),
    POINT("POINT", ValueRepresentation.GEOMETRY),
    LIST_BOOLEAN("LIST<BOOLEAN>", ValueRepresentation.BOOLEAN_ARRAY),
    LIST_STRING("LIST<STRING>", ValueRepresentation.TEXT_ARRAY),
    LIST_INTEGER("LIST<INTEGER>", ValueRepresentation.INT64_ARRAY, ValueRepresentation.INT32_ARRAY, ValueRepresentation.INT16_ARRAY, ValueRepresentation.INT8_ARRAY),
    LIST_FLOAT("LIST<FLOAT>", ValueRepresentation.FLOAT64_ARRAY, ValueRepresentation.FLOAT32_ARRAY),
    LIST_DURATION("LIST<DURATION>", ValueRepresentation.DURATION_ARRAY),
    LIST_DATE("LIST<DATE>", ValueRepresentation.DATE_ARRAY),
    LIST_ZONED_DATETIME("LIST<ZONED DATETIME>", ValueRepresentation.ZONED_DATE_TIME_ARRAY),
    LIST_LOCAL_DATETIME("LIST<LOCAL DATETIME>", ValueRepresentation.LOCAL_DATE_TIME_ARRAY),
    LIST_ZONED_TIME("LIST<ZONED TIME>", ValueRepresentation.ZONED_TIME_ARRAY),
    LIST_LOCAL_TIME("LIST<LOCAL TIME>", ValueRepresentation.LOCAL_TIME_ARRAY),
    LIST_POINT("LIST<POINT>", ValueRepresentation.GEOMETRY_ARRAY);

    private final String userDescription;
    private final Set<ValueRepresentation> valueRepresentations;

    private SchemaValueType(String userDescription, ValueRepresentation ... valueRepresentations) {
        this.userDescription = userDescription;
        this.valueRepresentations = Set.of(valueRepresentations);
    }

    public boolean isAssignable(Value value) {
        return this.valueRepresentations.contains(value.valueRepresentation());
    }

    public boolean isAssignable(ValueRepresentation valueRepresentation) {
        return this.valueRepresentations.contains(valueRepresentation);
    }

    public String userDescription() {
        return this.userDescription;
    }

    public String serialize() {
        return this.name();
    }

    public String toString() {
        return this.userDescription;
    }
}

