/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.util.Set;
import org.neo4j.graphdb.schema.PropertyType;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueRepresentation;

public enum SchemaValueType {
    BOOLEAN("BOOLEAN", ValueRepresentation.BOOLEAN),
    STRING("STRING", ValueRepresentation.UTF8_TEXT, ValueRepresentation.UTF16_TEXT),
    INTEGER("INTEGER", ValueRepresentation.INT64, ValueRepresentation.INT32, ValueRepresentation.INT16, ValueRepresentation.INT8),
    FLOAT("FLOAT", ValueRepresentation.FLOAT64, ValueRepresentation.FLOAT32),
    DATE("DATE", ValueRepresentation.DATE),
    LOCAL_TIME("LOCAL TIME", ValueRepresentation.LOCAL_TIME),
    ZONED_TIME("ZONED TIME", ValueRepresentation.ZONED_TIME),
    LOCAL_DATETIME("LOCAL DATETIME", ValueRepresentation.LOCAL_DATE_TIME),
    ZONED_DATETIME("ZONED DATETIME", ValueRepresentation.ZONED_DATE_TIME),
    DURATION("DURATION", ValueRepresentation.DURATION),
    POINT("POINT", ValueRepresentation.GEOMETRY);

    private final String userDescription;
    private final Set<ValueRepresentation> valueRepresentations;

    private SchemaValueType(String userDescription, ValueRepresentation ... valueRepresentations) {
        this.userDescription = userDescription;
        this.valueRepresentations = Set.of(valueRepresentations);
    }

    public boolean isAssignable(Value value) {
        return this.valueRepresentations.contains(value.valueRepresentation());
    }

    public boolean isAssignable(ValueRepresentation valueRepresentation) {
        return this.valueRepresentations.contains(valueRepresentation);
    }

    public String userDescription() {
        return this.userDescription;
    }

    public String serialize() {
        return this.name();
    }

    public String toString() {
        return this.userDescription;
    }

    public static SchemaValueType fromPublicApi(PropertyType propertyType) {
        return switch (propertyType) {
            default -> throw new IncompatibleClassChangeError();
            case PropertyType.BOOLEAN -> BOOLEAN;
            case PropertyType.STRING -> STRING;
            case PropertyType.INTEGER -> INTEGER;
            case PropertyType.FLOAT -> FLOAT;
            case PropertyType.DURATION -> DURATION;
            case PropertyType.DATE -> DATE;
            case PropertyType.ZONED_DATETIME -> ZONED_DATETIME;
            case PropertyType.LOCAL_DATETIME -> LOCAL_DATETIME;
            case PropertyType.ZONED_TIME -> ZONED_TIME;
            case PropertyType.LOCAL_TIME -> LOCAL_TIME;
            case PropertyType.POINT -> POINT;
        };
    }

    public PropertyType toPublicApi() {
        return switch (this) {
            case BOOLEAN -> PropertyType.BOOLEAN;
            case STRING -> PropertyType.STRING;
            case INTEGER -> PropertyType.INTEGER;
            case FLOAT -> PropertyType.FLOAT;
            case DURATION -> PropertyType.DURATION;
            case DATE -> PropertyType.DATE;
            case ZONED_DATETIME -> PropertyType.ZONED_DATETIME;
            case LOCAL_DATETIME -> PropertyType.LOCAL_DATETIME;
            case ZONED_TIME -> PropertyType.ZONED_TIME;
            case LOCAL_TIME -> PropertyType.LOCAL_TIME;
            case POINT -> PropertyType.POINT;
            default -> throw new IllegalArgumentException("Property type '" + this.userDescription() + "' is not supported in Core API yet.");
        };
    }
}

