/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.server.security.auth.ListSnapshot;
import org.neo4j.server.security.auth.User;
import org.neo4j.server.security.auth.exception.ConcurrentModificationException;
import org.neo4j.server.security.enterprise.auth.RoleRecord;

public interface RoleRepository
extends Lifecycle {
    public RoleRecord getRoleByName(String var1);

    public Set<String> getRoleNamesByUsername(String var1);

    public void clear();

    public void create(RoleRecord var1) throws InvalidArgumentsException, IOException;

    public void setRoles(ListSnapshot<RoleRecord> var1) throws InvalidArgumentsException, IOException;

    public void update(RoleRecord var1, RoleRecord var2) throws ConcurrentModificationException, IOException;

    public boolean delete(RoleRecord var1) throws IOException;

    public int numberOfRoles();

    public void assertValidRoleName(String var1) throws InvalidArgumentsException;

    public void removeUserFromAllRoles(String var1) throws ConcurrentModificationException, IOException;

    public Set<String> getAllRoleNames();

    public ListSnapshot<RoleRecord> getPersistedSnapshot() throws IOException;

    public static boolean validate(List<User> users, List<RoleRecord> roles) {
        Set usernamesInRoles = roles.stream().flatMap(rr -> rr.users().stream()).collect(Collectors.toSet());
        Set usernameInUsers = users.stream().map(User::name).collect(Collectors.toSet());
        return usernameInUsers.containsAll(usernamesInRoles);
    }
}

