/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.security.auth.ListSnapshot;
import org.neo4j.server.security.auth.exception.FormatException;
import org.neo4j.server.security.enterprise.auth.AbstractRoleRepository;
import org.neo4j.server.security.enterprise.auth.RoleRecord;
import org.neo4j.server.security.enterprise.auth.RoleSerialization;

public class FileRoleRepository
extends AbstractRoleRepository {
    private final File roleFile;
    private final Log log;
    private final RoleSerialization serialization = new RoleSerialization();
    private final FileSystemAbstraction fileSystem;

    public FileRoleRepository(FileSystemAbstraction fileSystem, File file, LogProvider logProvider) {
        this.roleFile = file;
        this.log = logProvider.getLog(this.getClass());
        this.fileSystem = fileSystem;
    }

    public void start() throws Throwable {
        this.clear();
        ListSnapshot<RoleRecord> onDiskRoles = this.readPersistedRoles();
        if (onDiskRoles != null) {
            this.setRoles(onDiskRoles);
        }
    }

    @Override
    protected ListSnapshot<RoleRecord> readPersistedRoles() throws IOException {
        if (this.fileSystem.fileExists(this.roleFile)) {
            List readRoles;
            long readTime;
            try {
                readTime = this.fileSystem.lastModifiedTime(this.roleFile);
                readRoles = this.serialization.loadRecordsFromFile(this.fileSystem, this.roleFile);
            }
            catch (FormatException e) {
                this.log.error("Failed to read role file \"%s\" (%s)", new Object[]{this.roleFile.getAbsolutePath(), e.getMessage()});
                throw new IllegalStateException("Failed to read role file '" + this.roleFile + "'.");
            }
            return new ListSnapshot(readTime, readRoles, true);
        }
        return null;
    }

    @Override
    protected void persistRoles() throws IOException {
        this.serialization.saveRecordsToFile(this.fileSystem, this.roleFile, this.roles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSnapshot<RoleRecord> getPersistedSnapshot() throws IOException {
        if (this.lastLoaded.get() < this.fileSystem.lastModifiedTime(this.roleFile)) {
            return this.readPersistedRoles();
        }
        FileRoleRepository fileRoleRepository = this;
        synchronized (fileRoleRepository) {
            return new ListSnapshot(this.lastLoaded.get(), this.roles.stream().collect(Collectors.toList()), false);
        }
    }
}

