/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.io.IOException;
import java.util.Set;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.server.security.enterprise.auth.EnterpriseUserManager;
import org.neo4j.server.security.enterprise.auth.RoleRecord;
import org.neo4j.server.security.enterprise.log.SecurityLog;

class PersonalUserManager
implements EnterpriseUserManager {
    private final EnterpriseUserManager userManager;
    private final SecurityContext securityContext;
    private final SecurityLog securityLog;

    PersonalUserManager(EnterpriseUserManager userManager, SecurityContext securityContext, SecurityLog securityLog) {
        this.userManager = userManager;
        this.securityContext = securityContext;
        this.securityLog = securityLog;
    }

    public User newUser(String username, String initialPassword, boolean requirePasswordChange) throws IOException, InvalidArgumentsException, AuthorizationViolationException {
        try {
            this.assertAdmin();
            User user = this.userManager.newUser(username, initialPassword, requirePasswordChange);
            this.securityLog.info(this.securityContext, "created user `%s`%s", username, requirePasswordChange ? ", with password change required" : "");
            return user;
        }
        catch (IOException | AuthorizationViolationException | InvalidArgumentsException e) {
            this.securityLog.error(this.securityContext, "tried to create user `%s`: %s", username, e.getMessage());
            throw e;
        }
    }

    @Override
    public void suspendUser(String username) throws IOException, InvalidArgumentsException, AuthorizationViolationException {
        try {
            this.assertAdmin();
            if (this.securityContext.subject().hasUsername(username)) {
                throw new InvalidArgumentsException("Suspending yourself (user '" + username + "') is not allowed.");
            }
            this.userManager.suspendUser(username);
            this.securityLog.info(this.securityContext, "suspended user `%s`", username);
        }
        catch (IOException | AuthorizationViolationException | InvalidArgumentsException e) {
            this.securityLog.error(this.securityContext, "tried to suspend user `%s`: %s", username, e.getMessage());
            throw e;
        }
    }

    public boolean deleteUser(String username) throws IOException, InvalidArgumentsException, AuthorizationViolationException {
        try {
            this.assertAdmin();
            if (this.securityContext.subject().hasUsername(username)) {
                throw new InvalidArgumentsException("Deleting yourself (user '" + username + "') is not allowed.");
            }
            boolean wasDeleted = this.userManager.deleteUser(username);
            this.securityLog.info(this.securityContext, "deleted user `%s`", username);
            return wasDeleted;
        }
        catch (IOException | AuthorizationViolationException | InvalidArgumentsException e) {
            this.securityLog.error(this.securityContext, "tried to delete user `%s`: %s", username, e.getMessage());
            throw e;
        }
    }

    @Override
    public void activateUser(String username, boolean requirePasswordChange) throws IOException, InvalidArgumentsException, AuthorizationViolationException {
        try {
            this.assertAdmin();
            if (this.securityContext.subject().hasUsername(username)) {
                throw new InvalidArgumentsException("Activating yourself (user '" + username + "') is not allowed.");
            }
            this.userManager.activateUser(username, requirePasswordChange);
            this.securityLog.info(this.securityContext, "activated user `%s`", username);
        }
        catch (IOException | AuthorizationViolationException | InvalidArgumentsException e) {
            this.securityLog.error(this.securityContext, "tried to activate user `%s`: %s", username, e.getMessage());
            throw e;
        }
    }

    public User getUser(String username) throws InvalidArgumentsException {
        return this.userManager.getUser(username);
    }

    public User silentlyGetUser(String username) {
        return this.userManager.silentlyGetUser(username);
    }

    @Override
    public RoleRecord newRole(String roleName, String ... usernames) throws IOException, InvalidArgumentsException, AuthorizationViolationException {
        try {
            this.assertAdmin();
            RoleRecord newRole = this.userManager.newRole(roleName, usernames);
            this.securityLog.info(this.securityContext, "created role `%s`", roleName);
            return newRole;
        }
        catch (IOException | AuthorizationViolationException | InvalidArgumentsException e) {
            this.securityLog.error(this.securityContext, "tried to create role `%s`: %s", roleName, e.getMessage());
            throw e;
        }
    }

    @Override
    public boolean deleteRole(String roleName) throws IOException, InvalidArgumentsException, AuthorizationViolationException {
        try {
            this.assertAdmin();
            boolean wasDeleted = this.userManager.deleteRole(roleName);
            this.securityLog.info(this.securityContext, "deleted role `%s`", roleName);
            return wasDeleted;
        }
        catch (IOException | AuthorizationViolationException | InvalidArgumentsException e) {
            this.securityLog.error(this.securityContext, "tried to delete role `%s`: %s", roleName, e.getMessage());
            throw e;
        }
    }

    public void setUserPassword(String username, String password, boolean requirePasswordChange) throws IOException, InvalidArgumentsException, AuthorizationViolationException {
        if (this.securityContext.subject().hasUsername(username)) {
            try {
                this.userManager.setUserPassword(username, password, requirePasswordChange);
                this.securityLog.info(this.securityContext, "changed password%s", requirePasswordChange ? ", with password change required" : "");
            }
            catch (IOException | AuthorizationViolationException | InvalidArgumentsException e) {
                this.securityLog.error(this.securityContext, "tried to change password: %s", e.getMessage());
                throw e;
            }
        }
        try {
            this.assertAdmin();
            this.userManager.setUserPassword(username, password, requirePasswordChange);
            this.securityLog.info(this.securityContext, "changed password for user `%s`%s", username, requirePasswordChange ? ", with password change required" : "");
        }
        catch (IOException | AuthorizationViolationException | InvalidArgumentsException e) {
            this.securityLog.error(this.securityContext, "tried to change password for user `%s`: %s", username, e.getMessage());
            throw e;
        }
    }

    public Set<String> getAllUsernames() throws AuthorizationViolationException {
        try {
            this.assertAdmin();
            return this.userManager.getAllUsernames();
        }
        catch (AuthorizationViolationException e) {
            this.securityLog.error(this.securityContext, "tried to list users: %s", e.getMessage());
            throw e;
        }
    }

    @Override
    public RoleRecord getRole(String roleName) throws InvalidArgumentsException {
        return this.userManager.getRole(roleName);
    }

    @Override
    public RoleRecord silentlyGetRole(String roleName) {
        return this.userManager.silentlyGetRole(roleName);
    }

    @Override
    public void addRoleToUser(String roleName, String username) throws IOException, InvalidArgumentsException, AuthorizationViolationException {
        try {
            this.assertAdmin();
            this.userManager.addRoleToUser(roleName, username);
            this.securityLog.info(this.securityContext, "added role `%s` to user `%s`", roleName, username);
        }
        catch (IOException | AuthorizationViolationException | InvalidArgumentsException e) {
            this.securityLog.error(this.securityContext, "tried to add role `%s` to user `%s`: %s", roleName, username, e.getMessage());
            throw e;
        }
    }

    @Override
    public void removeRoleFromUser(String roleName, String username) throws IOException, InvalidArgumentsException, AuthorizationViolationException {
        try {
            this.assertAdmin();
            if (this.securityContext.subject().hasUsername(username) && roleName.equals("admin")) {
                throw new InvalidArgumentsException("Removing yourself (user '" + username + "') from the admin role is not allowed.");
            }
            this.userManager.removeRoleFromUser(roleName, username);
            this.securityLog.info(this.securityContext, "removed role `%s` from user `%s`", roleName, username);
        }
        catch (IOException | AuthorizationViolationException | InvalidArgumentsException e) {
            this.securityLog.error(this.securityContext, "tried to remove role `%s` from user `%s`: %s", roleName, username, e.getMessage());
            throw e;
        }
    }

    @Override
    public Set<String> getAllRoleNames() throws AuthorizationViolationException {
        try {
            this.assertAdmin();
            return this.userManager.getAllRoleNames();
        }
        catch (AuthorizationViolationException e) {
            this.securityLog.error(this.securityContext, "tried to list roles: %s", e.getMessage());
            throw e;
        }
    }

    @Override
    public Set<String> getRoleNamesForUser(String username) throws InvalidArgumentsException, AuthorizationViolationException {
        try {
            this.assertSelfOrAdmin(username);
            return this.userManager.getRoleNamesForUser(username);
        }
        catch (AuthorizationViolationException | InvalidArgumentsException e) {
            this.securityLog.error(this.securityContext, "tried to list roles for user `%s`: %s", username, e.getMessage());
            throw e;
        }
    }

    @Override
    public Set<String> silentlyGetRoleNamesForUser(String username) {
        return this.userManager.silentlyGetRoleNamesForUser(username);
    }

    @Override
    public Set<String> getUsernamesForRole(String roleName) throws InvalidArgumentsException, AuthorizationViolationException {
        try {
            this.assertAdmin();
            return this.userManager.getUsernamesForRole(roleName);
        }
        catch (AuthorizationViolationException | InvalidArgumentsException e) {
            this.securityLog.error(this.securityContext, "tried to list users for role `%s`: %s", roleName, e.getMessage());
            throw e;
        }
    }

    @Override
    public Set<String> silentlyGetUsernamesForRole(String roleName) {
        return this.userManager.silentlyGetUsernamesForRole(roleName);
    }

    private void assertSelfOrAdmin(String username) {
        if (!this.securityContext.subject().hasUsername(username)) {
            this.assertAdmin();
        }
    }

    private void assertAdmin() throws AuthorizationViolationException {
        if (!this.securityContext.isAdmin()) {
            throw new AuthorizationViolationException("Permission denied.");
        }
    }
}

