/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.shiro.authz.AuthorizationInfo;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.security.AuthSubject;
import org.neo4j.kernel.api.security.AuthenticationResult;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.enterprise.api.security.EnterpriseSecurityContext;
import org.neo4j.server.security.enterprise.auth.EnterpriseUserManager;
import org.neo4j.server.security.enterprise.auth.MultiRealmAuthManager;
import org.neo4j.server.security.enterprise.auth.ShiroSubject;

class StandardEnterpriseSecurityContext
implements EnterpriseSecurityContext {
    private static final String SCHEMA_READ_WRITE = "schema:read,write";
    private static final String TOKEN_CREATE = "token:create";
    private static final String READ_WRITE = "data:read,write";
    private static final String READ = "data:read";
    private final MultiRealmAuthManager authManager;
    private final ShiroSubject shiroSubject;
    private final NeoShiroSubject neoShiroSubject;

    StandardEnterpriseSecurityContext(MultiRealmAuthManager authManager, ShiroSubject shiroSubject) {
        this.authManager = authManager;
        this.shiroSubject = shiroSubject;
        this.neoShiroSubject = new NeoShiroSubject();
    }

    public EnterpriseUserManager getUserManager() {
        return this.authManager.getUserManager((SecurityContext)this);
    }

    public boolean isAdmin() {
        return this.shiroSubject.isAuthenticated() && this.shiroSubject.isPermitted("*");
    }

    public AuthSubject subject() {
        return this.neoShiroSubject;
    }

    public StandardAccessMode mode() {
        boolean isAuthenticated = this.shiroSubject.isAuthenticated();
        return new StandardAccessMode(isAuthenticated && this.shiroSubject.isPermitted(READ), isAuthenticated && this.shiroSubject.isPermitted(READ_WRITE), isAuthenticated && this.shiroSubject.isPermitted(TOKEN_CREATE), isAuthenticated && this.shiroSubject.isPermitted(SCHEMA_READ_WRITE), this.shiroSubject.getAuthenticationResult() == AuthenticationResult.PASSWORD_CHANGE_REQUIRED, this.queryForRoleNames());
    }

    public String toString() {
        return this.defaultString("enterprise-security-context");
    }

    public EnterpriseSecurityContext freeze() {
        StandardAccessMode mode = this.mode();
        return new EnterpriseSecurityContext.Frozen((AuthSubject)this.neoShiroSubject, (AccessMode)mode, mode.roles, this.isAdmin());
    }

    public EnterpriseSecurityContext withMode(AccessMode mode) {
        return new EnterpriseSecurityContext.Frozen((AuthSubject)this.neoShiroSubject, mode, this.queryForRoleNames(), this.isAdmin());
    }

    public Set<String> roles() {
        return this.queryForRoleNames();
    }

    private Set<String> queryForRoleNames() {
        Collection<AuthorizationInfo> authorizationInfo = this.authManager.getAuthorizationInfo(this.shiroSubject.getPrincipals());
        return authorizationInfo.stream().flatMap(authInfo -> {
            Collection roles = authInfo.getRoles();
            return roles == null ? Stream.empty() : roles.stream();
        }).collect(Collectors.toSet());
    }

    private class NeoShiroSubject
    implements AuthSubject {
        private NeoShiroSubject() {
        }

        public String username() {
            Object principal = StandardEnterpriseSecurityContext.this.shiroSubject.getPrincipal();
            if (principal != null) {
                return principal.toString();
            }
            return "";
        }

        public void logout() {
            StandardEnterpriseSecurityContext.this.shiroSubject.logout();
        }

        public AuthenticationResult getAuthenticationResult() {
            return StandardEnterpriseSecurityContext.this.shiroSubject.getAuthenticationResult();
        }

        public void setPasswordChangeNoLongerRequired() {
            if (this.getAuthenticationResult() == AuthenticationResult.PASSWORD_CHANGE_REQUIRED) {
                StandardEnterpriseSecurityContext.this.shiroSubject.setAuthenticationResult(AuthenticationResult.SUCCESS);
            }
        }

        public boolean hasUsername(String username) {
            Object principal = StandardEnterpriseSecurityContext.this.shiroSubject.getPrincipal();
            return principal != null && username != null && username.equals(principal);
        }
    }

    private static class StandardAccessMode
    implements AccessMode {
        private final boolean allowsReads;
        private final boolean allowsWrites;
        private final boolean allowsSchemaWrites;
        private final boolean allowsTokenCreates;
        private final boolean passwordChangeRequired;
        private final Set<String> roles;

        StandardAccessMode(boolean allowsReads, boolean allowsWrites, boolean allowsTokenCreates, boolean allowsSchemaWrites, boolean passwordChangeRequired, Set<String> roles) {
            this.allowsReads = allowsReads;
            this.allowsWrites = allowsWrites;
            this.allowsTokenCreates = allowsTokenCreates;
            this.allowsSchemaWrites = allowsSchemaWrites;
            this.passwordChangeRequired = passwordChangeRequired;
            this.roles = roles;
        }

        public boolean allowsReads() {
            return this.allowsReads;
        }

        public boolean allowsWrites() {
            return this.allowsWrites;
        }

        public boolean allowsTokenCreates() {
            return this.allowsTokenCreates;
        }

        public boolean allowsSchemaWrites() {
            return this.allowsSchemaWrites;
        }

        public boolean allowsProcedureWith(String[] roleNames) throws InvalidArgumentsException {
            for (int i = 0; i < roleNames.length; ++i) {
                if (!this.roles.contains(roleNames[i])) continue;
                return true;
            }
            return false;
        }

        public AuthorizationViolationException onViolation(String msg) {
            if (this.passwordChangeRequired) {
                return AccessMode.Static.CREDENTIALS_EXPIRED.onViolation(msg);
            }
            return new AuthorizationViolationException(msg);
        }

        public String name() {
            TreeSet<String> sortedRoles = new TreeSet<String>(this.roles);
            return this.roles.isEmpty() ? "no roles" : "roles [" + String.join((CharSequence)",", sortedRoles) + "]";
        }
    }
}

