/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.admin.security;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.cli.AbstractAdminCommand;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.commandline.admin.security.PasswordCommand;
import org.neo4j.commandline.admin.security.exception.InvalidPasswordException;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.ConfigUtils;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.security.Credential;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.server.security.auth.CommunitySecurityModule;
import org.neo4j.server.security.auth.FileUserRepository;
import org.neo4j.string.UTF8;
import org.neo4j.util.VisibleForTesting;
import picocli.CommandLine;

@CommandLine.Command(name="set-initial-password", description={"Sets the initial password of the initial admin user ('neo4j'). And removes the requirement to change password on first login. IMPORTANT: this change will only take effect if performed before the database is started for the first time."})
public class SetInitialPasswordCommand
extends AbstractAdminCommand
implements PasswordCommand {
    @CommandLine.Option(names={"--require-password-change"}, arity="0..1", paramLabel="true|false", showDefaultValue=CommandLine.Help.Visibility.ALWAYS, defaultValue="false", fallbackValue="true", description={"Require the user to change their password on first login."})
    private boolean changeRequired;
    @CommandLine.Parameters
    private String password;

    public SetInitialPasswordCommand(ExecutionContext ctx) {
        super(ctx);
    }

    public void execute() throws IOException {
        Config config = this.loadNeo4jConfig();
        SetInitialPasswordCommand.validatePassword(this.password, config);
        FileSystemAbstraction fileSystem = this.ctx.fs();
        Path file = CommunitySecurityModule.getInitialUserRepositoryFile(config);
        EmptyMemoryTracker memoryTracker = EmptyMemoryTracker.INSTANCE;
        if (fileSystem.fileExists(file)) {
            fileSystem.deleteFile(file);
        }
        FileUserRepository userRepository = new FileUserRepository(fileSystem, file, (InternalLogProvider)NullLogProvider.getInstance(), (MemoryTracker)memoryTracker);
        try {
            userRepository.start();
            userRepository.create(new User("neo4j", null, (Credential)this.createCredentialForPassword(UTF8.encode((String)this.password)), this.changeRequired, false));
            userRepository.shutdown();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.ctx.out().println("Changed password for user 'neo4j'. IMPORTANT: this change will only take effect if performed before the database is started for the first time.");
    }

    @VisibleForTesting
    Config loadNeo4jConfig() {
        Config cfg = Config.newBuilder().set(GraphDatabaseSettings.neo4j_home, (Object)this.ctx.homeDir().toAbsolutePath()).fromFileNoThrow(this.ctx.confDir().resolve("neo4j.conf")).commandExpansion(this.allowCommandExpansion).build();
        ConfigUtils.disableAllConnectors((Config)cfg);
        return cfg;
    }

    private static void validatePassword(String password, Config config) {
        Integer minimumPasswordLength = (Integer)config.get(GraphDatabaseSettings.auth_minimum_password_length);
        if (password == null || password.isEmpty()) {
            throw InvalidArgumentException.providedPasswordEmpty();
        }
        if (password.codePoints().count() < (long)minimumPasswordLength.intValue()) {
            throw InvalidPasswordException.shortPassword(minimumPasswordLength);
        }
    }
}

