/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.systemgraph;

import java.util.Map;
import org.neo4j.exceptions.InvalidArgumentException;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.AuthToken;
import org.neo4j.kernel.api.security.exception.InvalidAuthTokenException;
import org.neo4j.kernel.impl.security.User;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.BasicLoginContext;
import org.neo4j.server.security.systemgraph.SecurityGraphHelper;

public class BasicSystemGraphRealm
extends AuthManager {
    private final SecurityGraphHelper securityGraphHelper;
    private final AuthenticationStrategy authenticationStrategy;

    public BasicSystemGraphRealm(SecurityGraphHelper securityGraphHelper, AuthenticationStrategy authenticationStrategy) {
        this.securityGraphHelper = securityGraphHelper;
        this.authenticationStrategy = authenticationStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoginContext login(Map<String, Object> authToken, ClientConnectionInfo connectionInfo) throws InvalidAuthTokenException {
        try {
            BasicSystemGraphRealm.assertValidScheme(authToken);
            String username = AuthToken.safeCast((String)"principal", authToken);
            byte[] password = AuthToken.safeCastCredentials((String)"credentials", authToken);
            User user = this.securityGraphHelper.getUserByName(username);
            if (user == null) {
                BasicLoginContext basicLoginContext = new BasicLoginContext(null, AuthenticationResult.FAILURE, connectionInfo);
                return basicLoginContext;
            }
            AuthenticationResult result = this.authenticationStrategy.authenticate(user, password);
            if (result == AuthenticationResult.SUCCESS && user.passwordChangeRequired()) {
                result = AuthenticationResult.PASSWORD_CHANGE_REQUIRED;
            }
            BasicLoginContext basicLoginContext = new BasicLoginContext(user, result, connectionInfo);
            return basicLoginContext;
        }
        finally {
            AuthToken.clearCredentials(authToken);
        }
    }

    public LoginContext impersonate(LoginContext originalAuth, String userToImpersonate) {
        throw InvalidArgumentException.unsupportedInCommunity((String)"Impersonation");
    }

    private static void assertValidScheme(Map<String, Object> token) throws InvalidAuthTokenException {
        String scheme = AuthToken.safeCast((String)"scheme", token);
        if (scheme.equals("none")) {
            throw AuthToken.invalidToken((String)", scheme 'none' is only allowed when auth is disabled.");
        }
        if (!scheme.equals("basic")) {
            throw AuthToken.invalidToken((String)(", scheme '" + scheme + "' is not supported."));
        }
    }
}

