/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import org.neo4j.string.HexString;
import org.neo4j.string.UTF8;

public class Credential {
    public static final String DIGEST_ALGO = "SHA-256";
    public static final Credential INACCESSIBLE = new Credential(new byte[0], new byte[0]);
    private final byte[] salt;
    private final byte[] passwordHash;

    public static Credential forPassword(String password) {
        byte[] salt = Credential.randomSalt();
        return new Credential(salt, Credential.hash(salt, password));
    }

    public Credential(byte[] salt, byte[] passwordHash) {
        this.salt = salt;
        this.passwordHash = passwordHash;
    }

    public byte[] salt() {
        return this.salt;
    }

    public byte[] passwordHash() {
        return this.passwordHash;
    }

    public boolean matchesPassword(String password) {
        return Arrays.equals(this.passwordHash, Credential.hash(this.salt, password));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Credential that = (Credential)o;
        return Arrays.equals(this.salt, that.salt) && Arrays.equals(this.passwordHash, that.passwordHash);
    }

    public int hashCode() {
        return 31 * Arrays.hashCode(this.salt) + Arrays.hashCode(this.passwordHash);
    }

    public String toString() {
        return "Credential{salt=0x" + HexString.encodeHexString((byte[])this.salt) + ", passwordHash=0x" + HexString.encodeHexString((byte[])this.passwordHash) + '}';
    }

    private static byte[] hash(byte[] salt, String password) {
        try {
            byte[] passwordBytes = UTF8.encode((String)password);
            MessageDigest m = MessageDigest.getInstance(DIGEST_ALGO);
            m.update(salt, 0, salt.length);
            m.update(passwordBytes, 0, passwordBytes.length);
            return m.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Hash algorithm is not available on this platform: " + e.getMessage(), e);
        }
    }

    private static byte[] randomSalt() {
        byte[] salt = new byte[16];
        ThreadLocalRandom.current().nextBytes(salt);
        return salt;
    }
}

